/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum SampleType {
    CPU("CPU"),

    MEMORY("MEMORY"),

    THREADS("THREADS"),

    RX_RATE("RX_RATE"),

    TX_RATE("TX_RATE"),

    RX("RX"),

    TX("TX"),

    NATIVE_FRAMES("NATIVE_FRAMES"),

    NATIVE_FPS("NATIVE_FPS"),

    NATIVE_MIN_DRAWTIME("NATIVE_MIN_DRAWTIME"),

    NATIVE_AVG_DRAWTIME("NATIVE_AVG_DRAWTIME"),

    NATIVE_MAX_DRAWTIME("NATIVE_MAX_DRAWTIME"),

    OPENGL_FRAMES("OPENGL_FRAMES"),

    OPENGL_FPS("OPENGL_FPS"),

    OPENGL_MIN_DRAWTIME("OPENGL_MIN_DRAWTIME"),

    OPENGL_AVG_DRAWTIME("OPENGL_AVG_DRAWTIME"),

    OPENGL_MAX_DRAWTIME("OPENGL_MAX_DRAWTIME"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SampleType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SampleType corresponding to the value
     */
    public static SampleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SampleType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SampleType}s
     */
    public static Set<SampleType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
