/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server after AWS Device Farm makes a request to install to a remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstallToRemoteAccessSessionResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<InstallToRemoteAccessSessionResponse.Builder, InstallToRemoteAccessSessionResponse> {
    private static final SdkField<Upload> APP_UPLOAD_FIELD = SdkField.<Upload> builder(MarshallingType.SDK_POJO)
            .getter(getter(InstallToRemoteAccessSessionResponse::appUpload)).setter(setter(Builder::appUpload))
            .constructor(Upload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appUpload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_UPLOAD_FIELD));

    private final Upload appUpload;

    private InstallToRemoteAccessSessionResponse(BuilderImpl builder) {
        super(builder);
        this.appUpload = builder.appUpload;
    }

    /**
     * <p>
     * An app to upload or that has been uploaded.
     * </p>
     * 
     * @return An app to upload or that has been uploaded.
     */
    public Upload appUpload() {
        return appUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appUpload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstallToRemoteAccessSessionResponse)) {
            return false;
        }
        InstallToRemoteAccessSessionResponse other = (InstallToRemoteAccessSessionResponse) obj;
        return Objects.equals(appUpload(), other.appUpload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstallToRemoteAccessSessionResponse").add("AppUpload", appUpload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appUpload":
            return Optional.ofNullable(clazz.cast(appUpload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstallToRemoteAccessSessionResponse, T> g) {
        return obj -> g.apply((InstallToRemoteAccessSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, InstallToRemoteAccessSessionResponse> {
        /**
         * <p>
         * An app to upload or that has been uploaded.
         * </p>
         * 
         * @param appUpload
         *        An app to upload or that has been uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appUpload(Upload appUpload);

        /**
         * <p>
         * An app to upload or that has been uploaded.
         * </p>
         * This is a convenience that creates an instance of the {@link Upload.Builder} avoiding the need to create one
         * manually via {@link Upload#builder()}.
         *
         * When the {@link Consumer} completes, {@link Upload.Builder#build()} is called immediately and its result is
         * passed to {@link #appUpload(Upload)}.
         * 
         * @param appUpload
         *        a consumer that will call methods on {@link Upload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appUpload(Upload)
         */
        default Builder appUpload(Consumer<Upload.Builder> appUpload) {
            return appUpload(Upload.builder().applyMutation(appUpload).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Upload appUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(InstallToRemoteAccessSessionResponse model) {
            super(model);
            appUpload(model.appUpload);
        }

        public final Upload.Builder getAppUpload() {
            return appUpload != null ? appUpload.toBuilder() : null;
        }

        @Override
        public final Builder appUpload(Upload appUpload) {
            this.appUpload = appUpload;
            return this;
        }

        public final void setAppUpload(Upload.BuilderImpl appUpload) {
            this.appUpload = appUpload != null ? appUpload.build() : null;
        }

        @Override
        public InstallToRemoteAccessSessionResponse build() {
            return new InstallToRemoteAccessSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
