/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestGridSessionResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetTestGridSessionResponse.Builder, GetTestGridSessionResponse> {
    private static final SdkField<TestGridSession> TEST_GRID_SESSION_FIELD = SdkField
            .<TestGridSession> builder(MarshallingType.SDK_POJO).getter(getter(GetTestGridSessionResponse::testGridSession))
            .setter(setter(Builder::testGridSession)).constructor(TestGridSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testGridSession").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_GRID_SESSION_FIELD));

    private final TestGridSession testGridSession;

    private GetTestGridSessionResponse(BuilderImpl builder) {
        super(builder);
        this.testGridSession = builder.testGridSession;
    }

    /**
     * <p>
     * The <a>TestGridSession</a> that was requested.
     * </p>
     * 
     * @return The <a>TestGridSession</a> that was requested.
     */
    public TestGridSession testGridSession() {
        return testGridSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testGridSession());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestGridSessionResponse)) {
            return false;
        }
        GetTestGridSessionResponse other = (GetTestGridSessionResponse) obj;
        return Objects.equals(testGridSession(), other.testGridSession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTestGridSessionResponse").add("TestGridSession", testGridSession()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testGridSession":
            return Optional.ofNullable(clazz.cast(testGridSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTestGridSessionResponse, T> g) {
        return obj -> g.apply((GetTestGridSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTestGridSessionResponse> {
        /**
         * <p>
         * The <a>TestGridSession</a> that was requested.
         * </p>
         * 
         * @param testGridSession
         *        The <a>TestGridSession</a> that was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testGridSession(TestGridSession testGridSession);

        /**
         * <p>
         * The <a>TestGridSession</a> that was requested.
         * </p>
         * This is a convenience that creates an instance of the {@link TestGridSession.Builder} avoiding the need to
         * create one manually via {@link TestGridSession#builder()}.
         *
         * When the {@link Consumer} completes, {@link TestGridSession.Builder#build()} is called immediately and its
         * result is passed to {@link #testGridSession(TestGridSession)}.
         * 
         * @param testGridSession
         *        a consumer that will call methods on {@link TestGridSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testGridSession(TestGridSession)
         */
        default Builder testGridSession(Consumer<TestGridSession.Builder> testGridSession) {
            return testGridSession(TestGridSession.builder().applyMutation(testGridSession).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private TestGridSession testGridSession;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestGridSessionResponse model) {
            super(model);
            testGridSession(model.testGridSession);
        }

        public final TestGridSession.Builder getTestGridSession() {
            return testGridSession != null ? testGridSession.toBuilder() : null;
        }

        @Override
        public final Builder testGridSession(TestGridSession testGridSession) {
            this.testGridSession = testGridSession;
            return this;
        }

        public final void setTestGridSession(TestGridSession.BuilderImpl testGridSession) {
            this.testGridSession = testGridSession != null ? testGridSession.build() : null;
        }

        @Override
        public GetTestGridSessionResponse build() {
            return new GetTestGridSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
