/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopJobResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<StopJobResponse.Builder, StopJobResponse> {
    private static final SdkField<Job> JOB_FIELD = SdkField.<Job> builder(MarshallingType.SDK_POJO)
            .getter(getter(StopJobResponse::job)).setter(setter(Builder::job)).constructor(Job::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("job").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FIELD));

    private final Job job;

    private StopJobResponse(BuilderImpl builder) {
        super(builder);
        this.job = builder.job;
    }

    /**
     * <p>
     * The job that was stopped.
     * </p>
     * 
     * @return The job that was stopped.
     */
    public Job job() {
        return job;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(job());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopJobResponse)) {
            return false;
        }
        StopJobResponse other = (StopJobResponse) obj;
        return Objects.equals(job(), other.job());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StopJobResponse").add("Job", job()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "job":
            return Optional.ofNullable(clazz.cast(job()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopJobResponse, T> g) {
        return obj -> g.apply((StopJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopJobResponse> {
        /**
         * <p>
         * The job that was stopped.
         * </p>
         * 
         * @param job
         *        The job that was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder job(Job job);

        /**
         * <p>
         * The job that was stopped.
         * </p>
         * This is a convenience that creates an instance of the {@link Job.Builder} avoiding the need to create one
         * manually via {@link Job#builder()}.
         *
         * When the {@link Consumer} completes, {@link Job.Builder#build()} is called immediately and its result is
         * passed to {@link #job(Job)}.
         * 
         * @param job
         *        a consumer that will call methods on {@link Job.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #job(Job)
         */
        default Builder job(Consumer<Job.Builder> job) {
            return job(Job.builder().applyMutation(job).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Job job;

        private BuilderImpl() {
        }

        private BuilderImpl(StopJobResponse model) {
            super(model);
            job(model.job);
        }

        public final Job.Builder getJob() {
            return job != null ? job.toBuilder() : null;
        }

        @Override
        public final Builder job(Job job) {
            this.job = job;
            return this;
        }

        public final void setJob(Job.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        @Override
        public StopJobResponse build() {
            return new StopJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
