/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a latitude and longitude pair, expressed in geographic coordinate system degrees (for example, 47.6204,
 * -122.3491).
 * </p>
 * <p>
 * Elevation is currently not supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Location implements SdkPojo, Serializable, ToCopyableBuilder<Location.Builder, Location> {
    private static final SdkField<Double> LATITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Location::latitude)).setter(setter(Builder::latitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latitude").build()).build();

    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Location::longitude)).setter(setter(Builder::longitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longitude").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATITUDE_FIELD,
            LONGITUDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double latitude;

    private final Double longitude;

    private Location(BuilderImpl builder) {
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    /**
     * <p>
     * The latitude.
     * </p>
     * 
     * @return The latitude.
     */
    public Double latitude() {
        return latitude;
    }

    /**
     * <p>
     * The longitude.
     * </p>
     * 
     * @return The longitude.
     */
    public Double longitude() {
        return longitude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latitude());
        hashCode = 31 * hashCode + Objects.hashCode(longitude());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location) obj;
        return Objects.equals(latitude(), other.latitude()) && Objects.equals(longitude(), other.longitude());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Location").add("Latitude", latitude()).add("Longitude", longitude()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latitude":
            return Optional.ofNullable(clazz.cast(latitude()));
        case "longitude":
            return Optional.ofNullable(clazz.cast(longitude()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Location> {
        /**
         * <p>
         * The latitude.
         * </p>
         * 
         * @param latitude
         *        The latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latitude(Double latitude);

        /**
         * <p>
         * The longitude.
         * </p>
         * 
         * @param longitude
         *        The longitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longitude(Double longitude);
    }

    static final class BuilderImpl implements Builder {
        private Double latitude;

        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            latitude(model.latitude);
            longitude(model.longitude);
        }

        public final Double getLatitude() {
            return latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public final Double getLongitude() {
            return longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public Location build() {
            return new Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
