/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionStatus;
import software.amazon.awssdk.services.devicefarm.model.InteractionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoteAccessSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemoteAccessSession> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::arn)).setter(RemoteAccessSession.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::name)).setter(RemoteAccessSession.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RemoteAccessSession.getter(RemoteAccessSession::created)).setter(RemoteAccessSession.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::statusAsString)).setter(RemoteAccessSession.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::resultAsString)).setter(RemoteAccessSession.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::message)).setter(RemoteAccessSession.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Instant> STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RemoteAccessSession.getter(RemoteAccessSession::started)).setter(RemoteAccessSession.setter(Builder::started)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("started").build()}).build();
    private static final SdkField<Instant> STOPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RemoteAccessSession.getter(RemoteAccessSession::stopped)).setter(RemoteAccessSession.setter(Builder::stopped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopped").build()}).build();
    private static final SdkField<Device> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RemoteAccessSession.getter(RemoteAccessSession::device)).setter(RemoteAccessSession.setter(Builder::device)).constructor(Device::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::instanceArn)).setter(RemoteAccessSession.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<Boolean> REMOTE_DEBUG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RemoteAccessSession.getter(RemoteAccessSession::remoteDebugEnabled)).setter(RemoteAccessSession.setter(Builder::remoteDebugEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteDebugEnabled").build()}).build();
    private static final SdkField<Boolean> REMOTE_RECORD_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RemoteAccessSession.getter(RemoteAccessSession::remoteRecordEnabled)).setter(RemoteAccessSession.setter(Builder::remoteRecordEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteRecordEnabled").build()}).build();
    private static final SdkField<String> REMOTE_RECORD_APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::remoteRecordAppArn)).setter(RemoteAccessSession.setter(Builder::remoteRecordAppArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteRecordAppArn").build()}).build();
    private static final SdkField<String> HOST_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::hostAddress)).setter(RemoteAccessSession.setter(Builder::hostAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostAddress").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::clientId)).setter(RemoteAccessSession.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> BILLING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::billingMethodAsString)).setter(RemoteAccessSession.setter(Builder::billingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMethod").build()}).build();
    private static final SdkField<DeviceMinutes> DEVICE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RemoteAccessSession.getter(RemoteAccessSession::deviceMinutes)).setter(RemoteAccessSession.setter(Builder::deviceMinutes)).constructor(DeviceMinutes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMinutes").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::endpoint)).setter(RemoteAccessSession.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> DEVICE_UDID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::deviceUdid)).setter(RemoteAccessSession.setter(Builder::deviceUdid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceUdid").build()}).build();
    private static final SdkField<String> INTERACTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoteAccessSession.getter(RemoteAccessSession::interactionModeAsString)).setter(RemoteAccessSession.setter(Builder::interactionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactionMode").build()}).build();
    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RemoteAccessSession.getter(RemoteAccessSession::skipAppResign)).setter(RemoteAccessSession.setter(Builder::skipAppResign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, CREATED_FIELD, STATUS_FIELD, RESULT_FIELD, MESSAGE_FIELD, STARTED_FIELD, STOPPED_FIELD, DEVICE_FIELD, INSTANCE_ARN_FIELD, REMOTE_DEBUG_ENABLED_FIELD, REMOTE_RECORD_ENABLED_FIELD, REMOTE_RECORD_APP_ARN_FIELD, HOST_ADDRESS_FIELD, CLIENT_ID_FIELD, BILLING_METHOD_FIELD, DEVICE_MINUTES_FIELD, ENDPOINT_FIELD, DEVICE_UDID_FIELD, INTERACTION_MODE_FIELD, SKIP_APP_RESIGN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final Instant created;
    private final String status;
    private final String result;
    private final String message;
    private final Instant started;
    private final Instant stopped;
    private final Device device;
    private final String instanceArn;
    private final Boolean remoteDebugEnabled;
    private final Boolean remoteRecordEnabled;
    private final String remoteRecordAppArn;
    private final String hostAddress;
    private final String clientId;
    private final String billingMethod;
    private final DeviceMinutes deviceMinutes;
    private final String endpoint;
    private final String deviceUdid;
    private final String interactionMode;
    private final Boolean skipAppResign;

    private RemoteAccessSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.message = builder.message;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.device = builder.device;
        this.instanceArn = builder.instanceArn;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.remoteRecordEnabled = builder.remoteRecordEnabled;
        this.remoteRecordAppArn = builder.remoteRecordAppArn;
        this.hostAddress = builder.hostAddress;
        this.clientId = builder.clientId;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.endpoint = builder.endpoint;
        this.deviceUdid = builder.deviceUdid;
        this.interactionMode = builder.interactionMode;
        this.skipAppResign = builder.skipAppResign;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public Instant created() {
        return this.created;
    }

    public ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public ExecutionResult result() {
        return ExecutionResult.fromValue(this.result);
    }

    public String resultAsString() {
        return this.result;
    }

    public String message() {
        return this.message;
    }

    public Instant started() {
        return this.started;
    }

    public Instant stopped() {
        return this.stopped;
    }

    public Device device() {
        return this.device;
    }

    public String instanceArn() {
        return this.instanceArn;
    }

    public Boolean remoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    public Boolean remoteRecordEnabled() {
        return this.remoteRecordEnabled;
    }

    public String remoteRecordAppArn() {
        return this.remoteRecordAppArn;
    }

    public String hostAddress() {
        return this.hostAddress;
    }

    public String clientId() {
        return this.clientId;
    }

    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public String billingMethodAsString() {
        return this.billingMethod;
    }

    public DeviceMinutes deviceMinutes() {
        return this.deviceMinutes;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String deviceUdid() {
        return this.deviceUdid;
    }

    public InteractionMode interactionMode() {
        return InteractionMode.fromValue(this.interactionMode);
    }

    public String interactionModeAsString() {
        return this.interactionMode;
    }

    public Boolean skipAppResign() {
        return this.skipAppResign;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.started());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopped());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteRecordEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteRecordAppArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceUdid());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipAppResign());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessSession)) {
            return false;
        }
        RemoteAccessSession other = (RemoteAccessSession)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.started(), other.started()) && Objects.equals(this.stopped(), other.stopped()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.remoteDebugEnabled(), other.remoteDebugEnabled()) && Objects.equals(this.remoteRecordEnabled(), other.remoteRecordEnabled()) && Objects.equals(this.remoteRecordAppArn(), other.remoteRecordAppArn()) && Objects.equals(this.hostAddress(), other.hostAddress()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.billingMethodAsString(), other.billingMethodAsString()) && Objects.equals(this.deviceMinutes(), other.deviceMinutes()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.deviceUdid(), other.deviceUdid()) && Objects.equals(this.interactionModeAsString(), other.interactionModeAsString()) && Objects.equals(this.skipAppResign(), other.skipAppResign());
    }

    public String toString() {
        return ToString.builder((String)"RemoteAccessSession").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Created", (Object)this.created()).add("Status", (Object)this.statusAsString()).add("Result", (Object)this.resultAsString()).add("Message", (Object)this.message()).add("Started", (Object)this.started()).add("Stopped", (Object)this.stopped()).add("Device", (Object)this.device()).add("InstanceArn", (Object)this.instanceArn()).add("RemoteDebugEnabled", (Object)this.remoteDebugEnabled()).add("RemoteRecordEnabled", (Object)this.remoteRecordEnabled()).add("RemoteRecordAppArn", (Object)this.remoteRecordAppArn()).add("HostAddress", (Object)this.hostAddress()).add("ClientId", (Object)this.clientId()).add("BillingMethod", (Object)this.billingMethodAsString()).add("DeviceMinutes", (Object)this.deviceMinutes()).add("Endpoint", (Object)this.endpoint()).add("DeviceUdid", (Object)this.deviceUdid()).add("InteractionMode", (Object)this.interactionModeAsString()).add("SkipAppResign", (Object)this.skipAppResign()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "started": {
                return Optional.ofNullable(clazz.cast(this.started()));
            }
            case "stopped": {
                return Optional.ofNullable(clazz.cast(this.stopped()));
            }
            case "device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "remoteDebugEnabled": {
                return Optional.ofNullable(clazz.cast(this.remoteDebugEnabled()));
            }
            case "remoteRecordEnabled": {
                return Optional.ofNullable(clazz.cast(this.remoteRecordEnabled()));
            }
            case "remoteRecordAppArn": {
                return Optional.ofNullable(clazz.cast(this.remoteRecordAppArn()));
            }
            case "hostAddress": {
                return Optional.ofNullable(clazz.cast(this.hostAddress()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "billingMethod": {
                return Optional.ofNullable(clazz.cast(this.billingMethodAsString()));
            }
            case "deviceMinutes": {
                return Optional.ofNullable(clazz.cast(this.deviceMinutes()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "deviceUdid": {
                return Optional.ofNullable(clazz.cast(this.deviceUdid()));
            }
            case "interactionMode": {
                return Optional.ofNullable(clazz.cast(this.interactionModeAsString()));
            }
            case "skipAppResign": {
                return Optional.ofNullable(clazz.cast(this.skipAppResign()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoteAccessSession, T> g) {
        return obj -> g.apply((RemoteAccessSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Instant created;
        private String status;
        private String result;
        private String message;
        private Instant started;
        private Instant stopped;
        private Device device;
        private String instanceArn;
        private Boolean remoteDebugEnabled;
        private Boolean remoteRecordEnabled;
        private String remoteRecordAppArn;
        private String hostAddress;
        private String clientId;
        private String billingMethod;
        private DeviceMinutes deviceMinutes;
        private String endpoint;
        private String deviceUdid;
        private String interactionMode;
        private Boolean skipAppResign;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccessSession model) {
            this.arn(model.arn);
            this.name(model.name);
            this.created(model.created);
            this.status(model.status);
            this.result(model.result);
            this.message(model.message);
            this.started(model.started);
            this.stopped(model.stopped);
            this.device(model.device);
            this.instanceArn(model.instanceArn);
            this.remoteDebugEnabled(model.remoteDebugEnabled);
            this.remoteRecordEnabled(model.remoteRecordEnabled);
            this.remoteRecordAppArn(model.remoteRecordAppArn);
            this.hostAddress(model.hostAddress);
            this.clientId(model.clientId);
            this.billingMethod(model.billingMethod);
            this.deviceMinutes(model.deviceMinutes);
            this.endpoint(model.endpoint);
            this.deviceUdid(model.deviceUdid);
            this.interactionMode(model.interactionMode);
            this.skipAppResign(model.skipAppResign);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getStarted() {
            return this.started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return this.stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Device.Builder getDevice() {
            return this.device != null ? this.device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final Boolean getRemoteDebugEnabled() {
            return this.remoteDebugEnabled;
        }

        @Override
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        public final Boolean getRemoteRecordEnabled() {
            return this.remoteRecordEnabled;
        }

        @Override
        public final Builder remoteRecordEnabled(Boolean remoteRecordEnabled) {
            this.remoteRecordEnabled = remoteRecordEnabled;
            return this;
        }

        public final void setRemoteRecordEnabled(Boolean remoteRecordEnabled) {
            this.remoteRecordEnabled = remoteRecordEnabled;
        }

        public final String getRemoteRecordAppArn() {
            return this.remoteRecordAppArn;
        }

        @Override
        public final Builder remoteRecordAppArn(String remoteRecordAppArn) {
            this.remoteRecordAppArn = remoteRecordAppArn;
            return this;
        }

        public final void setRemoteRecordAppArn(String remoteRecordAppArn) {
            this.remoteRecordAppArn = remoteRecordAppArn;
        }

        public final String getHostAddress() {
            return this.hostAddress;
        }

        @Override
        public final Builder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public final void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod == null ? null : billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return this.deviceMinutes != null ? this.deviceMinutes.toBuilder() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getDeviceUdid() {
            return this.deviceUdid;
        }

        @Override
        public final Builder deviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
            return this;
        }

        public final void setDeviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
        }

        public final String getInteractionMode() {
            return this.interactionMode;
        }

        @Override
        public final Builder interactionMode(String interactionMode) {
            this.interactionMode = interactionMode;
            return this;
        }

        @Override
        public final Builder interactionMode(InteractionMode interactionMode) {
            this.interactionMode(interactionMode == null ? null : interactionMode.toString());
            return this;
        }

        public final void setInteractionMode(String interactionMode) {
            this.interactionMode = interactionMode;
        }

        public final Boolean getSkipAppResign() {
            return this.skipAppResign;
        }

        @Override
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        public RemoteAccessSession build() {
            return new RemoteAccessSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemoteAccessSession> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder created(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder message(String var1);

        public Builder started(Instant var1);

        public Builder stopped(Instant var1);

        public Builder device(Device var1);

        default public Builder device(Consumer<Device.Builder> device) {
            return this.device((Device)((Device.Builder)Device.builder().applyMutation(device)).build());
        }

        public Builder instanceArn(String var1);

        public Builder remoteDebugEnabled(Boolean var1);

        public Builder remoteRecordEnabled(Boolean var1);

        public Builder remoteRecordAppArn(String var1);

        public Builder hostAddress(String var1);

        public Builder clientId(String var1);

        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);

        public Builder deviceMinutes(DeviceMinutes var1);

        default public Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return this.deviceMinutes((DeviceMinutes)((DeviceMinutes.Builder)DeviceMinutes.builder().applyMutation(deviceMinutes)).build());
        }

        public Builder endpoint(String var1);

        public Builder deviceUdid(String var1);

        public Builder interactionMode(String var1);

        public Builder interactionMode(InteractionMode var1);

        public Builder skipAppResign(Boolean var1);
    }
}

