/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOfferingPromotionsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListOfferingPromotionsResponse.Builder, ListOfferingPromotionsResponse> {
    private static final SdkField<List<OfferingPromotion>> OFFERING_PROMOTIONS_FIELD = SdkField
            .<List<OfferingPromotion>> builder(MarshallingType.LIST)
            .getter(getter(ListOfferingPromotionsResponse::offeringPromotions))
            .setter(setter(Builder::offeringPromotions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringPromotions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OfferingPromotion> builder(MarshallingType.SDK_POJO)
                                            .constructor(OfferingPromotion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOfferingPromotionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_PROMOTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<OfferingPromotion> offeringPromotions;

    private final String nextToken;

    private ListOfferingPromotionsResponse(BuilderImpl builder) {
        super(builder);
        this.offeringPromotions = builder.offeringPromotions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the OfferingPromotions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOfferingPromotions() {
        return offeringPromotions != null && !(offeringPromotions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the offering promotions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOfferingPromotions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the offering promotions.
     */
    public List<OfferingPromotion> offeringPromotions() {
        return offeringPromotions;
    }

    /**
     * <p>
     * An identifier to be used in the next call to this operation, to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier to be used in the next call to this operation, to return the next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(offeringPromotions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingPromotionsResponse)) {
            return false;
        }
        ListOfferingPromotionsResponse other = (ListOfferingPromotionsResponse) obj;
        return Objects.equals(offeringPromotions(), other.offeringPromotions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOfferingPromotionsResponse").add("OfferingPromotions", offeringPromotions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringPromotions":
            return Optional.ofNullable(clazz.cast(offeringPromotions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOfferingPromotionsResponse, T> g) {
        return obj -> g.apply((ListOfferingPromotionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOfferingPromotionsResponse> {
        /**
         * <p>
         * Information about the offering promotions.
         * </p>
         * 
         * @param offeringPromotions
         *        Information about the offering promotions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringPromotions(Collection<OfferingPromotion> offeringPromotions);

        /**
         * <p>
         * Information about the offering promotions.
         * </p>
         * 
         * @param offeringPromotions
         *        Information about the offering promotions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringPromotions(OfferingPromotion... offeringPromotions);

        /**
         * <p>
         * Information about the offering promotions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OfferingPromotion>.Builder} avoiding the
         * need to create one manually via {@link List<OfferingPromotion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OfferingPromotion>.Builder#build()} is called immediately
         * and its result is passed to {@link #offeringPromotions(List<OfferingPromotion>)}.
         * 
         * @param offeringPromotions
         *        a consumer that will call methods on {@link List<OfferingPromotion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offeringPromotions(List<OfferingPromotion>)
         */
        Builder offeringPromotions(Consumer<OfferingPromotion.Builder>... offeringPromotions);

        /**
         * <p>
         * An identifier to be used in the next call to this operation, to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier to be used in the next call to this operation, to return the next set of items in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<OfferingPromotion> offeringPromotions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingPromotionsResponse model) {
            super(model);
            offeringPromotions(model.offeringPromotions);
            nextToken(model.nextToken);
        }

        public final Collection<OfferingPromotion.Builder> getOfferingPromotions() {
            return offeringPromotions != null ? offeringPromotions.stream().map(OfferingPromotion::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offeringPromotions(Collection<OfferingPromotion> offeringPromotions) {
            this.offeringPromotions = OfferingPromotionsCopier.copy(offeringPromotions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringPromotions(OfferingPromotion... offeringPromotions) {
            offeringPromotions(Arrays.asList(offeringPromotions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringPromotions(Consumer<OfferingPromotion.Builder>... offeringPromotions) {
            offeringPromotions(Stream.of(offeringPromotions).map(c -> OfferingPromotion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOfferingPromotions(Collection<OfferingPromotion.BuilderImpl> offeringPromotions) {
            this.offeringPromotions = OfferingPromotionsCopier.copyFromBuilder(offeringPromotions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingPromotionsResponse build() {
            return new ListOfferingPromotionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
