/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a create device pool request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDevicePoolResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<CreateDevicePoolResponse.Builder, CreateDevicePoolResponse> {
    private static final SdkField<DevicePool> DEVICE_POOL_FIELD = SdkField.<DevicePool> builder(MarshallingType.SDK_POJO)
            .memberName("devicePool").getter(getter(CreateDevicePoolResponse::devicePool)).setter(setter(Builder::devicePool))
            .constructor(DevicePool::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePool").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_POOL_FIELD));

    private final DevicePool devicePool;

    private CreateDevicePoolResponse(BuilderImpl builder) {
        super(builder);
        this.devicePool = builder.devicePool;
    }

    /**
     * <p>
     * The newly created device pool.
     * </p>
     * 
     * @return The newly created device pool.
     */
    public DevicePool devicePool() {
        return devicePool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(devicePool());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevicePoolResponse)) {
            return false;
        }
        CreateDevicePoolResponse other = (CreateDevicePoolResponse) obj;
        return Objects.equals(devicePool(), other.devicePool());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDevicePoolResponse").add("DevicePool", devicePool()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devicePool":
            return Optional.ofNullable(clazz.cast(devicePool()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDevicePoolResponse, T> g) {
        return obj -> g.apply((CreateDevicePoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDevicePoolResponse> {
        /**
         * <p>
         * The newly created device pool.
         * </p>
         * 
         * @param devicePool
         *        The newly created device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePool(DevicePool devicePool);

        /**
         * <p>
         * The newly created device pool.
         * </p>
         * This is a convenience that creates an instance of the {@link DevicePool.Builder} avoiding the need to create
         * one manually via {@link DevicePool#builder()}.
         *
         * When the {@link Consumer} completes, {@link DevicePool.Builder#build()} is called immediately and its result
         * is passed to {@link #devicePool(DevicePool)}.
         * 
         * @param devicePool
         *        a consumer that will call methods on {@link DevicePool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devicePool(DevicePool)
         */
        default Builder devicePool(Consumer<DevicePool.Builder> devicePool) {
            return devicePool(DevicePool.builder().applyMutation(devicePool).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private DevicePool devicePool;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevicePoolResponse model) {
            super(model);
            devicePool(model.devicePool);
        }

        public final DevicePool.Builder getDevicePool() {
            return devicePool != null ? devicePool.toBuilder() : null;
        }

        @Override
        public final Builder devicePool(DevicePool devicePool) {
            this.devicePool = devicePool;
            return this;
        }

        public final void setDevicePool(DevicePool.BuilderImpl devicePool) {
            this.devicePool = devicePool != null ? devicePool.build() : null;
        }

        @Override
        public CreateDevicePoolResponse build() {
            return new CreateDevicePoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
