/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for a remote access session, including billing method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRemoteAccessSessionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateRemoteAccessSessionConfiguration.Builder, CreateRemoteAccessSessionConfiguration> {
    private static final SdkField<String> BILLING_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingMethod").getter(getter(CreateRemoteAccessSessionConfiguration::billingMethodAsString))
            .setter(setter(Builder::billingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMethod").build()).build();

    private static final SdkField<List<String>> VPCE_CONFIGURATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpceConfigurationArns")
            .getter(getter(CreateRemoteAccessSessionConfiguration::vpceConfigurationArns))
            .setter(setter(Builder::vpceConfigurationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_METHOD_FIELD,
            VPCE_CONFIGURATION_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String billingMethod;

    private final List<String> vpceConfigurationArns;

    private CreateRemoteAccessSessionConfiguration(BuilderImpl builder) {
        this.billingMethod = builder.billingMethod;
        this.vpceConfigurationArns = builder.vpceConfigurationArns;
    }

    /**
     * <p>
     * The billing method for the remote access session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return The billing method for the remote access session.
     * @see BillingMethod
     */
    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(billingMethod);
    }

    /**
     * <p>
     * The billing method for the remote access session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return The billing method for the remote access session.
     * @see BillingMethod
     */
    public String billingMethodAsString() {
        return billingMethod;
    }

    /**
     * Returns true if the VpceConfigurationArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVpceConfigurationArns() {
        return vpceConfigurationArns != null && !(vpceConfigurationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of ARNs included in the VPC endpoint configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpceConfigurationArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of ARNs included in the VPC endpoint configuration.
     */
    public List<String> vpceConfigurationArns() {
        return vpceConfigurationArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfigurationArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionConfiguration)) {
            return false;
        }
        CreateRemoteAccessSessionConfiguration other = (CreateRemoteAccessSessionConfiguration) obj;
        return Objects.equals(billingMethodAsString(), other.billingMethodAsString())
                && Objects.equals(vpceConfigurationArns(), other.vpceConfigurationArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRemoteAccessSessionConfiguration").add("BillingMethod", billingMethodAsString())
                .add("VpceConfigurationArns", vpceConfigurationArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billingMethod":
            return Optional.ofNullable(clazz.cast(billingMethodAsString()));
        case "vpceConfigurationArns":
            return Optional.ofNullable(clazz.cast(vpceConfigurationArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRemoteAccessSessionConfiguration, T> g) {
        return obj -> g.apply((CreateRemoteAccessSessionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateRemoteAccessSessionConfiguration> {
        /**
         * <p>
         * The billing method for the remote access session.
         * </p>
         * 
         * @param billingMethod
         *        The billing method for the remote access session.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * The billing method for the remote access session.
         * </p>
         * 
         * @param billingMethod
         *        The billing method for the remote access session.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);

        /**
         * <p>
         * An array of ARNs included in the VPC endpoint configuration.
         * </p>
         * 
         * @param vpceConfigurationArns
         *        An array of ARNs included in the VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationArns(Collection<String> vpceConfigurationArns);

        /**
         * <p>
         * An array of ARNs included in the VPC endpoint configuration.
         * </p>
         * 
         * @param vpceConfigurationArns
         *        An array of ARNs included in the VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationArns(String... vpceConfigurationArns);
    }

    static final class BuilderImpl implements Builder {
        private String billingMethod;

        private List<String> vpceConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionConfiguration model) {
            billingMethod(model.billingMethod);
            vpceConfigurationArns(model.vpceConfigurationArns);
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod == null ? null : billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final Collection<String> getVpceConfigurationArns() {
            return vpceConfigurationArns;
        }

        @Override
        public final Builder vpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurationArns(String... vpceConfigurationArns) {
            vpceConfigurationArns(Arrays.asList(vpceConfigurationArns));
            return this;
        }

        public final void setVpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
        }

        @Override
        public CreateRemoteAccessSessionConfiguration build() {
            return new CreateRemoteAccessSessionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
