/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a test. Examples of artifacts include logs and screenshots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Artifact implements SdkPojo, Serializable, ToCopyableBuilder<Artifact.Builder, Artifact> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Artifact::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Artifact::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Artifact::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> EXTENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("extension").getter(getter(Artifact::extension)).setter(setter(Builder::extension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extension").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(Artifact::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, EXTENSION_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final String extension;

    private final String url;

    private Artifact(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.extension = builder.extension;
        this.url = builder.url;
    }

    /**
     * <p>
     * The artifact's ARN.
     * </p>
     * 
     * @return The artifact's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The artifact's name.
     * </p>
     * 
     * @return The artifact's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The artifact's type.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNKNOWN
     * </p>
     * </li>
     * <li>
     * <p>
     * SCREENSHOT
     * </p>
     * </li>
     * <li>
     * <p>
     * DEVICE_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * MESSAGE_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * VIDEO_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * RESULT_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * WEBKIT_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_JSON_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_PRETTY_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_STANDARD_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_JAVA_XML_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * AUTOMATION_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_SERVER_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_XML_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_XML_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * EXPLORER_EVENT_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * EXPLORER_SUMMARY_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPLICATION_CRASH_REPORT
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * VIDEO
     * </p>
     * </li>
     * <li>
     * <p>
     * CUSTOMER_ARTIFACT
     * </p>
     * </li>
     * <li>
     * <p>
     * CUSTOMER_ARTIFACT_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * TESTSPEC_OUTPUT
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The artifact's type.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNKNOWN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCREENSHOT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEVICE_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MESSAGE_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VIDEO_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESULT_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEBKIT_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_JSON_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_PRETTY_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_STANDARD_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_JAVA_XML_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AUTOMATION_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_SERVER_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_XML_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_XML_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXPLORER_EVENT_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXPLORER_SUMMARY_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPLICATION_CRASH_REPORT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VIDEO
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CUSTOMER_ARTIFACT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CUSTOMER_ARTIFACT_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TESTSPEC_OUTPUT
     *         </p>
     *         </li>
     * @see ArtifactType
     */
    public ArtifactType type() {
        return ArtifactType.fromValue(type);
    }

    /**
     * <p>
     * The artifact's type.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNKNOWN
     * </p>
     * </li>
     * <li>
     * <p>
     * SCREENSHOT
     * </p>
     * </li>
     * <li>
     * <p>
     * DEVICE_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * MESSAGE_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * VIDEO_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * RESULT_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * WEBKIT_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_JSON_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_PRETTY_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_STANDARD_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_JAVA_XML_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * AUTOMATION_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_SERVER_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_XML_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_XML_OUTPUT
     * </p>
     * </li>
     * <li>
     * <p>
     * EXPLORER_EVENT_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * EXPLORER_SUMMARY_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPLICATION_CRASH_REPORT
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * VIDEO
     * </p>
     * </li>
     * <li>
     * <p>
     * CUSTOMER_ARTIFACT
     * </p>
     * </li>
     * <li>
     * <p>
     * CUSTOMER_ARTIFACT_LOG
     * </p>
     * </li>
     * <li>
     * <p>
     * TESTSPEC_OUTPUT
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The artifact's type.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNKNOWN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCREENSHOT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEVICE_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MESSAGE_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VIDEO_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESULT_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEBKIT_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_JSON_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_PRETTY_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_STANDARD_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_JAVA_XML_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AUTOMATION_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_SERVER_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_XML_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_XML_OUTPUT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXPLORER_EVENT_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXPLORER_SUMMARY_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPLICATION_CRASH_REPORT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VIDEO
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CUSTOMER_ARTIFACT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CUSTOMER_ARTIFACT_LOG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TESTSPEC_OUTPUT
     *         </p>
     *         </li>
     * @see ArtifactType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The artifact's file extension.
     * </p>
     * 
     * @return The artifact's file extension.
     */
    public String extension() {
        return extension;
    }

    /**
     * <p>
     * The presigned Amazon S3 URL that can be used with a GET request to download the artifact's file.
     * </p>
     * 
     * @return The presigned Amazon S3 URL that can be used with a GET request to download the artifact's file.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(extension());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(extension(), other.extension())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Artifact").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Extension", extension()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "extension":
            return Optional.ofNullable(clazz.cast(extension()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Artifact, T> g) {
        return obj -> g.apply((Artifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Artifact> {
        /**
         * <p>
         * The artifact's ARN.
         * </p>
         * 
         * @param arn
         *        The artifact's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The artifact's name.
         * </p>
         * 
         * @param name
         *        The artifact's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The artifact's type.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNKNOWN
         * </p>
         * </li>
         * <li>
         * <p>
         * SCREENSHOT
         * </p>
         * </li>
         * <li>
         * <p>
         * DEVICE_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * MESSAGE_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * VIDEO_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * RESULT_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * WEBKIT_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_JSON_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_PRETTY_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_STANDARD_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_JAVA_XML_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * AUTOMATION_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_SERVER_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_XML_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_XML_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * EXPLORER_EVENT_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * EXPLORER_SUMMARY_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPLICATION_CRASH_REPORT
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * VIDEO
         * </p>
         * </li>
         * <li>
         * <p>
         * CUSTOMER_ARTIFACT
         * </p>
         * </li>
         * <li>
         * <p>
         * CUSTOMER_ARTIFACT_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * TESTSPEC_OUTPUT
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The artifact's type.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNKNOWN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCREENSHOT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEVICE_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MESSAGE_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VIDEO_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESULT_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEBKIT_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_JSON_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_PRETTY_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_STANDARD_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_JAVA_XML_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AUTOMATION_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_SERVER_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_XML_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_XML_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXPLORER_EVENT_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXPLORER_SUMMARY_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPLICATION_CRASH_REPORT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VIDEO
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CUSTOMER_ARTIFACT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CUSTOMER_ARTIFACT_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TESTSPEC_OUTPUT
         *        </p>
         *        </li>
         * @see ArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactType
         */
        Builder type(String type);

        /**
         * <p>
         * The artifact's type.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNKNOWN
         * </p>
         * </li>
         * <li>
         * <p>
         * SCREENSHOT
         * </p>
         * </li>
         * <li>
         * <p>
         * DEVICE_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * MESSAGE_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * VIDEO_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * RESULT_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * WEBKIT_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_JSON_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_PRETTY_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_STANDARD_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_JAVA_XML_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * AUTOMATION_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_SERVER_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_XML_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_XML_OUTPUT
         * </p>
         * </li>
         * <li>
         * <p>
         * EXPLORER_EVENT_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * EXPLORER_SUMMARY_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPLICATION_CRASH_REPORT
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * VIDEO
         * </p>
         * </li>
         * <li>
         * <p>
         * CUSTOMER_ARTIFACT
         * </p>
         * </li>
         * <li>
         * <p>
         * CUSTOMER_ARTIFACT_LOG
         * </p>
         * </li>
         * <li>
         * <p>
         * TESTSPEC_OUTPUT
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The artifact's type.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNKNOWN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCREENSHOT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEVICE_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MESSAGE_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VIDEO_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESULT_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEBKIT_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXERCISER_MONKEY_OUTPUT: the artifact (log) generated by an Android fuzz test.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_JSON_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_PRETTY_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_STANDARD_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_JAVA_XML_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AUTOMATION_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_SERVER_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_XML_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_XML_OUTPUT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXPLORER_EVENT_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXPLORER_SUMMARY_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPLICATION_CRASH_REPORT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VIDEO
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CUSTOMER_ARTIFACT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CUSTOMER_ARTIFACT_LOG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TESTSPEC_OUTPUT
         *        </p>
         *        </li>
         * @see ArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactType
         */
        Builder type(ArtifactType type);

        /**
         * <p>
         * The artifact's file extension.
         * </p>
         * 
         * @param extension
         *        The artifact's file extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extension(String extension);

        /**
         * <p>
         * The presigned Amazon S3 URL that can be used with a GET request to download the artifact's file.
         * </p>
         * 
         * @param url
         *        The presigned Amazon S3 URL that can be used with a GET request to download the artifact's file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private String extension;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Artifact model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            extension(model.extension);
            url(model.url);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getExtension() {
            return extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public Artifact build() {
            return new Artifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
