/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the amount of CPU that an app is using on a physical device. Does not represent system-wide CPU usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CPU implements SdkPojo, Serializable, ToCopyableBuilder<CPU.Builder, CPU> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frequency").getter(getter(CPU::frequency)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(CPU::architecture)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<Double> CLOCK_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("clock")
            .getter(getter(CPU::clock)).setter(setter(Builder::clock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD,
            ARCHITECTURE_FIELD, CLOCK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String frequency;

    private final String architecture;

    private final Double clock;

    private CPU(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.architecture = builder.architecture;
        this.clock = builder.clock;
    }

    /**
     * <p>
     * The CPU's frequency.
     * </p>
     * 
     * @return The CPU's frequency.
     */
    public String frequency() {
        return frequency;
    }

    /**
     * <p>
     * The CPU's architecture (for example, x86 or ARM).
     * </p>
     * 
     * @return The CPU's architecture (for example, x86 or ARM).
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU is expressed as
     * 1200000000.
     * </p>
     * 
     * @return The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU is expressed as
     *         1200000000.
     */
    public Double clock() {
        return clock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(clock());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CPU)) {
            return false;
        }
        CPU other = (CPU) obj;
        return Objects.equals(frequency(), other.frequency()) && Objects.equals(architecture(), other.architecture())
                && Objects.equals(clock(), other.clock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CPU").add("Frequency", frequency()).add("Architecture", architecture()).add("Clock", clock())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frequency":
            return Optional.ofNullable(clazz.cast(frequency()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "clock":
            return Optional.ofNullable(clazz.cast(clock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CPU, T> g) {
        return obj -> g.apply((CPU) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CPU> {
        /**
         * <p>
         * The CPU's frequency.
         * </p>
         * 
         * @param frequency
         *        The CPU's frequency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The CPU's architecture (for example, x86 or ARM).
         * </p>
         * 
         * @param architecture
         *        The CPU's architecture (for example, x86 or ARM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU is expressed as
         * 1200000000.
         * </p>
         * 
         * @param clock
         *        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU is expressed
         *        as 1200000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clock(Double clock);
    }

    static final class BuilderImpl implements Builder {
        private String frequency;

        private String architecture;

        private Double clock;

        private BuilderImpl() {
        }

        private BuilderImpl(CPU model) {
            frequency(model.frequency);
            architecture(model.architecture);
            clock(model.clock);
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Double getClock() {
            return clock;
        }

        @Override
        public final Builder clock(Double clock) {
            this.clock = clock;
            return this;
        }

        public final void setClock(Double clock) {
            this.clock = clock;
        }

        @Override
        public CPU build() {
            return new CPU(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
