/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTestGridProjectRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<DeleteTestGridProjectRequest.Builder, DeleteTestGridProjectRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(DeleteTestGridProjectRequest::projectArn))
            .setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD));

    private final String projectArn;

    private DeleteTestGridProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
    }

    /**
     * <p>
     * The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
     * </p>
     * 
     * @return The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
     */
    public String projectArn() {
        return projectArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTestGridProjectRequest)) {
            return false;
        }
        DeleteTestGridProjectRequest other = (DeleteTestGridProjectRequest) obj;
        return Objects.equals(projectArn(), other.projectArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteTestGridProjectRequest").add("ProjectArn", projectArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTestGridProjectRequest, T> g) {
        return obj -> g.apply((DeleteTestGridProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTestGridProjectRequest> {
        /**
         * <p>
         * The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the project to delete, from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String projectArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTestGridProjectRequest model) {
            super(model);
            projectArn(model.projectArn);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTestGridProjectRequest build() {
            return new DeleteTestGridProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
