/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.TestGridProject;
import software.amazon.awssdk.services.devicefarm.model.TestGridProjectsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestGridProjectsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListTestGridProjectsResponse> {
    private static final SdkField<List<TestGridProject>> TEST_GRID_PROJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testGridProjects").getter(ListTestGridProjectsResponse.getter(ListTestGridProjectsResponse::testGridProjects)).setter(ListTestGridProjectsResponse.setter(Builder::testGridProjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testGridProjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestGridProject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestGridProjectsResponse.getter(ListTestGridProjectsResponse::nextToken)).setter(ListTestGridProjectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_GRID_PROJECTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TestGridProject> testGridProjects;
    private final String nextToken;

    private ListTestGridProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.testGridProjects = builder.testGridProjects;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTestGridProjects() {
        return this.testGridProjects != null && !(this.testGridProjects instanceof SdkAutoConstructList);
    }

    public List<TestGridProject> testGridProjects() {
        return this.testGridProjects;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestGridProjects() ? this.testGridProjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridProjectsResponse)) {
            return false;
        }
        ListTestGridProjectsResponse other = (ListTestGridProjectsResponse)((Object)obj);
        return this.hasTestGridProjects() == other.hasTestGridProjects() && Objects.equals(this.testGridProjects(), other.testGridProjects()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTestGridProjectsResponse").add("TestGridProjects", this.hasTestGridProjects() ? this.testGridProjects() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testGridProjects": {
                return Optional.ofNullable(clazz.cast(this.testGridProjects()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridProjectsResponse, T> g) {
        return obj -> g.apply((ListTestGridProjectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<TestGridProject> testGridProjects = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridProjectsResponse model) {
            super(model);
            this.testGridProjects(model.testGridProjects);
            this.nextToken(model.nextToken);
        }

        public final Collection<TestGridProject.Builder> getTestGridProjects() {
            if (this.testGridProjects instanceof SdkAutoConstructList) {
                return null;
            }
            return this.testGridProjects != null ? (Collection)this.testGridProjects.stream().map(TestGridProject::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder testGridProjects(Collection<TestGridProject> testGridProjects) {
            this.testGridProjects = TestGridProjectsCopier.copy(testGridProjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testGridProjects(TestGridProject ... testGridProjects) {
            this.testGridProjects(Arrays.asList(testGridProjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testGridProjects(Consumer<TestGridProject.Builder> ... testGridProjects) {
            this.testGridProjects(Stream.of(testGridProjects).map(c -> (TestGridProject)((TestGridProject.Builder)TestGridProject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTestGridProjects(Collection<TestGridProject.BuilderImpl> testGridProjects) {
            this.testGridProjects = TestGridProjectsCopier.copyFromBuilder(testGridProjects);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestGridProjectsResponse build() {
            return new ListTestGridProjectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestGridProjectsResponse> {
        public Builder testGridProjects(Collection<TestGridProject> var1);

        public Builder testGridProjects(TestGridProject ... var1);

        public Builder testGridProjects(Consumer<TestGridProject.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

