/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpceConfigurationResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<CreateVpceConfigurationResponse.Builder, CreateVpceConfigurationResponse> {
    private static final SdkField<VPCEConfiguration> VPCE_CONFIGURATION_FIELD = SdkField
            .<VPCEConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpceConfiguration")
            .getter(getter(CreateVpceConfigurationResponse::vpceConfiguration)).setter(setter(Builder::vpceConfiguration))
            .constructor(VPCEConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPCE_CONFIGURATION_FIELD));

    private final VPCEConfiguration vpceConfiguration;

    private CreateVpceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.vpceConfiguration = builder.vpceConfiguration;
    }

    /**
     * <p>
     * An object that contains information about your VPC endpoint configuration.
     * </p>
     * 
     * @return An object that contains information about your VPC endpoint configuration.
     */
    public VPCEConfiguration vpceConfiguration() {
        return vpceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpceConfigurationResponse)) {
            return false;
        }
        CreateVpceConfigurationResponse other = (CreateVpceConfigurationResponse) obj;
        return Objects.equals(vpceConfiguration(), other.vpceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpceConfigurationResponse").add("VpceConfiguration", vpceConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpceConfiguration":
            return Optional.ofNullable(clazz.cast(vpceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpceConfigurationResponse, T> g) {
        return obj -> g.apply((CreateVpceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpceConfigurationResponse> {
        /**
         * <p>
         * An object that contains information about your VPC endpoint configuration.
         * </p>
         * 
         * @param vpceConfiguration
         *        An object that contains information about your VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfiguration(VPCEConfiguration vpceConfiguration);

        /**
         * <p>
         * An object that contains information about your VPC endpoint configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link VPCEConfiguration.Builder} avoiding the need to
         * create one manually via {@link VPCEConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPCEConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpceConfiguration(VPCEConfiguration)}.
         * 
         * @param vpceConfiguration
         *        a consumer that will call methods on {@link VPCEConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpceConfiguration(VPCEConfiguration)
         */
        default Builder vpceConfiguration(Consumer<VPCEConfiguration.Builder> vpceConfiguration) {
            return vpceConfiguration(VPCEConfiguration.builder().applyMutation(vpceConfiguration).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private VPCEConfiguration vpceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpceConfigurationResponse model) {
            super(model);
            vpceConfiguration(model.vpceConfiguration);
        }

        public final VPCEConfiguration.Builder getVpceConfiguration() {
            return vpceConfiguration != null ? vpceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder vpceConfiguration(VPCEConfiguration vpceConfiguration) {
            this.vpceConfiguration = vpceConfiguration;
            return this;
        }

        public final void setVpceConfiguration(VPCEConfiguration.BuilderImpl vpceConfiguration) {
            this.vpceConfiguration = vpceConfiguration != null ? vpceConfiguration.build() : null;
        }

        @Override
        public CreateVpceConfigurationResponse build() {
            return new CreateVpceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
