/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list uploads request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUploadsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListUploadsResponse.Builder, ListUploadsResponse> {
    private static final SdkField<List<Upload>> UPLOADS_FIELD = SdkField
            .<List<Upload>> builder(MarshallingType.LIST)
            .memberName("uploads")
            .getter(getter(ListUploadsResponse::uploads))
            .setter(setter(Builder::uploads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploads").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Upload> builder(MarshallingType.SDK_POJO)
                                            .constructor(Upload::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListUploadsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOADS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Upload> uploads;

    private final String nextToken;

    private ListUploadsResponse(BuilderImpl builder) {
        super(builder);
        this.uploads = builder.uploads;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Uploads property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUploads() {
        return uploads != null && !(uploads instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the uploads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUploads()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the uploads.
     */
    public List<Upload> uploads() {
        return uploads;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned. It
     * can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned. It can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUploads() ? uploads() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUploadsResponse)) {
            return false;
        }
        ListUploadsResponse other = (ListUploadsResponse) obj;
        return hasUploads() == other.hasUploads() && Objects.equals(uploads(), other.uploads())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUploadsResponse").add("Uploads", hasUploads() ? uploads() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uploads":
            return Optional.ofNullable(clazz.cast(uploads()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUploadsResponse, T> g) {
        return obj -> g.apply((ListUploadsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUploadsResponse> {
        /**
         * <p>
         * Information about the uploads.
         * </p>
         * 
         * @param uploads
         *        Information about the uploads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploads(Collection<Upload> uploads);

        /**
         * <p>
         * Information about the uploads.
         * </p>
         * 
         * @param uploads
         *        Information about the uploads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploads(Upload... uploads);

        /**
         * <p>
         * Information about the uploads.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Upload>.Builder} avoiding the need to
         * create one manually via {@link List<Upload>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Upload>.Builder#build()} is called immediately and its
         * result is passed to {@link #uploads(List<Upload>)}.
         * 
         * @param uploads
         *        a consumer that will call methods on {@link List<Upload>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploads(List<Upload>)
         */
        Builder uploads(Consumer<Upload.Builder>... uploads);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned.
         * It can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned. It can be used in a subsequent call to this operation to return the next set of items in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<Upload> uploads = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUploadsResponse model) {
            super(model);
            uploads(model.uploads);
            nextToken(model.nextToken);
        }

        public final Collection<Upload.Builder> getUploads() {
            if (uploads instanceof SdkAutoConstructList) {
                return null;
            }
            return uploads != null ? uploads.stream().map(Upload::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder uploads(Collection<Upload> uploads) {
            this.uploads = UploadsCopier.copy(uploads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(Upload... uploads) {
            uploads(Arrays.asList(uploads));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(Consumer<Upload.Builder>... uploads) {
            uploads(Stream.of(uploads).map(c -> Upload.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUploads(Collection<Upload.BuilderImpl> uploads) {
            this.uploads = UploadsCopier.copyFromBuilder(uploads);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUploadsResponse build() {
            return new ListUploadsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
