/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExecutionStatus {
    PENDING("PENDING"),
    PENDING_CONCURRENCY("PENDING_CONCURRENCY"),
    PENDING_DEVICE("PENDING_DEVICE"),
    PROCESSING("PROCESSING"),
    SCHEDULING("SCHEDULING"),
    PREPARING("PREPARING"),
    RUNNING("RUNNING"),
    COMPLETED("COMPLETED"),
    STOPPING("STOPPING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExecutionStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionStatus> knownValues() {
        return Stream.of(ExecutionStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

