/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestGridSessionArtifactsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListTestGridSessionArtifactsResponse.Builder, ListTestGridSessionArtifactsResponse> {
    private static final SdkField<List<TestGridSessionArtifact>> ARTIFACTS_FIELD = SdkField
            .<List<TestGridSessionArtifact>> builder(MarshallingType.LIST)
            .memberName("artifacts")
            .getter(getter(ListTestGridSessionArtifactsResponse::artifacts))
            .setter(setter(Builder::artifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestGridSessionArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestGridSessionArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestGridSessionArtifactsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TestGridSessionArtifact> artifacts;

    private final String nextToken;

    private ListTestGridSessionArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.artifacts = builder.artifacts;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Artifacts property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArtifacts() {
        return artifacts != null && !(artifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of test grid session artifacts for a <a>TestGridSession</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArtifacts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of test grid session artifacts for a <a>TestGridSession</a>.
     */
    public List<TestGridSessionArtifact> artifacts() {
        return artifacts;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridSessionArtifactsResponse)) {
            return false;
        }
        ListTestGridSessionArtifactsResponse other = (ListTestGridSessionArtifactsResponse) obj;
        return Objects.equals(artifacts(), other.artifacts()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTestGridSessionArtifactsResponse").add("Artifacts", artifacts())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "artifacts":
            return Optional.ofNullable(clazz.cast(artifacts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridSessionArtifactsResponse, T> g) {
        return obj -> g.apply((ListTestGridSessionArtifactsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTestGridSessionArtifactsResponse> {
        /**
         * <p>
         * A list of test grid session artifacts for a <a>TestGridSession</a>.
         * </p>
         * 
         * @param artifacts
         *        A list of test grid session artifacts for a <a>TestGridSession</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(Collection<TestGridSessionArtifact> artifacts);

        /**
         * <p>
         * A list of test grid session artifacts for a <a>TestGridSession</a>.
         * </p>
         * 
         * @param artifacts
         *        A list of test grid session artifacts for a <a>TestGridSession</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(TestGridSessionArtifact... artifacts);

        /**
         * <p>
         * A list of test grid session artifacts for a <a>TestGridSession</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TestGridSessionArtifact>.Builder} avoiding
         * the need to create one manually via {@link List<TestGridSessionArtifact>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TestGridSessionArtifact>.Builder#build()} is called
         * immediately and its result is passed to {@link #artifacts(List<TestGridSessionArtifact>)}.
         * 
         * @param artifacts
         *        a consumer that will call methods on {@link List<TestGridSessionArtifact>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifacts(List<TestGridSessionArtifact>)
         */
        Builder artifacts(Consumer<TestGridSessionArtifact.Builder>... artifacts);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<TestGridSessionArtifact> artifacts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridSessionArtifactsResponse model) {
            super(model);
            artifacts(model.artifacts);
            nextToken(model.nextToken);
        }

        public final Collection<TestGridSessionArtifact.Builder> getArtifacts() {
            return artifacts != null ? artifacts.stream().map(TestGridSessionArtifact::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder artifacts(Collection<TestGridSessionArtifact> artifacts) {
            this.artifacts = TestGridSessionArtifactsCopier.copy(artifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(TestGridSessionArtifact... artifacts) {
            artifacts(Arrays.asList(artifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Consumer<TestGridSessionArtifact.Builder>... artifacts) {
            artifacts(Stream.of(artifacts).map(c -> TestGridSessionArtifact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setArtifacts(Collection<TestGridSessionArtifact.BuilderImpl> artifacts) {
            this.artifacts = TestGridSessionArtifactsCopier.copyFromBuilder(artifacts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestGridSessionArtifactsResponse build() {
            return new ListTestGridSessionArtifactsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
