/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server after AWS Device Farm makes a request to return information about the remote
 * access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRemoteAccessSessionsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListRemoteAccessSessionsResponse.Builder, ListRemoteAccessSessionsResponse> {
    private static final SdkField<List<RemoteAccessSession>> REMOTE_ACCESS_SESSIONS_FIELD = SdkField
            .<List<RemoteAccessSession>> builder(MarshallingType.LIST)
            .memberName("remoteAccessSessions")
            .getter(getter(ListRemoteAccessSessionsResponse::remoteAccessSessions))
            .setter(setter(Builder::remoteAccessSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessSessions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemoteAccessSession> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemoteAccessSession::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRemoteAccessSessionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_ACCESS_SESSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RemoteAccessSession> remoteAccessSessions;

    private final String nextToken;

    private ListRemoteAccessSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.remoteAccessSessions = builder.remoteAccessSessions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RemoteAccessSessions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRemoteAccessSessions() {
        return remoteAccessSessions != null && !(remoteAccessSessions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A container that represents the metadata from the service about each remote access session you are requesting.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoteAccessSessions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A container that represents the metadata from the service about each remote access session you are
     *         requesting.
     */
    public List<RemoteAccessSession> remoteAccessSessions() {
        return remoteAccessSessions;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessSessions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRemoteAccessSessionsResponse)) {
            return false;
        }
        ListRemoteAccessSessionsResponse other = (ListRemoteAccessSessionsResponse) obj;
        return Objects.equals(remoteAccessSessions(), other.remoteAccessSessions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRemoteAccessSessionsResponse").add("RemoteAccessSessions", remoteAccessSessions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteAccessSessions":
            return Optional.ofNullable(clazz.cast(remoteAccessSessions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRemoteAccessSessionsResponse, T> g) {
        return obj -> g.apply((ListRemoteAccessSessionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
        /**
         * <p>
         * A container that represents the metadata from the service about each remote access session you are
         * requesting.
         * </p>
         * 
         * @param remoteAccessSessions
         *        A container that represents the metadata from the service about each remote access session you are
         *        requesting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSessions(Collection<RemoteAccessSession> remoteAccessSessions);

        /**
         * <p>
         * A container that represents the metadata from the service about each remote access session you are
         * requesting.
         * </p>
         * 
         * @param remoteAccessSessions
         *        A container that represents the metadata from the service about each remote access session you are
         *        requesting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSessions(RemoteAccessSession... remoteAccessSessions);

        /**
         * <p>
         * A container that represents the metadata from the service about each remote access session you are
         * requesting.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemoteAccessSession>.Builder} avoiding the
         * need to create one manually via {@link List<RemoteAccessSession>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemoteAccessSession>.Builder#build()} is called immediately
         * and its result is passed to {@link #remoteAccessSessions(List<RemoteAccessSession>)}.
         * 
         * @param remoteAccessSessions
         *        a consumer that will call methods on {@link List<RemoteAccessSession>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteAccessSessions(List<RemoteAccessSession>)
         */
        Builder remoteAccessSessions(Consumer<RemoteAccessSession.Builder>... remoteAccessSessions);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<RemoteAccessSession> remoteAccessSessions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRemoteAccessSessionsResponse model) {
            super(model);
            remoteAccessSessions(model.remoteAccessSessions);
            nextToken(model.nextToken);
        }

        public final Collection<RemoteAccessSession.Builder> getRemoteAccessSessions() {
            return remoteAccessSessions != null ? remoteAccessSessions.stream().map(RemoteAccessSession::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remoteAccessSessions(Collection<RemoteAccessSession> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copy(remoteAccessSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteAccessSessions(RemoteAccessSession... remoteAccessSessions) {
            remoteAccessSessions(Arrays.asList(remoteAccessSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteAccessSessions(Consumer<RemoteAccessSession.Builder>... remoteAccessSessions) {
            remoteAccessSessions(Stream.of(remoteAccessSessions).map(c -> RemoteAccessSession.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRemoteAccessSessions(Collection<RemoteAccessSession.BuilderImpl> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copyFromBuilder(remoteAccessSessions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRemoteAccessSessionsResponse build() {
            return new ListRemoteAccessSessionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
