/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.devicefarm.model.ArgumentException;
import software.amazon.awssdk.services.devicefarm.model.CannotDeleteException;
import software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteRunRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteRunResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmException;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceResponse;
import software.amazon.awssdk.services.devicefarm.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.GetJobRequest;
import software.amazon.awssdk.services.devicefarm.model.GetJobResponse;
import software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse;
import software.amazon.awssdk.services.devicefarm.model.GetProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.GetProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.GetRunRequest;
import software.amazon.awssdk.services.devicefarm.model.GetRunResponse;
import software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest;
import software.amazon.awssdk.services.devicefarm.model.GetSuiteResponse;
import software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.GetTestRequest;
import software.amazon.awssdk.services.devicefarm.model.GetTestResponse;
import software.amazon.awssdk.services.devicefarm.model.GetUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.GetUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.model.IdempotencyException;
import software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.InternalServiceException;
import software.amazon.awssdk.services.devicefarm.model.InvalidOperationException;
import software.amazon.awssdk.services.devicefarm.model.LimitExceededException;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListJobsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListJobsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListRunsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRunsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse;
import software.amazon.awssdk.services.devicefarm.model.NotEligibleException;
import software.amazon.awssdk.services.devicefarm.model.NotFoundException;
import software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest;
import software.amazon.awssdk.services.devicefarm.model.RenewOfferingResponse;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunResponse;
import software.amazon.awssdk.services.devicefarm.model.ServiceAccountException;
import software.amazon.awssdk.services.devicefarm.model.StopJobRequest;
import software.amazon.awssdk.services.devicefarm.model.StopJobResponse;
import software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.StopRunRequest;
import software.amazon.awssdk.services.devicefarm.model.StopRunResponse;
import software.amazon.awssdk.services.devicefarm.model.TagOperationException;
import software.amazon.awssdk.services.devicefarm.model.TagPolicyException;
import software.amazon.awssdk.services.devicefarm.model.TagResourceRequest;
import software.amazon.awssdk.services.devicefarm.model.TagResourceResponse;
import software.amazon.awssdk.services.devicefarm.model.TooManyTagsException;
import software.amazon.awssdk.services.devicefarm.model.UntagResourceRequest;
import software.amazon.awssdk.services.devicefarm.model.UntagResourceResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestGridProjectsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionActionsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionArtifactsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable;
import software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable;
import software.amazon.awssdk.services.devicefarm.transform.CreateDevicePoolRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateTestGridProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateTestGridUrlRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateUploadRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.CreateVpceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteDevicePoolRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteRunRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteTestGridProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteUploadRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeleteVpceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDeviceInstanceRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDevicePoolCompatibilityRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDevicePoolRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetOfferingStatusRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetRunRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetSuiteRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetTestGridProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetTestGridSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetTestRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetUploadRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.GetVpceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.InstallToRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListArtifactsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListDeviceInstancesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListDevicePoolsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListInstanceProfilesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListNetworkProfilesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListOfferingPromotionsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListOfferingTransactionsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListOfferingsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListRemoteAccessSessionsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListRunsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListSamplesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListSuitesRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListTestGridProjectsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListTestGridSessionActionsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListTestGridSessionArtifactsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListTestGridSessionsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListTestsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListUniqueProblemsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListUploadsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ListVpceConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.PurchaseOfferingRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.RenewOfferingRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.StopJobRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.StopRemoteAccessSessionRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.StopRunRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateDeviceInstanceRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateDevicePoolRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateTestGridProjectRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateUploadRequestMarshaller;
import software.amazon.awssdk.services.devicefarm.transform.UpdateVpceConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link DeviceFarmClient}.
 *
 * @see DeviceFarmClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDeviceFarmClient implements DeviceFarmClient {
    private static final Logger log = Logger.loggerFor(DefaultDeviceFarmClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDeviceFarmClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates a device pool.
     * </p>
     *
     * @param createDevicePoolRequest
     *        Represents a request to the create device pool operation.
     * @return Result of the CreateDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDevicePoolResponse createDevicePool(CreateDevicePoolRequest createDevicePoolRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDevicePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDevicePoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDevicePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDevicePool");

            return clientHandler.execute(new ClientExecutionParams<CreateDevicePoolRequest, CreateDevicePoolResponse>()
                    .withOperationName("CreateDevicePool").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDevicePoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDevicePoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a profile that can be applied to one or more private fleet device instances.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return Result of the CreateInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInstanceProfileResponse createInstanceProfile(CreateInstanceProfileRequest createInstanceProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInstanceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateInstanceProfileRequest, CreateInstanceProfileResponse>()
                    .withOperationName("CreateInstanceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createInstanceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a network profile.
     * </p>
     *
     * @param createNetworkProfileRequest
     * @return Result of the CreateNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNetworkProfileResponse createNetworkProfile(CreateNetworkProfileRequest createNetworkProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateNetworkProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateNetworkProfileRequest, CreateNetworkProfileResponse>()
                    .withOperationName("CreateNetworkProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createNetworkProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNetworkProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a project.
     * </p>
     *
     * @param createProjectRequest
     *        Represents a request to the create project operation.
     * @return Result of the CreateProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws TagOperationException
     *         The operation was not successful. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, TagOperationException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProject");

            return clientHandler.execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                    .withOperationName("CreateProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies and starts a remote access session.
     * </p>
     *
     * @param createRemoteAccessSessionRequest
     *        Creates and submits a request to start a remote access session.
     * @return Result of the CreateRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRemoteAccessSessionResponse createRemoteAccessSession(
            CreateRemoteAccessSessionRequest createRemoteAccessSessionRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRemoteAccessSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRemoteAccessSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRemoteAccessSession");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRemoteAccessSessionRequest, CreateRemoteAccessSessionResponse>()
                            .withOperationName("CreateRemoteAccessSession").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createRemoteAccessSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRemoteAccessSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Selenium testing project. Projects are used to track <a>TestGridSession</a> instances.
     * </p>
     *
     * @param createTestGridProjectRequest
     * @return Result of the CreateTestGridProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTestGridProjectResponse createTestGridProject(CreateTestGridProjectRequest createTestGridProjectRequest)
            throws ArgumentException, LimitExceededException, InternalServiceException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTestGridProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTestGridProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTestGridProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTestGridProject");

            return clientHandler.execute(new ClientExecutionParams<CreateTestGridProjectRequest, CreateTestGridProjectResponse>()
                    .withOperationName("CreateTestGridProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTestGridProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTestGridProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a signed, short-term URL that can be passed to a Selenium <code>RemoteWebDriver</code> constructor.
     * </p>
     *
     * @param createTestGridUrlRequest
     * @return Result of the CreateTestGridUrl operation returned by the service.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateTestGridUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridUrl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateTestGridUrlResponse createTestGridUrl(CreateTestGridUrlRequest createTestGridUrlRequest)
            throws NotFoundException, ArgumentException, InternalServiceException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTestGridUrlResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTestGridUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTestGridUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTestGridUrl");

            return clientHandler.execute(new ClientExecutionParams<CreateTestGridUrlRequest, CreateTestGridUrlResponse>()
                    .withOperationName("CreateTestGridUrl").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTestGridUrlRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTestGridUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Uploads an app or test scripts.
     * </p>
     *
     * @param createUploadRequest
     *        Represents a request to the create upload operation.
     * @return Result of the CreateUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUploadResponse createUpload(CreateUploadRequest createUploadRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUploadResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUploadResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUpload");

            return clientHandler.execute(new ClientExecutionParams<CreateUploadRequest, CreateUploadResponse>()
                    .withOperationName("CreateUpload").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUploadRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     *
     * @param createVpceConfigurationRequest
     * @return Result of the CreateVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.CreateVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVpceConfigurationResponse createVPCEConfiguration(CreateVpceConfigurationRequest createVpceConfigurationRequest)
            throws ArgumentException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVpceConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateVpceConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpceConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVPCEConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVpceConfigurationRequest, CreateVpceConfigurationResponse>()
                            .withOperationName("CreateVPCEConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createVpceConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVpceConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.
     * </p>
     *
     * @param deleteDevicePoolRequest
     *        Represents a request to the delete device pool operation.
     * @return Result of the DeleteDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDevicePoolResponse deleteDevicePool(DeleteDevicePoolRequest deleteDevicePoolRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDevicePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDevicePoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDevicePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDevicePool");

            return clientHandler.execute(new ClientExecutionParams<DeleteDevicePoolRequest, DeleteDevicePoolResponse>()
                    .withOperationName("DeleteDevicePool").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDevicePoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDevicePoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a profile that can be applied to one or more private device instances.
     * </p>
     *
     * @param deleteInstanceProfileRequest
     * @return Result of the DeleteInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInstanceProfileResponse deleteInstanceProfile(DeleteInstanceProfileRequest deleteInstanceProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInstanceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceProfile");

            return clientHandler.execute(new ClientExecutionParams<DeleteInstanceProfileRequest, DeleteInstanceProfileResponse>()
                    .withOperationName("DeleteInstanceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteInstanceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a network profile.
     * </p>
     *
     * @param deleteNetworkProfileRequest
     * @return Result of the DeleteNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNetworkProfileResponse deleteNetworkProfile(DeleteNetworkProfileRequest deleteNetworkProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteNetworkProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkProfile");

            return clientHandler.execute(new ClientExecutionParams<DeleteNetworkProfileRequest, DeleteNetworkProfileResponse>()
                    .withOperationName("DeleteNetworkProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteNetworkProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNetworkProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an AWS Device Farm project, given the project ARN.
     * </p>
     * <p>
     * Deleting this resource does not stop an in-progress run.
     * </p>
     *
     * @param deleteProjectRequest
     *        Represents a request to the delete project operation.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProject");

            return clientHandler.execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                    .withOperationName("DeleteProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a completed remote access session and its results.
     * </p>
     *
     * @param deleteRemoteAccessSessionRequest
     *        Represents the request to delete the specified remote access session.
     * @return Result of the DeleteRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRemoteAccessSessionResponse deleteRemoteAccessSession(
            DeleteRemoteAccessSessionRequest deleteRemoteAccessSessionRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRemoteAccessSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRemoteAccessSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRemoteAccessSession");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRemoteAccessSessionRequest, DeleteRemoteAccessSessionResponse>()
                            .withOperationName("DeleteRemoteAccessSession").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteRemoteAccessSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRemoteAccessSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the run, given the run ARN.
     * </p>
     * <p>
     * Deleting this resource does not stop an in-progress run.
     * </p>
     *
     * @param deleteRunRequest
     *        Represents a request to the delete run operation.
     * @return Result of the DeleteRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRunResponse deleteRun(DeleteRunRequest deleteRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRun");

            return clientHandler.execute(new ClientExecutionParams<DeleteRunRequest, DeleteRunResponse>()
                    .withOperationName("DeleteRun").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Selenium testing project and all content generated under it.
     * </p>
     * <important>
     * <p>
     * You cannot undo this operation.
     * </p>
     * </important> <note>
     * <p>
     * You cannot delete a project if it has active sessions.
     * </p>
     * </note>
     *
     * @param deleteTestGridProjectRequest
     * @return Result of the DeleteTestGridProject operation returned by the service.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws CannotDeleteException
     *         The requested object could not be deleted.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteTestGridProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTestGridProjectResponse deleteTestGridProject(DeleteTestGridProjectRequest deleteTestGridProjectRequest)
            throws NotFoundException, ArgumentException, CannotDeleteException, InternalServiceException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTestGridProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTestGridProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTestGridProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTestGridProject");

            return clientHandler.execute(new ClientExecutionParams<DeleteTestGridProjectRequest, DeleteTestGridProjectResponse>()
                    .withOperationName("DeleteTestGridProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteTestGridProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTestGridProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an upload given the upload ARN.
     * </p>
     *
     * @param deleteUploadRequest
     *        Represents a request to the delete upload operation.
     * @return Result of the DeleteUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUploadResponse deleteUpload(DeleteUploadRequest deleteUploadRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUploadResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUploadResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUpload");

            return clientHandler.execute(new ClientExecutionParams<DeleteUploadRequest, DeleteUploadResponse>()
                    .withOperationName("DeleteUpload").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUploadRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     *
     * @param deleteVpceConfigurationRequest
     * @return Result of the DeleteVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws InvalidOperationException
     *         There was an error with the update request, or you do not have sufficient permissions to update this VPC
     *         endpoint configuration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.DeleteVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVpceConfigurationResponse deleteVPCEConfiguration(DeleteVpceConfigurationRequest deleteVpceConfigurationRequest)
            throws ArgumentException, NotFoundException, ServiceAccountException, InvalidOperationException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVpceConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVpceConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpceConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVPCEConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVpceConfigurationRequest, DeleteVpceConfigurationResponse>()
                            .withOperationName("DeleteVPCEConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpceConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVpceConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the number of unmetered iOS or unmetered Android devices that have been purchased by the account.
     * </p>
     *
     * @param getAccountSettingsRequest
     *        Represents the request sent to retrieve the account settings.
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAccountSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountSettings");

            return clientHandler.execute(new ClientExecutionParams<GetAccountSettingsRequest, GetAccountSettingsResponse>()
                    .withOperationName("GetAccountSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAccountSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAccountSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a unique device type.
     * </p>
     *
     * @param getDeviceRequest
     *        Represents a request to the get device request.
     * @return Result of the GetDevice operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDevice");

            return clientHandler.execute(new ClientExecutionParams<GetDeviceRequest, GetDeviceResponse>()
                    .withOperationName("GetDevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a device instance that belongs to a private device fleet.
     * </p>
     *
     * @param getDeviceInstanceRequest
     * @return Result of the GetDeviceInstance operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDeviceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDeviceInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDeviceInstanceResponse getDeviceInstance(GetDeviceInstanceRequest getDeviceInstanceRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeviceInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeviceInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceInstance");

            return clientHandler.execute(new ClientExecutionParams<GetDeviceInstanceRequest, GetDeviceInstanceResponse>()
                    .withOperationName("GetDeviceInstance").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDeviceInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeviceInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a device pool.
     * </p>
     *
     * @param getDevicePoolRequest
     *        Represents a request to the get device pool operation.
     * @return Result of the GetDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDevicePoolResponse getDevicePool(GetDevicePoolRequest getDevicePoolRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDevicePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDevicePoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDevicePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDevicePool");

            return clientHandler.execute(new ClientExecutionParams<GetDevicePoolRequest, GetDevicePoolResponse>()
                    .withOperationName("GetDevicePool").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDevicePoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDevicePoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about compatibility with a device pool.
     * </p>
     *
     * @param getDevicePoolCompatibilityRequest
     *        Represents a request to the get device pool compatibility operation.
     * @return Result of the GetDevicePoolCompatibility operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetDevicePoolCompatibility
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDevicePoolCompatibilityResponse getDevicePoolCompatibility(
            GetDevicePoolCompatibilityRequest getDevicePoolCompatibilityRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDevicePoolCompatibilityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDevicePoolCompatibilityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDevicePoolCompatibilityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDevicePoolCompatibility");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDevicePoolCompatibilityRequest, GetDevicePoolCompatibilityResponse>()
                            .withOperationName("GetDevicePoolCompatibility").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDevicePoolCompatibilityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDevicePoolCompatibilityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the specified instance profile.
     * </p>
     *
     * @param getInstanceProfileRequest
     * @return Result of the GetInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetInstanceProfileResponse getInstanceProfile(GetInstanceProfileRequest getInstanceProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInstanceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceProfile");

            return clientHandler.execute(new ClientExecutionParams<GetInstanceProfileRequest, GetInstanceProfileResponse>()
                    .withOperationName("GetInstanceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getInstanceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a job.
     * </p>
     *
     * @param getJobRequest
     *        Represents a request to the get job operation.
     * @return Result of the GetJob operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJobResponse getJob(GetJobRequest getJobRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJob");

            return clientHandler.execute(new ClientExecutionParams<GetJobRequest, GetJobResponse>().withOperationName("GetJob")
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getJobRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a network profile.
     * </p>
     *
     * @param getNetworkProfileRequest
     * @return Result of the GetNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetNetworkProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetNetworkProfileResponse getNetworkProfile(GetNetworkProfileRequest getNetworkProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetNetworkProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNetworkProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNetworkProfile");

            return clientHandler.execute(new ClientExecutionParams<GetNetworkProfileRequest, GetNetworkProfileResponse>()
                    .withOperationName("GetNetworkProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getNetworkProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetNetworkProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be
     * able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param getOfferingStatusRequest
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return Result of the GetOfferingStatus operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetOfferingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetOfferingStatusResponse getOfferingStatus(GetOfferingStatusRequest getOfferingStatusRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOfferingStatusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetOfferingStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOfferingStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOfferingStatus");

            return clientHandler.execute(new ClientExecutionParams<GetOfferingStatusRequest, GetOfferingStatusResponse>()
                    .withOperationName("GetOfferingStatus").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getOfferingStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetOfferingStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be
     * able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client.getOfferingStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client
     *             .getOfferingStatusPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusIterable responses = client.getOfferingStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOfferingStatusRequest
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetOfferingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetOfferingStatusIterable getOfferingStatusPaginator(GetOfferingStatusRequest getOfferingStatusRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        return new GetOfferingStatusIterable(this, applyPaginatorUserAgent(getOfferingStatusRequest));
    }

    /**
     * <p>
     * Gets information about a project.
     * </p>
     *
     * @param getProjectRequest
     *        Represents a request to the get project operation.
     * @return Result of the GetProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetProjectResponse getProject(GetProjectRequest getProjectRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProject");

            return clientHandler
                    .execute(new ClientExecutionParams<GetProjectRequest, GetProjectResponse>().withOperationName("GetProject")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getProjectRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a link to a currently running remote access session.
     * </p>
     *
     * @param getRemoteAccessSessionRequest
     *        Represents the request to get information about the specified remote access session.
     * @return Result of the GetRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRemoteAccessSessionResponse getRemoteAccessSession(GetRemoteAccessSessionRequest getRemoteAccessSessionRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRemoteAccessSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRemoteAccessSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRemoteAccessSession");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRemoteAccessSessionRequest, GetRemoteAccessSessionResponse>()
                            .withOperationName("GetRemoteAccessSession").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getRemoteAccessSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRemoteAccessSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a run.
     * </p>
     *
     * @param getRunRequest
     *        Represents a request to the get run operation.
     * @return Result of the GetRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRunResponse getRun(GetRunRequest getRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRun");

            return clientHandler.execute(new ClientExecutionParams<GetRunRequest, GetRunResponse>().withOperationName("GetRun")
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a suite.
     * </p>
     *
     * @param getSuiteRequest
     *        Represents a request to the get suite operation.
     * @return Result of the GetSuite operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSuiteResponse getSuite(GetSuiteRequest getSuiteRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSuiteResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSuiteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSuiteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSuite");

            return clientHandler.execute(new ClientExecutionParams<GetSuiteRequest, GetSuiteResponse>()
                    .withOperationName("GetSuite").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSuiteRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetSuiteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a test.
     * </p>
     *
     * @param getTestRequest
     *        Represents a request to the get test operation.
     * @return Result of the GetTest operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTestResponse getTest(GetTestRequest getTestRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTestResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTest");

            return clientHandler.execute(new ClientExecutionParams<GetTestRequest, GetTestResponse>()
                    .withOperationName("GetTest").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getTestRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetTestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a Selenium testing project.
     * </p>
     *
     * @param getTestGridProjectRequest
     * @return Result of the GetTestGridProject operation returned by the service.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridProject" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetTestGridProjectResponse getTestGridProject(GetTestGridProjectRequest getTestGridProjectRequest)
            throws NotFoundException, ArgumentException, InternalServiceException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTestGridProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetTestGridProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTestGridProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTestGridProject");

            return clientHandler.execute(new ClientExecutionParams<GetTestGridProjectRequest, GetTestGridProjectResponse>()
                    .withOperationName("GetTestGridProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getTestGridProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTestGridProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A session is an instance of a browser created through a <code>RemoteWebDriver</code> with the URL from
     * <a>CreateTestGridUrlResult&#36url</a>. You can use the following to look up sessions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The session ARN (<a>GetTestGridSessionRequest&#36sessionArn</a>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The project ARN and a session ID (<a>GetTestGridSessionRequest&#36projectArn</a> and
     * <a>GetTestGridSessionRequest&#36sessionId</a>).
     * </p>
     * </li>
     * </ul>
     * <p/>
     *
     * @param getTestGridSessionRequest
     * @return Result of the GetTestGridSession operation returned by the service.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetTestGridSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetTestGridSessionResponse getTestGridSession(GetTestGridSessionRequest getTestGridSessionRequest)
            throws NotFoundException, ArgumentException, InternalServiceException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTestGridSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetTestGridSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTestGridSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTestGridSession");

            return clientHandler.execute(new ClientExecutionParams<GetTestGridSessionRequest, GetTestGridSessionResponse>()
                    .withOperationName("GetTestGridSession").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getTestGridSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTestGridSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an upload.
     * </p>
     *
     * @param getUploadRequest
     *        Represents a request to the get upload operation.
     * @return Result of the GetUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetUploadResponse getUpload(GetUploadRequest getUploadRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUploadResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUploadResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUpload");

            return clientHandler.execute(new ClientExecutionParams<GetUploadRequest, GetUploadResponse>()
                    .withOperationName("GetUpload").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUploadRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the configuration settings for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     *
     * @param getVpceConfigurationRequest
     * @return Result of the GetVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.GetVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetVpceConfigurationResponse getVPCEConfiguration(GetVpceConfigurationRequest getVpceConfigurationRequest)
            throws ArgumentException, NotFoundException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVpceConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetVpceConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVpceConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVPCEConfiguration");

            return clientHandler.execute(new ClientExecutionParams<GetVpceConfigurationRequest, GetVpceConfigurationResponse>()
                    .withOperationName("GetVPCEConfiguration").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getVpceConfigurationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVpceConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Installs an application to the device in a remote access session. For Android applications, the file must be in
     * .apk format. For iOS applications, the file must be in .ipa format.
     * </p>
     *
     * @param installToRemoteAccessSessionRequest
     *        Represents the request to install an Android application (in .apk format) or an iOS application (in .ipa
     *        format) as part of a remote access session.
     * @return Result of the InstallToRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.InstallToRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public InstallToRemoteAccessSessionResponse installToRemoteAccessSession(
            InstallToRemoteAccessSessionRequest installToRemoteAccessSessionRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<InstallToRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, InstallToRemoteAccessSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, installToRemoteAccessSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InstallToRemoteAccessSession");

            return clientHandler
                    .execute(new ClientExecutionParams<InstallToRemoteAccessSessionRequest, InstallToRemoteAccessSessionResponse>()
                            .withOperationName("InstallToRemoteAccessSession").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(installToRemoteAccessSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new InstallToRemoteAccessSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     *
     * @param listArtifactsRequest
     *        Represents a request to the list artifacts operation.
     * @return Result of the ListArtifacts operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListArtifactsResponse listArtifacts(ListArtifactsRequest listArtifactsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListArtifactsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListArtifactsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listArtifactsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListArtifacts");

            return clientHandler.execute(new ClientExecutionParams<ListArtifactsRequest, ListArtifactsResponse>()
                    .withOperationName("ListArtifacts").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listArtifactsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListArtifactsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable responses = client
     *             .listArtifactsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsIterable responses = client.listArtifactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation.</b>
     * </p>
     *
     * @param listArtifactsRequest
     *        Represents a request to the list artifacts operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListArtifactsIterable listArtifactsPaginator(ListArtifactsRequest listArtifactsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return new ListArtifactsIterable(this, applyPaginatorUserAgent(listArtifactsRequest));
    }

    /**
     * <p>
     * Returns information about the private device instances associated with one or more AWS accounts.
     * </p>
     *
     * @param listDeviceInstancesRequest
     * @return Result of the ListDeviceInstances operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDeviceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeviceInstancesResponse listDeviceInstances(ListDeviceInstancesRequest listDeviceInstancesRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDeviceInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDeviceInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeviceInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeviceInstances");

            return clientHandler.execute(new ClientExecutionParams<ListDeviceInstancesRequest, ListDeviceInstancesResponse>()
                    .withOperationName("ListDeviceInstances").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDeviceInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDeviceInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     *
     * @param listDevicePoolsRequest
     *        Represents the result of a list device pools request.
     * @return Result of the ListDevicePools operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevicePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDevicePoolsResponse listDevicePools(ListDevicePoolsRequest listDevicePoolsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDevicePoolsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDevicePoolsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDevicePoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDevicePools");

            return clientHandler.execute(new ClientExecutionParams<ListDevicePoolsRequest, ListDevicePoolsResponse>()
                    .withOperationName("ListDevicePools").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDevicePoolsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDevicePoolsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable responses = client.listDevicePoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable responses = client
     *             .listDevicePoolsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsIterable responses = client.listDevicePoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation.</b>
     * </p>
     *
     * @param listDevicePoolsRequest
     *        Represents the result of a list device pools request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevicePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDevicePoolsIterable listDevicePoolsPaginator(ListDevicePoolsRequest listDevicePoolsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return new ListDevicePoolsIterable(this, applyPaginatorUserAgent(listDevicePoolsRequest));
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the result of a list devices request.
     * @return Result of the ListDevices operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDevices");

            return clientHandler.execute(new ClientExecutionParams<ListDevicesRequest, ListDevicesResponse>()
                    .withOperationName("ListDevices").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the result of a list devices request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDevicesIterable listDevicesPaginator(ListDevicesRequest listDevicesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return new ListDevicesIterable(this, applyPaginatorUserAgent(listDevicesRequest));
    }

    /**
     * <p>
     * Returns information about all the instance profiles in an AWS account.
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return Result of the ListInstanceProfiles operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInstanceProfilesResponse listInstanceProfiles(ListInstanceProfilesRequest listInstanceProfilesRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInstanceProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListInstanceProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInstanceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstanceProfiles");

            return clientHandler.execute(new ClientExecutionParams<ListInstanceProfilesRequest, ListInstanceProfilesResponse>()
                    .withOperationName("ListInstanceProfiles").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listInstanceProfilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListInstanceProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about jobs for a given test run.
     * </p>
     *
     * @param listJobsRequest
     *        Represents a request to the list jobs operation.
     * @return Result of the ListJobs operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobs");

            return clientHandler.execute(new ClientExecutionParams<ListJobsRequest, ListJobsResponse>()
                    .withOperationName("ListJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listJobsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about jobs for a given test run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     *        Represents a request to the list jobs operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return new ListJobsIterable(this, applyPaginatorUserAgent(listJobsRequest));
    }

    /**
     * <p>
     * Returns the list of available network profiles.
     * </p>
     *
     * @param listNetworkProfilesRequest
     * @return Result of the ListNetworkProfiles operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListNetworkProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNetworkProfilesResponse listNetworkProfiles(ListNetworkProfilesRequest listNetworkProfilesRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNetworkProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListNetworkProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNetworkProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNetworkProfiles");

            return clientHandler.execute(new ClientExecutionParams<ListNetworkProfilesRequest, ListNetworkProfilesResponse>()
                    .withOperationName("ListNetworkProfiles").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listNetworkProfilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNetworkProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the
     * promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke the
     * operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if
     * you must be able to invoke this operation.
     * </p>
     *
     * @param listOfferingPromotionsRequest
     * @return Result of the ListOfferingPromotions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingPromotions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOfferingPromotionsResponse listOfferingPromotions(ListOfferingPromotionsRequest listOfferingPromotionsRequest)
            throws ArgumentException, NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException,
            AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOfferingPromotionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOfferingPromotionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOfferingPromotionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOfferingPromotions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOfferingPromotionsRequest, ListOfferingPromotionsResponse>()
                            .withOperationName("ListOfferingPromotions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listOfferingPromotionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListOfferingPromotionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be able to
     * invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        Represents the request to list the offering transaction history.
     * @return Result of the ListOfferingTransactions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOfferingTransactionsResponse listOfferingTransactions(
            ListOfferingTransactionsRequest listOfferingTransactionsRequest) throws ArgumentException, NotFoundException,
            NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOfferingTransactionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOfferingTransactionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOfferingTransactionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOfferingTransactions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOfferingTransactionsRequest, ListOfferingTransactionsResponse>()
                            .withOperationName("ListOfferingTransactions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listOfferingTransactionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListOfferingTransactionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be able to
     * invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client.listOfferingTransactionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client
     *             .listOfferingTransactionsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsIterable responses = client.listOfferingTransactionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        Represents the request to list the offering transaction history.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferingTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOfferingTransactionsIterable listOfferingTransactionsPaginator(
            ListOfferingTransactionsRequest listOfferingTransactionsRequest) throws ArgumentException, NotFoundException,
            NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return new ListOfferingTransactionsIterable(this, applyPaginatorUserAgent(listOfferingTransactionsRequest));
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact
     * <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param listOfferingsRequest
     *        Represents the request to list all offerings.
     * @return Result of the ListOfferings operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOfferingsResponse listOfferings(ListOfferingsRequest listOfferingsRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOfferingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOfferingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOfferings");

            return clientHandler.execute(new ClientExecutionParams<ListOfferingsRequest, ListOfferingsResponse>()
                    .withOperationName("ListOfferings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listOfferingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOfferingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact
     * <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client
     *             .listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     *        Represents the request to list all offerings.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOfferingsIterable listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return new ListOfferingsIterable(this, applyPaginatorUserAgent(listOfferingsRequest));
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     *
     * @param listProjectsRequest
     *        Represents a request to the list projects operation.
     * @return Result of the ListProjects operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProjectsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListProjectsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProjects");

            return clientHandler.execute(new ClientExecutionParams<ListProjectsRequest, ListProjectsResponse>()
                    .withOperationName("ListProjects").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listProjectsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListProjectsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     *        Represents a request to the list projects operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return new ListProjectsIterable(this, applyPaginatorUserAgent(listProjectsRequest));
    }

    /**
     * <p>
     * Returns a list of all currently running remote access sessions.
     * </p>
     *
     * @param listRemoteAccessSessionsRequest
     *        Represents the request to return information about the remote access session.
     * @return Result of the ListRemoteAccessSessions operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListRemoteAccessSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRemoteAccessSessionsResponse listRemoteAccessSessions(
            ListRemoteAccessSessionsRequest listRemoteAccessSessionsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRemoteAccessSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRemoteAccessSessionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRemoteAccessSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRemoteAccessSessions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRemoteAccessSessionsRequest, ListRemoteAccessSessionsResponse>()
                            .withOperationName("ListRemoteAccessSessions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listRemoteAccessSessionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRemoteAccessSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     *
     * @param listRunsRequest
     *        Represents a request to the list runs operation.
     * @return Result of the ListRuns operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRunsResponse listRuns(ListRunsRequest listRunsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRunsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRunsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRuns");

            return clientHandler.execute(new ClientExecutionParams<ListRunsRequest, ListRunsResponse>()
                    .withOperationName("ListRuns").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listRunsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListRunsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable responses = client.listRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable responses = client.listRunsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsIterable responses = client.listRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)} operation.</b>
     * </p>
     *
     * @param listRunsRequest
     *        Represents a request to the list runs operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRunsIterable listRunsPaginator(ListRunsRequest listRunsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return new ListRunsIterable(this, applyPaginatorUserAgent(listRunsRequest));
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm job ARN.
     * </p>
     *
     * @param listSamplesRequest
     *        Represents a request to the list samples operation.
     * @return Result of the ListSamples operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSamples
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSamplesResponse listSamples(ListSamplesRequest listSamplesRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSamplesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSamplesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSamplesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSamples");

            return clientHandler.execute(new ClientExecutionParams<ListSamplesRequest, ListSamplesResponse>()
                    .withOperationName("ListSamples").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listSamplesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSamplesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm job ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable responses = client.listSamplesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable responses = client.listSamplesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesIterable responses = client.listSamplesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)} operation.</b>
     * </p>
     *
     * @param listSamplesRequest
     *        Represents a request to the list samples operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSamples
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSamplesIterable listSamplesPaginator(ListSamplesRequest listSamplesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return new ListSamplesIterable(this, applyPaginatorUserAgent(listSamplesRequest));
    }

    /**
     * <p>
     * Gets information about test suites for a given job.
     * </p>
     *
     * @param listSuitesRequest
     *        Represents a request to the list suites operation.
     * @return Result of the ListSuites operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSuitesResponse listSuites(ListSuitesRequest listSuitesRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSuitesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSuitesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSuitesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSuites");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSuitesRequest, ListSuitesResponse>().withOperationName("ListSuites")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listSuitesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSuitesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about test suites for a given job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable responses = client.listSuitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable responses = client.listSuitesPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesIterable responses = client.listSuitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)} operation.</b>
     * </p>
     *
     * @param listSuitesRequest
     *        Represents a request to the list suites operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSuitesIterable listSuitesPaginator(ListSuitesRequest listSuitesRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return new ListSuitesIterable(this, applyPaginatorUserAgent(listSuitesRequest));
    }

    /**
     * <p>
     * List the tags for an AWS Device Farm resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws TagOperationException
     *         The operation was not successful. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ArgumentException, NotFoundException, TagOperationException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of all Selenium testing projects in your account.
     * </p>
     *
     * @param listTestGridProjectsRequest
     * @return Result of the ListTestGridProjects operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTestGridProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridProjects"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestGridProjectsResponse listTestGridProjects(ListTestGridProjectsRequest listTestGridProjectsRequest)
            throws ArgumentException, InternalServiceException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestGridProjectsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTestGridProjectsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestGridProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestGridProjects");

            return clientHandler.execute(new ClientExecutionParams<ListTestGridProjectsRequest, ListTestGridProjectsResponse>()
                    .withOperationName("ListTestGridProjects").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTestGridProjectsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTestGridProjectsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of all Selenium testing projects in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestGridProjects(software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridProjectsIterable responses = client.listTestGridProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListTestGridProjectsIterable responses = client
     *             .listTestGridProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridProjectsIterable responses = client.listTestGridProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridProjects(software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestGridProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTestGridProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridProjects"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestGridProjectsIterable listTestGridProjectsPaginator(ListTestGridProjectsRequest listTestGridProjectsRequest)
            throws ArgumentException, InternalServiceException, AwsServiceException, SdkClientException, DeviceFarmException {
        return new ListTestGridProjectsIterable(this, applyPaginatorUserAgent(listTestGridProjectsRequest));
    }

    /**
     * <p>
     * Returns a list of the actions taken in a <a>TestGridSession</a>.
     * </p>
     *
     * @param listTestGridSessionActionsRequest
     * @return Result of the ListTestGridSessionActions operation returned by the service.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTestGridSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestGridSessionActionsResponse listTestGridSessionActions(
            ListTestGridSessionActionsRequest listTestGridSessionActionsRequest) throws NotFoundException, ArgumentException,
            InternalServiceException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestGridSessionActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTestGridSessionActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestGridSessionActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestGridSessionActions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTestGridSessionActionsRequest, ListTestGridSessionActionsResponse>()
                            .withOperationName("ListTestGridSessionActions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listTestGridSessionActionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTestGridSessionActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the actions taken in a <a>TestGridSession</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestGridSessionActions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionActionsIterable responses = client.listTestGridSessionActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionActionsIterable responses = client
     *             .listTestGridSessionActionsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionActionsIterable responses = client.listTestGridSessionActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridSessionActions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestGridSessionActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTestGridSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestGridSessionActionsIterable listTestGridSessionActionsPaginator(
            ListTestGridSessionActionsRequest listTestGridSessionActionsRequest) throws NotFoundException, ArgumentException,
            InternalServiceException, AwsServiceException, SdkClientException, DeviceFarmException {
        return new ListTestGridSessionActionsIterable(this, applyPaginatorUserAgent(listTestGridSessionActionsRequest));
    }

    /**
     * <p>
     * Retrieves a list of artifacts created during the session.
     * </p>
     *
     * @param listTestGridSessionArtifactsRequest
     * @return Result of the ListTestGridSessionArtifacts operation returned by the service.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTestGridSessionArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestGridSessionArtifactsResponse listTestGridSessionArtifacts(
            ListTestGridSessionArtifactsRequest listTestGridSessionArtifactsRequest) throws NotFoundException, ArgumentException,
            InternalServiceException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestGridSessionArtifactsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTestGridSessionArtifactsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestGridSessionArtifactsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestGridSessionArtifacts");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTestGridSessionArtifactsRequest, ListTestGridSessionArtifactsResponse>()
                            .withOperationName("ListTestGridSessionArtifacts").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listTestGridSessionArtifactsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTestGridSessionArtifactsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of artifacts created during the session.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestGridSessionArtifacts(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionArtifactsIterable responses = client.listTestGridSessionArtifactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionArtifactsIterable responses = client
     *             .listTestGridSessionArtifactsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionArtifactsIterable responses = client.listTestGridSessionArtifactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridSessionArtifacts(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestGridSessionArtifactsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTestGridSessionArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestGridSessionArtifactsIterable listTestGridSessionArtifactsPaginator(
            ListTestGridSessionArtifactsRequest listTestGridSessionArtifactsRequest) throws NotFoundException, ArgumentException,
            InternalServiceException, AwsServiceException, SdkClientException, DeviceFarmException {
        return new ListTestGridSessionArtifactsIterable(this, applyPaginatorUserAgent(listTestGridSessionArtifactsRequest));
    }

    /**
     * <p>
     * Retrieves a list of sessions for a <a>TestGridProject</a>.
     * </p>
     *
     * @param listTestGridSessionsRequest
     * @return Result of the ListTestGridSessions operation returned by the service.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTestGridSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestGridSessionsResponse listTestGridSessions(ListTestGridSessionsRequest listTestGridSessionsRequest)
            throws NotFoundException, ArgumentException, InternalServiceException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestGridSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTestGridSessionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestGridSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTestGridSessions");

            return clientHandler.execute(new ClientExecutionParams<ListTestGridSessionsRequest, ListTestGridSessionsResponse>()
                    .withOperationName("ListTestGridSessions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTestGridSessionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTestGridSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of sessions for a <a>TestGridProject</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTestGridSessions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionsIterable responses = client.listTestGridSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionsIterable responses = client
     *             .listTestGridSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionsIterable responses = client.listTestGridSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridSessions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestGridSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTestGridSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTestGridSessionsIterable listTestGridSessionsPaginator(ListTestGridSessionsRequest listTestGridSessionsRequest)
            throws NotFoundException, ArgumentException, InternalServiceException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return new ListTestGridSessionsIterable(this, applyPaginatorUserAgent(listTestGridSessionsRequest));
    }

    /**
     * <p>
     * Gets information about tests in a given test suite.
     * </p>
     *
     * @param listTestsRequest
     *        Represents a request to the list tests operation.
     * @return Result of the ListTests operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTestsResponse listTests(ListTestsRequest listTestsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTestsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTestsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTests");

            return clientHandler.execute(new ClientExecutionParams<ListTestsRequest, ListTestsResponse>()
                    .withOperationName("ListTests").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTestsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTestsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about tests in a given test suite.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable responses = client.listTestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable responses = client.listTestsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListTestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsIterable responses = client.listTestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)} operation.</b>
     * </p>
     *
     * @param listTestsRequest
     *        Represents a request to the list tests operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListTests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTestsIterable listTestsPaginator(ListTestsRequest listTestsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        return new ListTestsIterable(this, applyPaginatorUserAgent(listTestsRequest));
    }

    /**
     * <p>
     * Gets information about unique problems, such as exceptions or crashes.
     * </p>
     * <p>
     * Unique problems are defined as a single instance of an error across a run, job, or suite. For example, if a call
     * in your application consistently raises an exception (<code>OutOfBoundsException in MyActivity.java:386</code>),
     * <code>ListUniqueProblems</code> returns a single entry instead of many individual entries for that exception.
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        Represents a request to the list unique problems operation.
     * @return Result of the ListUniqueProblems operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUniqueProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListUniqueProblemsResponse listUniqueProblems(ListUniqueProblemsRequest listUniqueProblemsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUniqueProblemsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListUniqueProblemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUniqueProblemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUniqueProblems");

            return clientHandler.execute(new ClientExecutionParams<ListUniqueProblemsRequest, ListUniqueProblemsResponse>()
                    .withOperationName("ListUniqueProblems").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUniqueProblemsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUniqueProblemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about unique problems, such as exceptions or crashes.
     * </p>
     * <p>
     * Unique problems are defined as a single instance of an error across a run, job, or suite. For example, if a call
     * in your application consistently raises an exception (<code>OutOfBoundsException in MyActivity.java:386</code>),
     * <code>ListUniqueProblems</code> returns a single entry instead of many individual entries for that exception.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable responses = client.listUniqueProblemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable responses = client
     *             .listUniqueProblemsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsIterable responses = client.listUniqueProblemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        Represents a request to the list unique problems operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUniqueProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListUniqueProblemsIterable listUniqueProblemsPaginator(ListUniqueProblemsRequest listUniqueProblemsRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        return new ListUniqueProblemsIterable(this, applyPaginatorUserAgent(listUniqueProblemsRequest));
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     *
     * @param listUploadsRequest
     *        Represents a request to the list uploads operation.
     * @return Result of the ListUploads operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUploadsResponse listUploads(ListUploadsRequest listUploadsRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUploadsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListUploadsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUploadsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUploads");

            return clientHandler.execute(new ClientExecutionParams<ListUploadsRequest, ListUploadsResponse>()
                    .withOperationName("ListUploads").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUploadsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUploadsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable responses = client.listUploadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable responses = client.listUploadsPaginator(request);
     *     for (software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsIterable responses = client.listUploadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)} operation.</b>
     * </p>
     *
     * @param listUploadsRequest
     *        Represents a request to the list uploads operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUploadsIterable listUploadsPaginator(ListUploadsRequest listUploadsRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        return new ListUploadsIterable(this, applyPaginatorUserAgent(listUploadsRequest));
    }

    /**
     * <p>
     * Returns information about all Amazon Virtual Private Cloud (VPC) endpoint configurations in the AWS account.
     * </p>
     *
     * @param listVpceConfigurationsRequest
     * @return Result of the ListVPCEConfigurations operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ListVPCEConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListVPCEConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListVpceConfigurationsResponse listVPCEConfigurations(ListVpceConfigurationsRequest listVpceConfigurationsRequest)
            throws ArgumentException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVpceConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVpceConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVpceConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVPCEConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListVpceConfigurationsRequest, ListVpceConfigurationsResponse>()
                            .withOperationName("ListVPCEConfigurations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listVpceConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListVpceConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for
     * an offering, unless the renewal was overridden. The API returns a <code>NotEligible</code> error if the user is
     * not permitted to invoke the operation. If you must be able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param purchaseOfferingRequest
     *        Represents a request for a purchase offering.
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PurchaseOfferingResponse purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PurchaseOfferingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PurchaseOfferingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, purchaseOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseOffering");

            return clientHandler.execute(new ClientExecutionParams<PurchaseOfferingRequest, PurchaseOfferingResponse>()
                    .withOperationName("PurchaseOffering").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(purchaseOfferingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PurchaseOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Explicitly sets the quantity of devices to renew for an offering, starting from the <code>effectiveDate</code> of
     * the next period. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the
     * operation. If you must be able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param renewOfferingRequest
     *        A request that represents an offering renewal.
     * @return Result of the RenewOffering operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws NotEligibleException
     *         Exception gets thrown when a user is not eligible to perform the specified transaction.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.RenewOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RenewOfferingResponse renewOffering(RenewOfferingRequest renewOfferingRequest) throws ArgumentException,
            NotFoundException, NotEligibleException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RenewOfferingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RenewOfferingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, renewOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RenewOffering");

            return clientHandler.execute(new ClientExecutionParams<RenewOfferingRequest, RenewOfferingResponse>()
                    .withOperationName("RenewOffering").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(renewOfferingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RenewOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Schedules a run.
     * </p>
     *
     * @param scheduleRunRequest
     *        Represents a request to the schedule run operation.
     * @return Result of the ScheduleRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.ScheduleRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ScheduleRunResponse scheduleRun(ScheduleRunRequest scheduleRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, IdempotencyException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ScheduleRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ScheduleRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, scheduleRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ScheduleRun");

            return clientHandler.execute(new ClientExecutionParams<ScheduleRunRequest, ScheduleRunResponse>()
                    .withOperationName("ScheduleRun").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(scheduleRunRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ScheduleRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates a stop request for the current job. AWS Device Farm immediately stops the job on the device where tests
     * have not started. You are not billed for this device. On the device where tests have started, setup suite and
     * teardown suite tests run to completion on the device. You are billed for setup, teardown, and any tests that were
     * in progress or already completed.
     * </p>
     *
     * @param stopJobRequest
     * @return Result of the StopJob operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.StopJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopJobResponse stopJob(StopJobRequest stopJobRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopJob");

            return clientHandler.execute(new ClientExecutionParams<StopJobRequest, StopJobResponse>()
                    .withOperationName("StopJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopJobRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new StopJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Ends a specified remote access session.
     * </p>
     *
     * @param stopRemoteAccessSessionRequest
     *        Represents the request to stop the remote access session.
     * @return Result of the StopRemoteAccessSession operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.StopRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopRemoteAccessSessionResponse stopRemoteAccessSession(StopRemoteAccessSessionRequest stopRemoteAccessSessionRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopRemoteAccessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopRemoteAccessSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopRemoteAccessSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopRemoteAccessSession");

            return clientHandler
                    .execute(new ClientExecutionParams<StopRemoteAccessSessionRequest, StopRemoteAccessSessionResponse>()
                            .withOperationName("StopRemoteAccessSession").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(stopRemoteAccessSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopRemoteAccessSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates a stop request for the current test run. AWS Device Farm immediately stops the run on devices where
     * tests have not started. You are not billed for these devices. On devices where tests have started executing,
     * setup suite and teardown suite tests run to completion on those devices. You are billed for setup, teardown, and
     * any tests that were in progress or already completed.
     * </p>
     *
     * @param stopRunRequest
     *        Represents the request to stop a specific run.
     * @return Result of the StopRun operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.StopRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopRunResponse stopRun(StopRunRequest stopRunRequest) throws ArgumentException, NotFoundException,
            LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopRun");

            return clientHandler.execute(new ClientExecutionParams<StopRunRequest, StopRunResponse>()
                    .withOperationName("StopRun").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new StopRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws TagOperationException
     *         The operation was not successful. Try again.
     * @throws TooManyTagsException
     *         The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a
     *         repository is 50.
     * @throws TagPolicyException
     *         The request doesn't comply with the AWS Identity and Access Management (IAM) tag policy. Correct your
     *         request and then retry it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ArgumentException, NotFoundException,
            TagOperationException, TooManyTagsException, TagPolicyException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws TagOperationException
     *         The operation was not successful. Try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ArgumentException,
            NotFoundException, TagOperationException, AwsServiceException, SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates information about a private device instance.
     * </p>
     *
     * @param updateDeviceInstanceRequest
     * @return Result of the UpdateDeviceInstance operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateDeviceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDeviceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDeviceInstanceResponse updateDeviceInstance(UpdateDeviceInstanceRequest updateDeviceInstanceRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDeviceInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDeviceInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeviceInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeviceInstance");

            return clientHandler.execute(new ClientExecutionParams<UpdateDeviceInstanceRequest, UpdateDeviceInstanceResponse>()
                    .withOperationName("UpdateDeviceInstance").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDeviceInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDeviceInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates
     * are all-or-nothing, meaning they can only be updated as a whole (or not at all).
     * </p>
     *
     * @param updateDevicePoolRequest
     *        Represents a request to the update device pool operation.
     * @return Result of the UpdateDevicePool operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDevicePoolResponse updateDevicePool(UpdateDevicePoolRequest updateDevicePoolRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDevicePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDevicePoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDevicePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDevicePool");

            return clientHandler.execute(new ClientExecutionParams<UpdateDevicePoolRequest, UpdateDevicePoolResponse>()
                    .withOperationName("UpdateDevicePool").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDevicePoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDevicePoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates information about an existing private device instance profile.
     * </p>
     *
     * @param updateInstanceProfileRequest
     * @return Result of the UpdateInstanceProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateInstanceProfileResponse updateInstanceProfile(UpdateInstanceProfileRequest updateInstanceProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateInstanceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInstanceProfile");

            return clientHandler.execute(new ClientExecutionParams<UpdateInstanceProfileRequest, UpdateInstanceProfileResponse>()
                    .withOperationName("UpdateInstanceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateInstanceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the network profile.
     * </p>
     *
     * @param updateNetworkProfileRequest
     * @return Result of the UpdateNetworkProfile operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateNetworkProfileResponse updateNetworkProfile(UpdateNetworkProfileRequest updateNetworkProfileRequest)
            throws ArgumentException, NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateNetworkProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNetworkProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNetworkProfile");

            return clientHandler.execute(new ClientExecutionParams<UpdateNetworkProfileRequest, UpdateNetworkProfileResponse>()
                    .withOperationName("UpdateNetworkProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateNetworkProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateNetworkProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the specified project name, given the project ARN and a new name.
     * </p>
     *
     * @param updateProjectRequest
     *        Represents a request to the update project operation.
     * @return Result of the UpdateProject operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProject");

            return clientHandler.execute(new ClientExecutionParams<UpdateProjectRequest, UpdateProjectResponse>()
                    .withOperationName("UpdateProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Change details of a project.
     * </p>
     *
     * @param updateTestGridProjectRequest
     * @return Result of the UpdateTestGridProject operation returned by the service.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws InternalServiceException
     *         An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateTestGridProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTestGridProjectResponse updateTestGridProject(UpdateTestGridProjectRequest updateTestGridProjectRequest)
            throws NotFoundException, ArgumentException, LimitExceededException, InternalServiceException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTestGridProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateTestGridProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTestGridProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTestGridProject");

            return clientHandler.execute(new ClientExecutionParams<UpdateTestGridProjectRequest, UpdateTestGridProjectResponse>()
                    .withOperationName("UpdateTestGridProject").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateTestGridProjectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateTestGridProjectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an uploaded test spec.
     * </p>
     *
     * @param updateUploadRequest
     * @return Result of the UpdateUpload operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws LimitExceededException
     *         A limit was exceeded.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateUploadResponse updateUpload(UpdateUploadRequest updateUploadRequest) throws ArgumentException,
            NotFoundException, LimitExceededException, ServiceAccountException, AwsServiceException, SdkClientException,
            DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUploadResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateUploadResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUpload");

            return clientHandler.execute(new ClientExecutionParams<UpdateUploadRequest, UpdateUploadResponse>()
                    .withOperationName("UpdateUpload").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateUploadRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates information about an Amazon Virtual Private Cloud (VPC) endpoint configuration.
     * </p>
     *
     * @param updateVpceConfigurationRequest
     * @return Result of the UpdateVPCEConfiguration operation returned by the service.
     * @throws ArgumentException
     *         An invalid argument was specified.
     * @throws NotFoundException
     *         The specified entity was not found.
     * @throws ServiceAccountException
     *         There was a problem with the service account.
     * @throws InvalidOperationException
     *         There was an error with the update request, or you do not have sufficient permissions to update this VPC
     *         endpoint configuration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DeviceFarmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DeviceFarmClient.UpdateVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateVpceConfigurationResponse updateVPCEConfiguration(UpdateVpceConfigurationRequest updateVpceConfigurationRequest)
            throws ArgumentException, NotFoundException, ServiceAccountException, InvalidOperationException, AwsServiceException,
            SdkClientException, DeviceFarmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVpceConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateVpceConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVpceConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Device Farm");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVPCEConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateVpceConfigurationRequest, UpdateVpceConfigurationResponse>()
                            .withOperationName("UpdateVPCEConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateVpceConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateVpceConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(DeviceFarmException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotEligibleException")
                                .exceptionBuilderSupplier(NotEligibleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOperationException")
                                .exceptionBuilderSupplier(InvalidOperationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ArgumentException")
                                .exceptionBuilderSupplier(ArgumentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CannotDeleteException")
                                .exceptionBuilderSupplier(CannotDeleteException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServiceException")
                                .exceptionBuilderSupplier(InternalServiceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceAccountException")
                                .exceptionBuilderSupplier(ServiceAccountException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagOperationException")
                                .exceptionBuilderSupplier(TagOperationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagPolicyException")
                                .exceptionBuilderSupplier(TagPolicyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotencyException")
                                .exceptionBuilderSupplier(IdempotencyException::builder).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends DeviceFarmRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
