/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An action taken by a <a>TestGridSession</a> browser instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestGridSessionAction implements SdkPojo, Serializable,
        ToCopyableBuilder<TestGridSessionAction.Builder, TestGridSessionAction> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(TestGridSessionAction::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Instant> STARTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("started").getter(getter(TestGridSessionAction::started)).setter(setter(Builder::started))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("started").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("duration")
            .getter(getter(TestGridSessionAction::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(TestGridSessionAction::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> REQUEST_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestMethod").getter(getter(TestGridSessionAction::requestMethod))
            .setter(setter(Builder::requestMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, STARTED_FIELD,
            DURATION_FIELD, STATUS_CODE_FIELD, REQUEST_METHOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final Instant started;

    private final Long duration;

    private final String statusCodeValue;

    private final String requestMethod;

    private TestGridSessionAction(BuilderImpl builder) {
        this.action = builder.action;
        this.started = builder.started;
        this.duration = builder.duration;
        this.statusCodeValue = builder.statusCodeValue;
        this.requestMethod = builder.requestMethod;
    }

    /**
     * <p>
     * The action taken by the session.
     * </p>
     * 
     * @return The action taken by the session.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The time that the session invoked the action.
     * </p>
     * 
     * @return The time that the session invoked the action.
     */
    public final Instant started() {
        return started;
    }

    /**
     * <p>
     * The time, in milliseconds, that the action took to complete in the browser.
     * </p>
     * 
     * @return The time, in milliseconds, that the action took to complete in the browser.
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * HTTP status code returned to the browser when the action was taken.
     * </p>
     * 
     * @return HTTP status code returned to the browser when the action was taken.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    /**
     * <p>
     * HTTP method that the browser used to make the request.
     * </p>
     * 
     * @return HTTP method that the browser used to make the request.
     */
    public final String requestMethod() {
        return requestMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(started());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(requestMethod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestGridSessionAction)) {
            return false;
        }
        TestGridSessionAction other = (TestGridSessionAction) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(started(), other.started())
                && Objects.equals(duration(), other.duration()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(requestMethod(), other.requestMethod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestGridSessionAction").add("Action", action()).add("Started", started())
                .add("Duration", duration()).add("StatusCode", statusCode()).add("RequestMethod", requestMethod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "started":
            return Optional.ofNullable(clazz.cast(started()));
        case "duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "requestMethod":
            return Optional.ofNullable(clazz.cast(requestMethod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestGridSessionAction, T> g) {
        return obj -> g.apply((TestGridSessionAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestGridSessionAction> {
        /**
         * <p>
         * The action taken by the session.
         * </p>
         * 
         * @param action
         *        The action taken by the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The time that the session invoked the action.
         * </p>
         * 
         * @param started
         *        The time that the session invoked the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Instant started);

        /**
         * <p>
         * The time, in milliseconds, that the action took to complete in the browser.
         * </p>
         * 
         * @param duration
         *        The time, in milliseconds, that the action took to complete in the browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * HTTP status code returned to the browser when the action was taken.
         * </p>
         * 
         * @param statusCodeValue
         *        HTTP status code returned to the browser when the action was taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * HTTP method that the browser used to make the request.
         * </p>
         * 
         * @param requestMethod
         *        HTTP method that the browser used to make the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMethod(String requestMethod);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private Instant started;

        private Long duration;

        private String statusCodeValue;

        private String requestMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(TestGridSessionAction model) {
            action(model.action);
            started(model.started);
            duration(model.duration);
            statusCode(model.statusCodeValue);
            requestMethod(model.requestMethod);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Instant getStarted() {
            return started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Long getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final String getRequestMethod() {
            return requestMethod;
        }

        @Override
        public final Builder requestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public final void setRequestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
        }

        @Override
        public TestGridSessionAction build() {
            return new TestGridSessionAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
