/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list devices request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDevicesRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<ListDevicesRequest.Builder, ListDevicesRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ListDevicesRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDevicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<DeviceFilter>> FILTERS_FIELD = SdkField
            .<List<DeviceFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListDevicesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NEXT_TOKEN_FIELD,
            FILTERS_FIELD));

    private final String arn;

    private final String nextToken;

    private final List<DeviceFilter> filters;

    private ListDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Attribute: The aspect of a device such as platform or model used as the selection criteria in a device filter.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ARN: The Amazon Resource Name (ARN) of the device (for example,
     * <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM: The device platform. Valid values are ANDROID or IOS.
     * </p>
     * </li>
     * <li>
     * <p>
     * OS_VERSION: The operating system version (for example, 10.3.2).
     * </p>
     * </li>
     * <li>
     * <p>
     * MODEL: The device model (for example, iPad 5th Gen).
     * </p>
     * </li>
     * <li>
     * <p>
     * AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
     * TEMPORARY_NOT_AVAILABLE.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
     * </p>
     * </li>
     * <li>
     * <p>
     * MANUFACTURER: The device manufacturer (for example, Apple).
     * </p>
     * </li>
     * <li>
     * <p>
     * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
     * </p>
     * </li>
     * <li>
     * <p>
     * REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE. Because
     * remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
     * supported</a>, this attribute is ignored.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_LABELS: The label of the device instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Operator: The filter operator.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The EQUALS operator is available for every attribute except INSTANCE_LABELS.
     * </p>
     * </li>
     * <li>
     * <p>
     * The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN
     * attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for the
     * OS_VERSION attribute.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Values: An array of one or more filter values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The IN and NOT_IN operators take a values array that has one or more elements.
     * </p>
     * </li>
     * <li>
     * <p>
     * The other operators require an array with a single element.
     * </p>
     * </li>
     * <li>
     * <p>
     * In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
     * TEMPORARY_NOT_AVAILABLE.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more
     *         values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Attribute: The aspect of a device such as platform or model used as the selection criteria in a device
     *         filter.
     *         </p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ARN: The Amazon Resource Name (ARN) of the device (for example,
     *         <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM: The device platform. Valid values are ANDROID or IOS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OS_VERSION: The operating system version (for example, 10.3.2).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MODEL: The device model (for example, iPad 5th Gen).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY,
     *         or TEMPORARY_NOT_AVAILABLE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MANUFACTURER: The device manufacturer (for example, Apple).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
     *         Because remote debugging is <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>,
     *         this attribute is ignored.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_LABELS: The label of the device instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Operator: The filter operator.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The EQUALS operator is available for every attribute except INSTANCE_LABELS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN
     *         attributes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available
     *         for the OS_VERSION attribute.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Values: An array of one or more filter values.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The IN and NOT_IN operators take a values array that has one or more elements.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The other operators require an array with a single element.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY,
     *         or TEMPORARY_NOT_AVAILABLE.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<DeviceFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesRequest)) {
            return false;
        }
        ListDevicesRequest other = (ListDevicesRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDevicesRequest").add("Arn", arn()).add("NextToken", nextToken())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesRequest, T> g) {
        return obj -> g.apply((ListDevicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDevicesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Attribute: The aspect of a device such as platform or model used as the selection criteria in a device
         * filter.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The Amazon Resource Name (ARN) of the device (for example,
         * <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The device platform. Valid values are ANDROID or IOS.
         * </p>
         * </li>
         * <li>
         * <p>
         * OS_VERSION: The operating system version (for example, 10.3.2).
         * </p>
         * </li>
         * <li>
         * <p>
         * MODEL: The device model (for example, iPad 5th Gen).
         * </p>
         * </li>
         * <li>
         * <p>
         * AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         * TEMPORARY_NOT_AVAILABLE.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The device manufacturer (for example, Apple).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
         * Because remote debugging is <a
         * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>,
         * this attribute is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_LABELS: The label of the device instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Operator: The filter operator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The EQUALS operator is available for every attribute except INSTANCE_LABELS.
         * </p>
         * </li>
         * <li>
         * <p>
         * The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN
         * attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for
         * the OS_VERSION attribute.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Values: An array of one or more filter values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The IN and NOT_IN operators take a values array that has one or more elements.
         * </p>
         * </li>
         * <li>
         * <p>
         * The other operators require an array with a single element.
         * </p>
         * </li>
         * <li>
         * <p>
         * In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         * TEMPORARY_NOT_AVAILABLE.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more
         *        values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Attribute: The aspect of a device such as platform or model used as the selection criteria in a device
         *        filter.
         *        </p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The Amazon Resource Name (ARN) of the device (for example,
         *        <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The device platform. Valid values are ANDROID or IOS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OS_VERSION: The operating system version (for example, 10.3.2).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MODEL: The device model (for example, iPad 5th Gen).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE,
         *        BUSY, or TEMPORARY_NOT_AVAILABLE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The device manufacturer (for example, Apple).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or
         *        FALSE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or
         *        FALSE. Because remote debugging is <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
         *        supported</a>, this attribute is ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_LABELS: The label of the device instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Operator: The filter operator.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The EQUALS operator is available for every attribute except INSTANCE_LABELS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and
         *        INSTANCE_ARN attributes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also
         *        available for the OS_VERSION attribute.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Values: An array of one or more filter values.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The IN and NOT_IN operators take a values array that has one or more elements.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The other operators require an array with a single element.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE,
         *        BUSY, or TEMPORARY_NOT_AVAILABLE.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<DeviceFilter> filters);

        /**
         * <p>
         * Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Attribute: The aspect of a device such as platform or model used as the selection criteria in a device
         * filter.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The Amazon Resource Name (ARN) of the device (for example,
         * <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The device platform. Valid values are ANDROID or IOS.
         * </p>
         * </li>
         * <li>
         * <p>
         * OS_VERSION: The operating system version (for example, 10.3.2).
         * </p>
         * </li>
         * <li>
         * <p>
         * MODEL: The device model (for example, iPad 5th Gen).
         * </p>
         * </li>
         * <li>
         * <p>
         * AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         * TEMPORARY_NOT_AVAILABLE.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The device manufacturer (for example, Apple).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
         * Because remote debugging is <a
         * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>,
         * this attribute is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_LABELS: The label of the device instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Operator: The filter operator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The EQUALS operator is available for every attribute except INSTANCE_LABELS.
         * </p>
         * </li>
         * <li>
         * <p>
         * The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN
         * attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for
         * the OS_VERSION attribute.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Values: An array of one or more filter values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The IN and NOT_IN operators take a values array that has one or more elements.
         * </p>
         * </li>
         * <li>
         * <p>
         * The other operators require an array with a single element.
         * </p>
         * </li>
         * <li>
         * <p>
         * In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         * TEMPORARY_NOT_AVAILABLE.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more
         *        values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Attribute: The aspect of a device such as platform or model used as the selection criteria in a device
         *        filter.
         *        </p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The Amazon Resource Name (ARN) of the device (for example,
         *        <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The device platform. Valid values are ANDROID or IOS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OS_VERSION: The operating system version (for example, 10.3.2).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MODEL: The device model (for example, iPad 5th Gen).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE,
         *        BUSY, or TEMPORARY_NOT_AVAILABLE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The device manufacturer (for example, Apple).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or
         *        FALSE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or
         *        FALSE. Because remote debugging is <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
         *        supported</a>, this attribute is ignored.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_LABELS: The label of the device instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Operator: The filter operator.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The EQUALS operator is available for every attribute except INSTANCE_LABELS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and
         *        INSTANCE_ARN attributes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also
         *        available for the OS_VERSION attribute.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Values: An array of one or more filter values.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The IN and NOT_IN operators take a values array that has one or more elements.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The other operators require an array with a single element.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE,
         *        BUSY, or TEMPORARY_NOT_AVAILABLE.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DeviceFilter... filters);

        /**
         * <p>
         * Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Attribute: The aspect of a device such as platform or model used as the selection criteria in a device
         * filter.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The Amazon Resource Name (ARN) of the device (for example,
         * <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The device platform. Valid values are ANDROID or IOS.
         * </p>
         * </li>
         * <li>
         * <p>
         * OS_VERSION: The operating system version (for example, 10.3.2).
         * </p>
         * </li>
         * <li>
         * <p>
         * MODEL: The device model (for example, iPad 5th Gen).
         * </p>
         * </li>
         * <li>
         * <p>
         * AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         * TEMPORARY_NOT_AVAILABLE.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The device manufacturer (for example, Apple).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
         * Because remote debugging is <a
         * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>,
         * this attribute is ignored.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_LABELS: The label of the device instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Operator: The filter operator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The EQUALS operator is available for every attribute except INSTANCE_LABELS.
         * </p>
         * </li>
         * <li>
         * <p>
         * The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN
         * attributes.
         * </p>
         * </li>
         * <li>
         * <p>
         * The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for
         * the OS_VERSION attribute.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Values: An array of one or more filter values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The IN and NOT_IN operators take a values array that has one or more elements.
         * </p>
         * </li>
         * <li>
         * <p>
         * The other operators require an array with a single element.
         * </p>
         * </li>
         * <li>
         * <p>
         * In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         * TEMPORARY_NOT_AVAILABLE.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<DeviceFilter>.Builder} avoiding the need to
         * create one manually via {@link List<DeviceFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<DeviceFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<DeviceFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<DeviceFilter>)
         */
        Builder filters(Consumer<DeviceFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String arn;

        private String nextToken;

        private List<DeviceFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesRequest model) {
            super(model);
            arn(model.arn);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<DeviceFilter.Builder> getFilters() {
            List<DeviceFilter.Builder> result = DeviceFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<DeviceFilter> filters) {
            this.filters = DeviceFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DeviceFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DeviceFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> DeviceFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<DeviceFilter.BuilderImpl> filters) {
            this.filters = DeviceFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDevicesRequest build() {
            return new ListDevicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
