/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.CPU;
import software.amazon.awssdk.services.devicefarm.model.DeviceAvailability;
import software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor;
import software.amazon.awssdk.services.devicefarm.model.DeviceInstance;
import software.amazon.awssdk.services.devicefarm.model.DeviceInstancesCopier;
import software.amazon.awssdk.services.devicefarm.model.DevicePlatform;
import software.amazon.awssdk.services.devicefarm.model.Resolution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Device
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Device> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Device.getter(Device::arn)).setter(Device.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Device.getter(Device::name)).setter(Device.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> MANUFACTURER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("manufacturer").getter(Device.getter(Device::manufacturer)).setter(Device.setter(Builder::manufacturer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manufacturer").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("model").getter(Device.getter(Device::model)).setter(Device.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(Device.getter(Device::modelId)).setter(Device.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> FORM_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formFactor").getter(Device.getter(Device::formFactorAsString)).setter(Device.setter(Builder::formFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formFactor").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(Device.getter(Device::platformAsString)).setter(Device.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> OS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("os").getter(Device.getter(Device::os)).setter(Device.setter(Builder::os)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("os").build()}).build();
    private static final SdkField<CPU> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cpu").getter(Device.getter(Device::cpu)).setter(Device.setter(Builder::cpu)).constructor(CPU::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<Resolution> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resolution").getter(Device.getter(Device::resolution)).setter(Device.setter(Builder::resolution)).constructor(Resolution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()}).build();
    private static final SdkField<Long> HEAP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("heapSize").getter(Device.getter(Device::heapSize)).setter(Device.setter(Builder::heapSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heapSize").build()}).build();
    private static final SdkField<Long> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("memory").getter(Device.getter(Device::memory)).setter(Device.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(Device.getter(Device::image)).setter(Device.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> CARRIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("carrier").getter(Device.getter(Device::carrier)).setter(Device.setter(Builder::carrier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("carrier").build()}).build();
    private static final SdkField<String> RADIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("radio").getter(Device.getter(Device::radio)).setter(Device.setter(Builder::radio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("radio").build()}).build();
    private static final SdkField<Boolean> REMOTE_ACCESS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("remoteAccessEnabled").getter(Device.getter(Device::remoteAccessEnabled)).setter(Device.setter(Builder::remoteAccessEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessEnabled").build()}).build();
    private static final SdkField<Boolean> REMOTE_DEBUG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("remoteDebugEnabled").getter(Device.getter(Device::remoteDebugEnabled)).setter(Device.setter(Builder::remoteDebugEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteDebugEnabled").build()}).build();
    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetType").getter(Device.getter(Device::fleetType)).setter(Device.setter(Builder::fleetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetType").build()}).build();
    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetName").getter(Device.getter(Device::fleetName)).setter(Device.setter(Builder::fleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetName").build()}).build();
    private static final SdkField<List<DeviceInstance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instances").getter(Device.getter(Device::instances)).setter(Device.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availability").getter(Device.getter(Device::availabilityAsString)).setter(Device.setter(Builder::availability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availability").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, MANUFACTURER_FIELD, MODEL_FIELD, MODEL_ID_FIELD, FORM_FACTOR_FIELD, PLATFORM_FIELD, OS_FIELD, CPU_FIELD, RESOLUTION_FIELD, HEAP_SIZE_FIELD, MEMORY_FIELD, IMAGE_FIELD, CARRIER_FIELD, RADIO_FIELD, REMOTE_ACCESS_ENABLED_FIELD, REMOTE_DEBUG_ENABLED_FIELD, FLEET_TYPE_FIELD, FLEET_NAME_FIELD, INSTANCES_FIELD, AVAILABILITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String manufacturer;
    private final String model;
    private final String modelId;
    private final String formFactor;
    private final String platform;
    private final String os;
    private final CPU cpu;
    private final Resolution resolution;
    private final Long heapSize;
    private final Long memory;
    private final String image;
    private final String carrier;
    private final String radio;
    private final Boolean remoteAccessEnabled;
    private final Boolean remoteDebugEnabled;
    private final String fleetType;
    private final String fleetName;
    private final List<DeviceInstance> instances;
    private final String availability;

    private Device(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.model = builder.model;
        this.modelId = builder.modelId;
        this.formFactor = builder.formFactor;
        this.platform = builder.platform;
        this.os = builder.os;
        this.cpu = builder.cpu;
        this.resolution = builder.resolution;
        this.heapSize = builder.heapSize;
        this.memory = builder.memory;
        this.image = builder.image;
        this.carrier = builder.carrier;
        this.radio = builder.radio;
        this.remoteAccessEnabled = builder.remoteAccessEnabled;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.fleetType = builder.fleetType;
        this.fleetName = builder.fleetName;
        this.instances = builder.instances;
        this.availability = builder.availability;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String manufacturer() {
        return this.manufacturer;
    }

    public final String model() {
        return this.model;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final DeviceFormFactor formFactor() {
        return DeviceFormFactor.fromValue(this.formFactor);
    }

    public final String formFactorAsString() {
        return this.formFactor;
    }

    public final DevicePlatform platform() {
        return DevicePlatform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String os() {
        return this.os;
    }

    public final CPU cpu() {
        return this.cpu;
    }

    public final Resolution resolution() {
        return this.resolution;
    }

    public final Long heapSize() {
        return this.heapSize;
    }

    public final Long memory() {
        return this.memory;
    }

    public final String image() {
        return this.image;
    }

    public final String carrier() {
        return this.carrier;
    }

    public final String radio() {
        return this.radio;
    }

    public final Boolean remoteAccessEnabled() {
        return this.remoteAccessEnabled;
    }

    public final Boolean remoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    public final String fleetType() {
        return this.fleetType;
    }

    public final String fleetName() {
        return this.fleetName;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<DeviceInstance> instances() {
        return this.instances;
    }

    public final DeviceAvailability availability() {
        return DeviceAvailability.fromValue(this.availability);
    }

    public final String availabilityAsString() {
        return this.availability;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturer());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formFactorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.os());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.heapSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.carrier());
        hashCode = 31 * hashCode + Objects.hashCode(this.radio());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.manufacturer(), other.manufacturer()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.formFactorAsString(), other.formFactorAsString()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.os(), other.os()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.resolution(), other.resolution()) && Objects.equals(this.heapSize(), other.heapSize()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.carrier(), other.carrier()) && Objects.equals(this.radio(), other.radio()) && Objects.equals(this.remoteAccessEnabled(), other.remoteAccessEnabled()) && Objects.equals(this.remoteDebugEnabled(), other.remoteDebugEnabled()) && Objects.equals(this.fleetType(), other.fleetType()) && Objects.equals(this.fleetName(), other.fleetName()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.availabilityAsString(), other.availabilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Device").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Manufacturer", (Object)this.manufacturer()).add("Model", (Object)this.model()).add("ModelId", (Object)this.modelId()).add("FormFactor", (Object)this.formFactorAsString()).add("Platform", (Object)this.platformAsString()).add("Os", (Object)this.os()).add("Cpu", (Object)this.cpu()).add("Resolution", (Object)this.resolution()).add("HeapSize", (Object)this.heapSize()).add("Memory", (Object)this.memory()).add("Image", (Object)this.image()).add("Carrier", (Object)this.carrier()).add("Radio", (Object)this.radio()).add("RemoteAccessEnabled", (Object)this.remoteAccessEnabled()).add("RemoteDebugEnabled", (Object)this.remoteDebugEnabled()).add("FleetType", (Object)this.fleetType()).add("FleetName", (Object)this.fleetName()).add("Instances", this.hasInstances() ? this.instances() : null).add("Availability", (Object)this.availabilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "manufacturer": {
                return Optional.ofNullable(clazz.cast(this.manufacturer()));
            }
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "formFactor": {
                return Optional.ofNullable(clazz.cast(this.formFactorAsString()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "os": {
                return Optional.ofNullable(clazz.cast(this.os()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "resolution": {
                return Optional.ofNullable(clazz.cast(this.resolution()));
            }
            case "heapSize": {
                return Optional.ofNullable(clazz.cast(this.heapSize()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "carrier": {
                return Optional.ofNullable(clazz.cast(this.carrier()));
            }
            case "radio": {
                return Optional.ofNullable(clazz.cast(this.radio()));
            }
            case "remoteAccessEnabled": {
                return Optional.ofNullable(clazz.cast(this.remoteAccessEnabled()));
            }
            case "remoteDebugEnabled": {
                return Optional.ofNullable(clazz.cast(this.remoteDebugEnabled()));
            }
            case "fleetType": {
                return Optional.ofNullable(clazz.cast(this.fleetType()));
            }
            case "fleetName": {
                return Optional.ofNullable(clazz.cast(this.fleetName()));
            }
            case "instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "availability": {
                return Optional.ofNullable(clazz.cast(this.availabilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String manufacturer;
        private String model;
        private String modelId;
        private String formFactor;
        private String platform;
        private String os;
        private CPU cpu;
        private Resolution resolution;
        private Long heapSize;
        private Long memory;
        private String image;
        private String carrier;
        private String radio;
        private Boolean remoteAccessEnabled;
        private Boolean remoteDebugEnabled;
        private String fleetType;
        private String fleetName;
        private List<DeviceInstance> instances = DefaultSdkAutoConstructList.getInstance();
        private String availability;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            this.arn(model.arn);
            this.name(model.name);
            this.manufacturer(model.manufacturer);
            this.model(model.model);
            this.modelId(model.modelId);
            this.formFactor(model.formFactor);
            this.platform(model.platform);
            this.os(model.os);
            this.cpu(model.cpu);
            this.resolution(model.resolution);
            this.heapSize(model.heapSize);
            this.memory(model.memory);
            this.image(model.image);
            this.carrier(model.carrier);
            this.radio(model.radio);
            this.remoteAccessEnabled(model.remoteAccessEnabled);
            this.remoteDebugEnabled(model.remoteDebugEnabled);
            this.fleetType(model.fleetType);
            this.fleetName(model.fleetName);
            this.instances(model.instances);
            this.availability(model.availability);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getManufacturer() {
            return this.manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        public final String getModel() {
            return this.model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        public final String getModelId() {
            return this.modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getFormFactor() {
            return this.formFactor;
        }

        @Override
        public final Builder formFactor(String formFactor) {
            this.formFactor = formFactor;
            return this;
        }

        @Override
        public final Builder formFactor(DeviceFormFactor formFactor) {
            this.formFactor(formFactor == null ? null : formFactor.toString());
            return this;
        }

        public final void setFormFactor(String formFactor) {
            this.formFactor = formFactor;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getOs() {
            return this.os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final CPU.Builder getCpu() {
            return this.cpu != null ? this.cpu.toBuilder() : null;
        }

        @Override
        public final Builder cpu(CPU cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(CPU.BuilderImpl cpu) {
            this.cpu = cpu != null ? cpu.build() : null;
        }

        public final Resolution.Builder getResolution() {
            return this.resolution != null ? this.resolution.toBuilder() : null;
        }

        @Override
        public final Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(Resolution.BuilderImpl resolution) {
            this.resolution = resolution != null ? resolution.build() : null;
        }

        public final Long getHeapSize() {
            return this.heapSize;
        }

        @Override
        public final Builder heapSize(Long heapSize) {
            this.heapSize = heapSize;
            return this;
        }

        public final void setHeapSize(Long heapSize) {
            this.heapSize = heapSize;
        }

        public final Long getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getCarrier() {
            return this.carrier;
        }

        @Override
        public final Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public final void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        public final String getRadio() {
            return this.radio;
        }

        @Override
        public final Builder radio(String radio) {
            this.radio = radio;
            return this;
        }

        public final void setRadio(String radio) {
            this.radio = radio;
        }

        public final Boolean getRemoteAccessEnabled() {
            return this.remoteAccessEnabled;
        }

        @Override
        public final Builder remoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
            return this;
        }

        public final void setRemoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
        }

        public final Boolean getRemoteDebugEnabled() {
            return this.remoteDebugEnabled;
        }

        @Override
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        public final String getFleetType() {
            return this.fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final List<DeviceInstance.Builder> getInstances() {
            List<DeviceInstance.Builder> result = DeviceInstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instances(Collection<DeviceInstance> instances) {
            this.instances = DeviceInstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(DeviceInstance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<DeviceInstance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (DeviceInstance)((DeviceInstance.Builder)DeviceInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<DeviceInstance.BuilderImpl> instances) {
            this.instances = DeviceInstancesCopier.copyFromBuilder(instances);
        }

        public final String getAvailability() {
            return this.availability;
        }

        @Override
        public final Builder availability(String availability) {
            this.availability = availability;
            return this;
        }

        @Override
        public final Builder availability(DeviceAvailability availability) {
            this.availability(availability == null ? null : availability.toString());
            return this;
        }

        public final void setAvailability(String availability) {
            this.availability = availability;
        }

        public Device build() {
            return new Device(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Device> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder manufacturer(String var1);

        public Builder model(String var1);

        public Builder modelId(String var1);

        public Builder formFactor(String var1);

        public Builder formFactor(DeviceFormFactor var1);

        public Builder platform(String var1);

        public Builder platform(DevicePlatform var1);

        public Builder os(String var1);

        public Builder cpu(CPU var1);

        default public Builder cpu(Consumer<CPU.Builder> cpu) {
            return this.cpu((CPU)((CPU.Builder)CPU.builder().applyMutation(cpu)).build());
        }

        public Builder resolution(Resolution var1);

        default public Builder resolution(Consumer<Resolution.Builder> resolution) {
            return this.resolution((Resolution)((Resolution.Builder)Resolution.builder().applyMutation(resolution)).build());
        }

        public Builder heapSize(Long var1);

        public Builder memory(Long var1);

        public Builder image(String var1);

        public Builder carrier(String var1);

        public Builder radio(String var1);

        public Builder remoteAccessEnabled(Boolean var1);

        public Builder remoteDebugEnabled(Boolean var1);

        public Builder fleetType(String var1);

        public Builder fleetName(String var1);

        public Builder instances(Collection<DeviceInstance> var1);

        public Builder instances(DeviceInstance ... var1);

        public Builder instances(Consumer<DeviceInstance.Builder> ... var1);

        public Builder availability(String var1);

        public Builder availability(DeviceAvailability var1);
    }
}

