/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTestGridProjectRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<UpdateTestGridProjectRequest.Builder, UpdateTestGridProjectRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(UpdateTestGridProjectRequest::projectArn))
            .setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateTestGridProjectRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateTestGridProjectRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<TestGridVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<TestGridVpcConfig> builder(MarshallingType.SDK_POJO).memberName("vpcConfig")
            .getter(getter(UpdateTestGridProjectRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(TestGridVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, VPC_CONFIG_FIELD));

    private final String projectArn;

    private final String name;

    private final String description;

    private final TestGridVpcConfig vpcConfig;

    private UpdateTestGridProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.description = builder.description;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * ARN of the project to update.
     * </p>
     * 
     * @return ARN of the project to update.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * Human-readable name for the project.
     * </p>
     * 
     * @return Human-readable name for the project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Human-readable description for the project.
     * </p>
     * 
     * @return Human-readable description for the project.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The VPC security groups and subnets that are attached to a project.
     * </p>
     * 
     * @return The VPC security groups and subnets that are attached to a project.
     */
    public final TestGridVpcConfig vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestGridProjectRequest)) {
            return false;
        }
        UpdateTestGridProjectRequest other = (UpdateTestGridProjectRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTestGridProjectRequest").add("ProjectArn", projectArn()).add("Name", name())
                .add("Description", description()).add("VpcConfig", vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTestGridProjectRequest, T> g) {
        return obj -> g.apply((UpdateTestGridProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTestGridProjectRequest> {
        /**
         * <p>
         * ARN of the project to update.
         * </p>
         * 
         * @param projectArn
         *        ARN of the project to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * Human-readable name for the project.
         * </p>
         * 
         * @param name
         *        Human-readable name for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Human-readable description for the project.
         * </p>
         * 
         * @param description
         *        Human-readable description for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The VPC security groups and subnets that are attached to a project.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC security groups and subnets that are attached to a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(TestGridVpcConfig vpcConfig);

        /**
         * <p>
         * The VPC security groups and subnets that are attached to a project.
         * </p>
         * This is a convenience that creates an instance of the {@link TestGridVpcConfig.Builder} avoiding the need to
         * create one manually via {@link TestGridVpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TestGridVpcConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(TestGridVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link TestGridVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(TestGridVpcConfig)
         */
        default Builder vpcConfig(Consumer<TestGridVpcConfig.Builder> vpcConfig) {
            return vpcConfig(TestGridVpcConfig.builder().applyMutation(vpcConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String name;

        private String description;

        private TestGridVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTestGridProjectRequest model) {
            super(model);
            projectArn(model.projectArn);
            name(model.name);
            description(model.description);
            vpcConfig(model.vpcConfig);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final TestGridVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(TestGridVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(TestGridVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTestGridProjectRequest build() {
            return new UpdateTestGridProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
