/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpceConfigurationRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<CreateVpceConfigurationRequest.Builder, CreateVpceConfigurationRequest> {
    private static final SdkField<String> VPCE_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpceConfigurationName").getter(getter(CreateVpceConfigurationRequest::vpceConfigurationName))
            .setter(setter(Builder::vpceConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationName").build())
            .build();

    private static final SdkField<String> VPCE_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpceServiceName").getter(getter(CreateVpceConfigurationRequest::vpceServiceName))
            .setter(setter(Builder::vpceServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceServiceName").build()).build();

    private static final SdkField<String> SERVICE_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceDnsName").getter(getter(CreateVpceConfigurationRequest::serviceDnsName))
            .setter(setter(Builder::serviceDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDnsName").build()).build();

    private static final SdkField<String> VPCE_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("vpceConfigurationDescription")
            .getter(getter(CreateVpceConfigurationRequest::vpceConfigurationDescription))
            .setter(setter(Builder::vpceConfigurationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPCE_CONFIGURATION_NAME_FIELD,
            VPCE_SERVICE_NAME_FIELD, SERVICE_DNS_NAME_FIELD, VPCE_CONFIGURATION_DESCRIPTION_FIELD));

    private final String vpceConfigurationName;

    private final String vpceServiceName;

    private final String serviceDnsName;

    private final String vpceConfigurationDescription;

    private CreateVpceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.vpceConfigurationName = builder.vpceConfigurationName;
        this.vpceServiceName = builder.vpceServiceName;
        this.serviceDnsName = builder.serviceDnsName;
        this.vpceConfigurationDescription = builder.vpceConfigurationDescription;
    }

    /**
     * <p>
     * The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.
     * </p>
     * 
     * @return The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.
     */
    public final String vpceConfigurationName() {
        return vpceConfigurationName;
    }

    /**
     * <p>
     * The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.
     * </p>
     * 
     * @return The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.
     */
    public final String vpceServiceName() {
        return vpceServiceName;
    }

    /**
     * <p>
     * The DNS name of the service running in your VPC that you want Device Farm to test.
     * </p>
     * 
     * @return The DNS name of the service running in your VPC that you want Device Farm to test.
     */
    public final String serviceDnsName() {
        return serviceDnsName;
    }

    /**
     * <p>
     * An optional description that provides details about your VPC endpoint configuration.
     * </p>
     * 
     * @return An optional description that provides details about your VPC endpoint configuration.
     */
    public final String vpceConfigurationDescription() {
        return vpceConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(vpceServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfigurationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpceConfigurationRequest)) {
            return false;
        }
        CreateVpceConfigurationRequest other = (CreateVpceConfigurationRequest) obj;
        return Objects.equals(vpceConfigurationName(), other.vpceConfigurationName())
                && Objects.equals(vpceServiceName(), other.vpceServiceName())
                && Objects.equals(serviceDnsName(), other.serviceDnsName())
                && Objects.equals(vpceConfigurationDescription(), other.vpceConfigurationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpceConfigurationRequest").add("VpceConfigurationName", vpceConfigurationName())
                .add("VpceServiceName", vpceServiceName()).add("ServiceDnsName", serviceDnsName())
                .add("VpceConfigurationDescription", vpceConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpceConfigurationName":
            return Optional.ofNullable(clazz.cast(vpceConfigurationName()));
        case "vpceServiceName":
            return Optional.ofNullable(clazz.cast(vpceServiceName()));
        case "serviceDnsName":
            return Optional.ofNullable(clazz.cast(serviceDnsName()));
        case "vpceConfigurationDescription":
            return Optional.ofNullable(clazz.cast(vpceConfigurationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpceConfigurationRequest, T> g) {
        return obj -> g.apply((CreateVpceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpceConfigurationRequest> {
        /**
         * <p>
         * The friendly name you give to your VPC endpoint configuration, to manage your configurations more easily.
         * </p>
         * 
         * @param vpceConfigurationName
         *        The friendly name you give to your VPC endpoint configuration, to manage your configurations more
         *        easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationName(String vpceConfigurationName);

        /**
         * <p>
         * The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.
         * </p>
         * 
         * @param vpceServiceName
         *        The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceServiceName(String vpceServiceName);

        /**
         * <p>
         * The DNS name of the service running in your VPC that you want Device Farm to test.
         * </p>
         * 
         * @param serviceDnsName
         *        The DNS name of the service running in your VPC that you want Device Farm to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDnsName(String serviceDnsName);

        /**
         * <p>
         * An optional description that provides details about your VPC endpoint configuration.
         * </p>
         * 
         * @param vpceConfigurationDescription
         *        An optional description that provides details about your VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationDescription(String vpceConfigurationDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String vpceConfigurationName;

        private String vpceServiceName;

        private String serviceDnsName;

        private String vpceConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpceConfigurationRequest model) {
            super(model);
            vpceConfigurationName(model.vpceConfigurationName);
            vpceServiceName(model.vpceServiceName);
            serviceDnsName(model.serviceDnsName);
            vpceConfigurationDescription(model.vpceConfigurationDescription);
        }

        public final String getVpceConfigurationName() {
            return vpceConfigurationName;
        }

        public final void setVpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
        }

        @Override
        @Transient
        public final Builder vpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
            return this;
        }

        public final String getVpceServiceName() {
            return vpceServiceName;
        }

        public final void setVpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
        }

        @Override
        @Transient
        public final Builder vpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
            return this;
        }

        public final String getServiceDnsName() {
            return serviceDnsName;
        }

        public final void setServiceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
        }

        @Override
        @Transient
        public final Builder serviceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
            return this;
        }

        public final String getVpceConfigurationDescription() {
            return vpceConfigurationDescription;
        }

        public final void setVpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
        }

        @Override
        @Transient
        public final Builder vpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpceConfigurationRequest build() {
            return new CreateVpceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
