/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblem;

public class ListUniqueProblemsPublisher
implements SdkPublisher<ListUniqueProblemsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListUniqueProblemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUniqueProblemsPublisher(DeviceFarmAsyncClient client, ListUniqueProblemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUniqueProblemsPublisher(DeviceFarmAsyncClient client, ListUniqueProblemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUniqueProblemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUniqueProblemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Map.Entry<String, List<UniqueProblem>>> uniqueProblemsAsStrings() {
        Function<ListUniqueProblemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uniqueProblemsAsStrings() != null) {
                return response.uniqueProblemsAsStrings().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUniqueProblemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUniqueProblemsResponseFetcher
    implements AsyncPageFetcher<ListUniqueProblemsResponse> {
        private ListUniqueProblemsResponseFetcher() {
        }

        public boolean hasNextPage(ListUniqueProblemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUniqueProblemsResponse> nextPage(ListUniqueProblemsResponse previousPage) {
            if (previousPage == null) {
                return ListUniqueProblemsPublisher.this.client.listUniqueProblems(ListUniqueProblemsPublisher.this.firstRequest);
            }
            return ListUniqueProblemsPublisher.this.client.listUniqueProblems((ListUniqueProblemsRequest)((Object)ListUniqueProblemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

