/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for a remote access session, including billing method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRemoteAccessSessionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateRemoteAccessSessionConfiguration.Builder, CreateRemoteAccessSessionConfiguration> {
    private static final SdkField<String> BILLING_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingMethod").getter(getter(CreateRemoteAccessSessionConfiguration::billingMethodAsString))
            .setter(setter(Builder::billingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMethod").build()).build();

    private static final SdkField<List<String>> VPCE_CONFIGURATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpceConfigurationArns")
            .getter(getter(CreateRemoteAccessSessionConfiguration::vpceConfigurationArns))
            .setter(setter(Builder::vpceConfigurationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_METHOD_FIELD,
            VPCE_CONFIGURATION_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String billingMethod;

    private final List<String> vpceConfigurationArns;

    private CreateRemoteAccessSessionConfiguration(BuilderImpl builder) {
        this.billingMethod = builder.billingMethod;
        this.vpceConfigurationArns = builder.vpceConfigurationArns;
    }

    /**
     * <p>
     * The billing method for the remote access session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return The billing method for the remote access session.
     * @see BillingMethod
     */
    public final BillingMethod billingMethod() {
        return BillingMethod.fromValue(billingMethod);
    }

    /**
     * <p>
     * The billing method for the remote access session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return The billing method for the remote access session.
     * @see BillingMethod
     */
    public final String billingMethodAsString() {
        return billingMethod;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpceConfigurationArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpceConfigurationArns() {
        return vpceConfigurationArns != null && !(vpceConfigurationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of ARNs included in the VPC endpoint configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpceConfigurationArns} method.
     * </p>
     * 
     * @return An array of ARNs included in the VPC endpoint configuration.
     */
    public final List<String> vpceConfigurationArns() {
        return vpceConfigurationArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpceConfigurationArns() ? vpceConfigurationArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionConfiguration)) {
            return false;
        }
        CreateRemoteAccessSessionConfiguration other = (CreateRemoteAccessSessionConfiguration) obj;
        return Objects.equals(billingMethodAsString(), other.billingMethodAsString())
                && hasVpceConfigurationArns() == other.hasVpceConfigurationArns()
                && Objects.equals(vpceConfigurationArns(), other.vpceConfigurationArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRemoteAccessSessionConfiguration").add("BillingMethod", billingMethodAsString())
                .add("VpceConfigurationArns", hasVpceConfigurationArns() ? vpceConfigurationArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billingMethod":
            return Optional.ofNullable(clazz.cast(billingMethodAsString()));
        case "vpceConfigurationArns":
            return Optional.ofNullable(clazz.cast(vpceConfigurationArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRemoteAccessSessionConfiguration, T> g) {
        return obj -> g.apply((CreateRemoteAccessSessionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateRemoteAccessSessionConfiguration> {
        /**
         * <p>
         * The billing method for the remote access session.
         * </p>
         * 
         * @param billingMethod
         *        The billing method for the remote access session.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * The billing method for the remote access session.
         * </p>
         * 
         * @param billingMethod
         *        The billing method for the remote access session.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);

        /**
         * <p>
         * An array of ARNs included in the VPC endpoint configuration.
         * </p>
         * 
         * @param vpceConfigurationArns
         *        An array of ARNs included in the VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationArns(Collection<String> vpceConfigurationArns);

        /**
         * <p>
         * An array of ARNs included in the VPC endpoint configuration.
         * </p>
         * 
         * @param vpceConfigurationArns
         *        An array of ARNs included in the VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationArns(String... vpceConfigurationArns);
    }

    static final class BuilderImpl implements Builder {
        private String billingMethod;

        private List<String> vpceConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionConfiguration model) {
            billingMethod(model.billingMethod);
            vpceConfigurationArns(model.vpceConfigurationArns);
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        @Override
        @Transient
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod == null ? null : billingMethod.toString());
            return this;
        }

        public final Collection<String> getVpceConfigurationArns() {
            if (vpceConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return vpceConfigurationArns;
        }

        public final void setVpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
        }

        @Override
        @Transient
        public final Builder vpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpceConfigurationArns(String... vpceConfigurationArns) {
            vpceConfigurationArns(Arrays.asList(vpceConfigurationArns));
            return this;
        }

        @Override
        public CreateRemoteAccessSessionConfiguration build() {
            return new CreateRemoteAccessSessionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
