/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a device pool compatibility result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DevicePoolCompatibilityResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DevicePoolCompatibilityResult.Builder, DevicePoolCompatibilityResult> {
    private static final SdkField<Device> DEVICE_FIELD = SdkField.<Device> builder(MarshallingType.SDK_POJO).memberName("device")
            .getter(getter(DevicePoolCompatibilityResult::device)).setter(setter(Builder::device)).constructor(Device::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()).build();

    private static final SdkField<Boolean> COMPATIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("compatible").getter(getter(DevicePoolCompatibilityResult::compatible))
            .setter(setter(Builder::compatible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatible").build()).build();

    private static final SdkField<List<IncompatibilityMessage>> INCOMPATIBILITY_MESSAGES_FIELD = SdkField
            .<List<IncompatibilityMessage>> builder(MarshallingType.LIST)
            .memberName("incompatibilityMessages")
            .getter(getter(DevicePoolCompatibilityResult::incompatibilityMessages))
            .setter(setter(Builder::incompatibilityMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incompatibilityMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncompatibilityMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncompatibilityMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FIELD,
            COMPATIBLE_FIELD, INCOMPATIBILITY_MESSAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Device device;

    private final Boolean compatible;

    private final List<IncompatibilityMessage> incompatibilityMessages;

    private DevicePoolCompatibilityResult(BuilderImpl builder) {
        this.device = builder.device;
        this.compatible = builder.compatible;
        this.incompatibilityMessages = builder.incompatibilityMessages;
    }

    /**
     * <p>
     * The device (phone or tablet) to return information about.
     * </p>
     * 
     * @return The device (phone or tablet) to return information about.
     */
    public final Device device() {
        return device;
    }

    /**
     * <p>
     * Whether the result was compatible with the device pool.
     * </p>
     * 
     * @return Whether the result was compatible with the device pool.
     */
    public final Boolean compatible() {
        return compatible;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncompatibilityMessages property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIncompatibilityMessages() {
        return incompatibilityMessages != null && !(incompatibilityMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the compatibility.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncompatibilityMessages} method.
     * </p>
     * 
     * @return Information about the compatibility.
     */
    public final List<IncompatibilityMessage> incompatibilityMessages() {
        return incompatibilityMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(compatible());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncompatibilityMessages() ? incompatibilityMessages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevicePoolCompatibilityResult)) {
            return false;
        }
        DevicePoolCompatibilityResult other = (DevicePoolCompatibilityResult) obj;
        return Objects.equals(device(), other.device()) && Objects.equals(compatible(), other.compatible())
                && hasIncompatibilityMessages() == other.hasIncompatibilityMessages()
                && Objects.equals(incompatibilityMessages(), other.incompatibilityMessages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DevicePoolCompatibilityResult").add("Device", device()).add("Compatible", compatible())
                .add("IncompatibilityMessages", hasIncompatibilityMessages() ? incompatibilityMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "device":
            return Optional.ofNullable(clazz.cast(device()));
        case "compatible":
            return Optional.ofNullable(clazz.cast(compatible()));
        case "incompatibilityMessages":
            return Optional.ofNullable(clazz.cast(incompatibilityMessages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DevicePoolCompatibilityResult, T> g) {
        return obj -> g.apply((DevicePoolCompatibilityResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DevicePoolCompatibilityResult> {
        /**
         * <p>
         * The device (phone or tablet) to return information about.
         * </p>
         * 
         * @param device
         *        The device (phone or tablet) to return information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * The device (phone or tablet) to return information about.
         * </p>
         * This is a convenience that creates an instance of the {@link Device.Builder} avoiding the need to create one
         * manually via {@link Device#builder()}.
         *
         * When the {@link Consumer} completes, {@link Device.Builder#build()} is called immediately and its result is
         * passed to {@link #device(Device)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(Device)
         */
        default Builder device(Consumer<Device.Builder> device) {
            return device(Device.builder().applyMutation(device).build());
        }

        /**
         * <p>
         * Whether the result was compatible with the device pool.
         * </p>
         * 
         * @param compatible
         *        Whether the result was compatible with the device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatible(Boolean compatible);

        /**
         * <p>
         * Information about the compatibility.
         * </p>
         * 
         * @param incompatibilityMessages
         *        Information about the compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages);

        /**
         * <p>
         * Information about the compatibility.
         * </p>
         * 
         * @param incompatibilityMessages
         *        Information about the compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibilityMessages(IncompatibilityMessage... incompatibilityMessages);

        /**
         * <p>
         * Information about the compatibility.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IncompatibilityMessage>.Builder} avoiding
         * the need to create one manually via {@link List<IncompatibilityMessage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IncompatibilityMessage>.Builder#build()} is called
         * immediately and its result is passed to {@link #incompatibilityMessages(List<IncompatibilityMessage>)}.
         * 
         * @param incompatibilityMessages
         *        a consumer that will call methods on {@link List<IncompatibilityMessage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incompatibilityMessages(List<IncompatibilityMessage>)
         */
        Builder incompatibilityMessages(Consumer<IncompatibilityMessage.Builder>... incompatibilityMessages);
    }

    static final class BuilderImpl implements Builder {
        private Device device;

        private Boolean compatible;

        private List<IncompatibilityMessage> incompatibilityMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DevicePoolCompatibilityResult model) {
            device(model.device);
            compatible(model.compatible);
            incompatibilityMessages(model.incompatibilityMessages);
        }

        public final Device.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        @Override
        @Transient
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final Boolean getCompatible() {
            return compatible;
        }

        public final void setCompatible(Boolean compatible) {
            this.compatible = compatible;
        }

        @Override
        @Transient
        public final Builder compatible(Boolean compatible) {
            this.compatible = compatible;
            return this;
        }

        public final List<IncompatibilityMessage.Builder> getIncompatibilityMessages() {
            List<IncompatibilityMessage.Builder> result = IncompatibilityMessagesCopier
                    .copyToBuilder(this.incompatibilityMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncompatibilityMessages(Collection<IncompatibilityMessage.BuilderImpl> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copyFromBuilder(incompatibilityMessages);
        }

        @Override
        @Transient
        public final Builder incompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copy(incompatibilityMessages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder incompatibilityMessages(IncompatibilityMessage... incompatibilityMessages) {
            incompatibilityMessages(Arrays.asList(incompatibilityMessages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder incompatibilityMessages(Consumer<IncompatibilityMessage.Builder>... incompatibilityMessages) {
            incompatibilityMessages(Stream.of(incompatibilityMessages)
                    .map(c -> IncompatibilityMessage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DevicePoolCompatibilityResult build() {
            return new DevicePoolCompatibilityResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
