/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestGridSessionsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListTestGridSessionsResponse.Builder, ListTestGridSessionsResponse> {
    private static final SdkField<List<TestGridSession>> TEST_GRID_SESSIONS_FIELD = SdkField
            .<List<TestGridSession>> builder(MarshallingType.LIST)
            .memberName("testGridSessions")
            .getter(getter(ListTestGridSessionsResponse::testGridSessions))
            .setter(setter(Builder::testGridSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testGridSessions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestGridSession> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestGridSession::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestGridSessionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_GRID_SESSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TestGridSession> testGridSessions;

    private final String nextToken;

    private ListTestGridSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.testGridSessions = builder.testGridSessions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestGridSessions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTestGridSessions() {
        return testGridSessions != null && !(testGridSessions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestGridSessions} method.
     * </p>
     * 
     * @return The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>.
     */
    public final List<TestGridSession> testGridSessions() {
        return testGridSessions;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTestGridSessions() ? testGridSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridSessionsResponse)) {
            return false;
        }
        ListTestGridSessionsResponse other = (ListTestGridSessionsResponse) obj;
        return hasTestGridSessions() == other.hasTestGridSessions()
                && Objects.equals(testGridSessions(), other.testGridSessions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestGridSessionsResponse")
                .add("TestGridSessions", hasTestGridSessions() ? testGridSessions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testGridSessions":
            return Optional.ofNullable(clazz.cast(testGridSessions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridSessionsResponse, T> g) {
        return obj -> g.apply((ListTestGridSessionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTestGridSessionsResponse> {
        /**
         * <p>
         * The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>.
         * </p>
         * 
         * @param testGridSessions
         *        The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testGridSessions(Collection<TestGridSession> testGridSessions);

        /**
         * <p>
         * The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>.
         * </p>
         * 
         * @param testGridSessions
         *        The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testGridSessions(TestGridSession... testGridSessions);

        /**
         * <p>
         * The sessions that match the criteria in a <a>ListTestGridSessionsRequest</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TestGridSession>.Builder} avoiding the need
         * to create one manually via {@link List<TestGridSession>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TestGridSession>.Builder#build()} is called immediately and
         * its result is passed to {@link #testGridSessions(List<TestGridSession>)}.
         * 
         * @param testGridSessions
         *        a consumer that will call methods on {@link List<TestGridSession>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testGridSessions(List<TestGridSession>)
         */
        Builder testGridSessions(Consumer<TestGridSession.Builder>... testGridSessions);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<TestGridSession> testGridSessions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridSessionsResponse model) {
            super(model);
            testGridSessions(model.testGridSessions);
            nextToken(model.nextToken);
        }

        public final List<TestGridSession.Builder> getTestGridSessions() {
            List<TestGridSession.Builder> result = TestGridSessionsCopier.copyToBuilder(this.testGridSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestGridSessions(Collection<TestGridSession.BuilderImpl> testGridSessions) {
            this.testGridSessions = TestGridSessionsCopier.copyFromBuilder(testGridSessions);
        }

        @Override
        @Transient
        public final Builder testGridSessions(Collection<TestGridSession> testGridSessions) {
            this.testGridSessions = TestGridSessionsCopier.copy(testGridSessions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder testGridSessions(TestGridSession... testGridSessions) {
            testGridSessions(Arrays.asList(testGridSessions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder testGridSessions(Consumer<TestGridSession.Builder>... testGridSessions) {
            testGridSessions(Stream.of(testGridSessions).map(c -> TestGridSession.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestGridSessionsResponse build() {
            return new ListTestGridSessionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
