/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list unique problems request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUniqueProblemsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListUniqueProblemsResponse.Builder, ListUniqueProblemsResponse> {
    private static final SdkField<Map<String, List<UniqueProblem>>> UNIQUE_PROBLEMS_FIELD = SdkField
            .<Map<String, List<UniqueProblem>>> builder(MarshallingType.MAP)
            .memberName("uniqueProblems")
            .getter(getter(ListUniqueProblemsResponse::uniqueProblemsAsStrings))
            .setter(setter(Builder::uniqueProblemsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueProblems").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<UniqueProblem>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<UniqueProblem> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(UniqueProblem::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListUniqueProblemsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIQUE_PROBLEMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final Map<String, List<UniqueProblem>> uniqueProblems;

    private final String nextToken;

    private ListUniqueProblemsResponse(BuilderImpl builder) {
        super(builder);
        this.uniqueProblems = builder.uniqueProblems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the unique problems.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUniqueProblems} method.
     * </p>
     * 
     * @return Information about the unique problems.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED
     *         </p>
     *         </li>
     */
    public final Map<ExecutionResult, List<UniqueProblem>> uniqueProblems() {
        return UniqueProblemsByExecutionResultMapCopier.copyStringToEnum(uniqueProblems);
    }

    /**
     * For responses, this returns true if the service returned a value for the UniqueProblems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUniqueProblems() {
        return uniqueProblems != null && !(uniqueProblems instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information about the unique problems.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUniqueProblems} method.
     * </p>
     * 
     * @return Information about the unique problems.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED
     *         </p>
     *         </li>
     */
    public final Map<String, List<UniqueProblem>> uniqueProblemsAsStrings() {
        return uniqueProblems;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned. It
     * can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned. It can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUniqueProblems() ? uniqueProblemsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUniqueProblemsResponse)) {
            return false;
        }
        ListUniqueProblemsResponse other = (ListUniqueProblemsResponse) obj;
        return hasUniqueProblems() == other.hasUniqueProblems()
                && Objects.equals(uniqueProblemsAsStrings(), other.uniqueProblemsAsStrings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUniqueProblemsResponse")
                .add("UniqueProblems", hasUniqueProblems() ? uniqueProblemsAsStrings() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uniqueProblems":
            return Optional.ofNullable(clazz.cast(uniqueProblemsAsStrings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUniqueProblemsResponse, T> g) {
        return obj -> g.apply((ListUniqueProblemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUniqueProblemsResponse> {
        /**
         * <p>
         * Information about the unique problems.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED
         * </p>
         * </li>
         * </ul>
         * 
         * @param uniqueProblems
         *        Information about the unique problems.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueProblemsWithStrings(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems);

        /**
         * <p>
         * Information about the unique problems.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED
         * </p>
         * </li>
         * </ul>
         * 
         * @param uniqueProblems
         *        Information about the unique problems.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueProblems(Map<ExecutionResult, ? extends Collection<UniqueProblem>> uniqueProblems);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned.
         * It can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned. It can be used in a subsequent call to this operation to return the next set of items in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Map<String, List<UniqueProblem>> uniqueProblems = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUniqueProblemsResponse model) {
            super(model);
            uniqueProblemsWithStrings(model.uniqueProblems);
            nextToken(model.nextToken);
        }

        public final Map<String, List<UniqueProblem.Builder>> getUniqueProblems() {
            Map<String, List<UniqueProblem.Builder>> result = UniqueProblemsByExecutionResultMapCopier
                    .copyToBuilder(this.uniqueProblems);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUniqueProblems(Map<String, ? extends Collection<UniqueProblem.BuilderImpl>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copyFromBuilder(uniqueProblems);
        }

        @Override
        @Transient
        public final Builder uniqueProblemsWithStrings(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copy(uniqueProblems);
            return this;
        }

        @Override
        @Transient
        public final Builder uniqueProblems(Map<ExecutionResult, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copyEnumToString(uniqueProblems);
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUniqueProblemsResponse build() {
            return new ListUniqueProblemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
