/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a device type that an app is tested against.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Device implements SdkPojo, Serializable, ToCopyableBuilder<Device.Builder, Device> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Device::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Device::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> MANUFACTURER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("manufacturer").getter(getter(Device::manufacturer)).setter(setter(Builder::manufacturer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manufacturer").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("model")
            .getter(getter(Device::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(Device::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> FORM_FACTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formFactor").getter(getter(Device::formFactorAsString)).setter(setter(Builder::formFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formFactor").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(Device::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> OS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("os")
            .getter(getter(Device::os)).setter(setter(Builder::os))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("os").build()).build();

    private static final SdkField<CPU> CPU_FIELD = SdkField.<CPU> builder(MarshallingType.SDK_POJO).memberName("cpu")
            .getter(getter(Device::cpu)).setter(setter(Builder::cpu)).constructor(CPU::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<Resolution> RESOLUTION_FIELD = SdkField.<Resolution> builder(MarshallingType.SDK_POJO)
            .memberName("resolution").getter(getter(Device::resolution)).setter(setter(Builder::resolution))
            .constructor(Resolution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()).build();

    private static final SdkField<Long> HEAP_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("heapSize")
            .getter(getter(Device::heapSize)).setter(setter(Builder::heapSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heapSize").build()).build();

    private static final SdkField<Long> MEMORY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("memory")
            .getter(getter(Device::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("image")
            .getter(getter(Device::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<String> CARRIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("carrier")
            .getter(getter(Device::carrier)).setter(setter(Builder::carrier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("carrier").build()).build();

    private static final SdkField<String> RADIO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("radio")
            .getter(getter(Device::radio)).setter(setter(Builder::radio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("radio").build()).build();

    private static final SdkField<Boolean> REMOTE_ACCESS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("remoteAccessEnabled").getter(getter(Device::remoteAccessEnabled))
            .setter(setter(Builder::remoteAccessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessEnabled").build())
            .build();

    private static final SdkField<Boolean> REMOTE_DEBUG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("remoteDebugEnabled").getter(getter(Device::remoteDebugEnabled))
            .setter(setter(Builder::remoteDebugEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteDebugEnabled").build())
            .build();

    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetType").getter(getter(Device::fleetType)).setter(setter(Builder::fleetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetType").build()).build();

    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetName").getter(getter(Device::fleetName)).setter(setter(Builder::fleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetName").build()).build();

    private static final SdkField<List<DeviceInstance>> INSTANCES_FIELD = SdkField
            .<List<DeviceInstance>> builder(MarshallingType.LIST)
            .memberName("instances")
            .getter(getter(Device::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availability").getter(getter(Device::availabilityAsString)).setter(setter(Builder::availability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availability").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            MANUFACTURER_FIELD, MODEL_FIELD, MODEL_ID_FIELD, FORM_FACTOR_FIELD, PLATFORM_FIELD, OS_FIELD, CPU_FIELD,
            RESOLUTION_FIELD, HEAP_SIZE_FIELD, MEMORY_FIELD, IMAGE_FIELD, CARRIER_FIELD, RADIO_FIELD,
            REMOTE_ACCESS_ENABLED_FIELD, REMOTE_DEBUG_ENABLED_FIELD, FLEET_TYPE_FIELD, FLEET_NAME_FIELD, INSTANCES_FIELD,
            AVAILABILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String manufacturer;

    private final String model;

    private final String modelId;

    private final String formFactor;

    private final String platform;

    private final String os;

    private final CPU cpu;

    private final Resolution resolution;

    private final Long heapSize;

    private final Long memory;

    private final String image;

    private final String carrier;

    private final String radio;

    private final Boolean remoteAccessEnabled;

    private final Boolean remoteDebugEnabled;

    private final String fleetType;

    private final String fleetName;

    private final List<DeviceInstance> instances;

    private final String availability;

    private Device(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.model = builder.model;
        this.modelId = builder.modelId;
        this.formFactor = builder.formFactor;
        this.platform = builder.platform;
        this.os = builder.os;
        this.cpu = builder.cpu;
        this.resolution = builder.resolution;
        this.heapSize = builder.heapSize;
        this.memory = builder.memory;
        this.image = builder.image;
        this.carrier = builder.carrier;
        this.radio = builder.radio;
        this.remoteAccessEnabled = builder.remoteAccessEnabled;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.fleetType = builder.fleetType;
        this.fleetName = builder.fleetName;
        this.instances = builder.instances;
        this.availability = builder.availability;
    }

    /**
     * <p>
     * The device's ARN.
     * </p>
     * 
     * @return The device's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The device's display name.
     * </p>
     * 
     * @return The device's display name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The device's manufacturer name.
     * </p>
     * 
     * @return The device's manufacturer name.
     */
    public final String manufacturer() {
        return manufacturer;
    }

    /**
     * <p>
     * The device's model name.
     * </p>
     * 
     * @return The device's model name.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The device's model ID.
     * </p>
     * 
     * @return The device's model ID.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The device's form factor.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PHONE
     * </p>
     * </li>
     * <li>
     * <p>
     * TABLET
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formFactor} will
     * return {@link DeviceFormFactor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formFactorAsString}.
     * </p>
     * 
     * @return The device's form factor.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PHONE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TABLET
     *         </p>
     *         </li>
     * @see DeviceFormFactor
     */
    public final DeviceFormFactor formFactor() {
        return DeviceFormFactor.fromValue(formFactor);
    }

    /**
     * <p>
     * The device's form factor.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PHONE
     * </p>
     * </li>
     * <li>
     * <p>
     * TABLET
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formFactor} will
     * return {@link DeviceFormFactor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formFactorAsString}.
     * </p>
     * 
     * @return The device's form factor.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PHONE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TABLET
     *         </p>
     *         </li>
     * @see DeviceFormFactor
     */
    public final String formFactorAsString() {
        return formFactor;
    }

    /**
     * <p>
     * The device's platform.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link DevicePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The device's platform.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS
     *         </p>
     *         </li>
     * @see DevicePlatform
     */
    public final DevicePlatform platform() {
        return DevicePlatform.fromValue(platform);
    }

    /**
     * <p>
     * The device's platform.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link DevicePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The device's platform.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS
     *         </p>
     *         </li>
     * @see DevicePlatform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The device's operating system type.
     * </p>
     * 
     * @return The device's operating system type.
     */
    public final String os() {
        return os;
    }

    /**
     * <p>
     * Information about the device's CPU.
     * </p>
     * 
     * @return Information about the device's CPU.
     */
    public final CPU cpu() {
        return cpu;
    }

    /**
     * <p>
     * The resolution of the device.
     * </p>
     * 
     * @return The resolution of the device.
     */
    public final Resolution resolution() {
        return resolution;
    }

    /**
     * <p>
     * The device's heap size, expressed in bytes.
     * </p>
     * 
     * @return The device's heap size, expressed in bytes.
     */
    public final Long heapSize() {
        return heapSize;
    }

    /**
     * <p>
     * The device's total memory size, expressed in bytes.
     * </p>
     * 
     * @return The device's total memory size, expressed in bytes.
     */
    public final Long memory() {
        return memory;
    }

    /**
     * <p>
     * The device's image name.
     * </p>
     * 
     * @return The device's image name.
     */
    public final String image() {
        return image;
    }

    /**
     * <p>
     * The device's carrier.
     * </p>
     * 
     * @return The device's carrier.
     */
    public final String carrier() {
        return carrier;
    }

    /**
     * <p>
     * The device's radio.
     * </p>
     * 
     * @return The device's radio.
     */
    public final String radio() {
        return radio;
    }

    /**
     * <p>
     * Specifies whether remote access has been enabled for the specified device.
     * </p>
     * 
     * @return Specifies whether remote access has been enabled for the specified device.
     */
    public final Boolean remoteAccessEnabled() {
        return remoteAccessEnabled;
    }

    /**
     * <p>
     * This flag is set to <code>true</code> if remote debugging is enabled for the device.
     * </p>
     * <p>
     * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
     * supported</a>.
     * </p>
     * 
     * @return This flag is set to <code>true</code> if remote debugging is enabled for the device.</p>
     *         <p>
     *         Remote debugging is <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.
     */
    public final Boolean remoteDebugEnabled() {
        return remoteDebugEnabled;
    }

    /**
     * <p>
     * The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.
     * </p>
     * 
     * @return The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.
     */
    public final String fleetType() {
        return fleetType;
    }

    /**
     * <p>
     * The name of the fleet to which this device belongs.
     * </p>
     * 
     * @return The name of the fleet to which this device belongs.
     */
    public final String fleetName() {
        return fleetName;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instances that belong to this device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instances that belong to this device.
     */
    public final List<DeviceInstance> instances() {
        return instances;
    }

    /**
     * <p>
     * Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a> and
     * GetDevice API methods.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availability} will
     * return {@link DeviceAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #availabilityAsString}.
     * </p>
     * 
     * @return Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a>
     *         and GetDevice API methods.
     * @see DeviceAvailability
     */
    public final DeviceAvailability availability() {
        return DeviceAvailability.fromValue(availability);
    }

    /**
     * <p>
     * Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a> and
     * GetDevice API methods.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availability} will
     * return {@link DeviceAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #availabilityAsString}.
     * </p>
     * 
     * @return Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a>
     *         and GetDevice API methods.
     * @see DeviceAvailability
     */
    public final String availabilityAsString() {
        return availability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturer());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(formFactorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(os());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(resolution());
        hashCode = 31 * hashCode + Objects.hashCode(heapSize());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(carrier());
        hashCode = 31 * hashCode + Objects.hashCode(radio());
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(fleetType());
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(manufacturer(), other.manufacturer()) && Objects.equals(model(), other.model())
                && Objects.equals(modelId(), other.modelId()) && Objects.equals(formFactorAsString(), other.formFactorAsString())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(os(), other.os())
                && Objects.equals(cpu(), other.cpu()) && Objects.equals(resolution(), other.resolution())
                && Objects.equals(heapSize(), other.heapSize()) && Objects.equals(memory(), other.memory())
                && Objects.equals(image(), other.image()) && Objects.equals(carrier(), other.carrier())
                && Objects.equals(radio(), other.radio()) && Objects.equals(remoteAccessEnabled(), other.remoteAccessEnabled())
                && Objects.equals(remoteDebugEnabled(), other.remoteDebugEnabled())
                && Objects.equals(fleetType(), other.fleetType()) && Objects.equals(fleetName(), other.fleetName())
                && hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && Objects.equals(availabilityAsString(), other.availabilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Device").add("Arn", arn()).add("Name", name()).add("Manufacturer", manufacturer())
                .add("Model", model()).add("ModelId", modelId()).add("FormFactor", formFactorAsString())
                .add("Platform", platformAsString()).add("Os", os()).add("Cpu", cpu()).add("Resolution", resolution())
                .add("HeapSize", heapSize()).add("Memory", memory()).add("Image", image()).add("Carrier", carrier())
                .add("Radio", radio()).add("RemoteAccessEnabled", remoteAccessEnabled())
                .add("RemoteDebugEnabled", remoteDebugEnabled()).add("FleetType", fleetType()).add("FleetName", fleetName())
                .add("Instances", hasInstances() ? instances() : null).add("Availability", availabilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "manufacturer":
            return Optional.ofNullable(clazz.cast(manufacturer()));
        case "model":
            return Optional.ofNullable(clazz.cast(model()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "formFactor":
            return Optional.ofNullable(clazz.cast(formFactorAsString()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "os":
            return Optional.ofNullable(clazz.cast(os()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "resolution":
            return Optional.ofNullable(clazz.cast(resolution()));
        case "heapSize":
            return Optional.ofNullable(clazz.cast(heapSize()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "carrier":
            return Optional.ofNullable(clazz.cast(carrier()));
        case "radio":
            return Optional.ofNullable(clazz.cast(radio()));
        case "remoteAccessEnabled":
            return Optional.ofNullable(clazz.cast(remoteAccessEnabled()));
        case "remoteDebugEnabled":
            return Optional.ofNullable(clazz.cast(remoteDebugEnabled()));
        case "fleetType":
            return Optional.ofNullable(clazz.cast(fleetType()));
        case "fleetName":
            return Optional.ofNullable(clazz.cast(fleetName()));
        case "instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "availability":
            return Optional.ofNullable(clazz.cast(availabilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The device's ARN.
         * </p>
         * 
         * @param arn
         *        The device's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The device's display name.
         * </p>
         * 
         * @param name
         *        The device's display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device's manufacturer name.
         * </p>
         * 
         * @param manufacturer
         *        The device's manufacturer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturer(String manufacturer);

        /**
         * <p>
         * The device's model name.
         * </p>
         * 
         * @param model
         *        The device's model name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The device's model ID.
         * </p>
         * 
         * @param modelId
         *        The device's model ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The device's form factor.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE
         * </p>
         * </li>
         * <li>
         * <p>
         * TABLET
         * </p>
         * </li>
         * </ul>
         * 
         * @param formFactor
         *        The device's form factor.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TABLET
         *        </p>
         *        </li>
         * @see DeviceFormFactor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceFormFactor
         */
        Builder formFactor(String formFactor);

        /**
         * <p>
         * The device's form factor.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE
         * </p>
         * </li>
         * <li>
         * <p>
         * TABLET
         * </p>
         * </li>
         * </ul>
         * 
         * @param formFactor
         *        The device's form factor.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TABLET
         *        </p>
         *        </li>
         * @see DeviceFormFactor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceFormFactor
         */
        Builder formFactor(DeviceFormFactor formFactor);

        /**
         * <p>
         * The device's platform.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS
         * </p>
         * </li>
         * </ul>
         * 
         * @param platform
         *        The device's platform.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS
         *        </p>
         *        </li>
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The device's platform.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS
         * </p>
         * </li>
         * </ul>
         * 
         * @param platform
         *        The device's platform.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS
         *        </p>
         *        </li>
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(DevicePlatform platform);

        /**
         * <p>
         * The device's operating system type.
         * </p>
         * 
         * @param os
         *        The device's operating system type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder os(String os);

        /**
         * <p>
         * Information about the device's CPU.
         * </p>
         * 
         * @param cpu
         *        Information about the device's CPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(CPU cpu);

        /**
         * <p>
         * Information about the device's CPU.
         * </p>
         * This is a convenience that creates an instance of the {@link CPU.Builder} avoiding the need to create one
         * manually via {@link CPU#builder()}.
         *
         * When the {@link Consumer} completes, {@link CPU.Builder#build()} is called immediately and its result is
         * passed to {@link #cpu(CPU)}.
         * 
         * @param cpu
         *        a consumer that will call methods on {@link CPU.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpu(CPU)
         */
        default Builder cpu(Consumer<CPU.Builder> cpu) {
            return cpu(CPU.builder().applyMutation(cpu).build());
        }

        /**
         * <p>
         * The resolution of the device.
         * </p>
         * 
         * @param resolution
         *        The resolution of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolution(Resolution resolution);

        /**
         * <p>
         * The resolution of the device.
         * </p>
         * This is a convenience that creates an instance of the {@link Resolution.Builder} avoiding the need to create
         * one manually via {@link Resolution#builder()}.
         *
         * When the {@link Consumer} completes, {@link Resolution.Builder#build()} is called immediately and its result
         * is passed to {@link #resolution(Resolution)}.
         * 
         * @param resolution
         *        a consumer that will call methods on {@link Resolution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolution(Resolution)
         */
        default Builder resolution(Consumer<Resolution.Builder> resolution) {
            return resolution(Resolution.builder().applyMutation(resolution).build());
        }

        /**
         * <p>
         * The device's heap size, expressed in bytes.
         * </p>
         * 
         * @param heapSize
         *        The device's heap size, expressed in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heapSize(Long heapSize);

        /**
         * <p>
         * The device's total memory size, expressed in bytes.
         * </p>
         * 
         * @param memory
         *        The device's total memory size, expressed in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Long memory);

        /**
         * <p>
         * The device's image name.
         * </p>
         * 
         * @param image
         *        The device's image name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The device's carrier.
         * </p>
         * 
         * @param carrier
         *        The device's carrier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrier(String carrier);

        /**
         * <p>
         * The device's radio.
         * </p>
         * 
         * @param radio
         *        The device's radio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radio(String radio);

        /**
         * <p>
         * Specifies whether remote access has been enabled for the specified device.
         * </p>
         * 
         * @param remoteAccessEnabled
         *        Specifies whether remote access has been enabled for the specified device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessEnabled(Boolean remoteAccessEnabled);

        /**
         * <p>
         * This flag is set to <code>true</code> if remote debugging is enabled for the device.
         * </p>
         * <p>
         * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
         * longer supported</a>.
         * </p>
         * 
         * @param remoteDebugEnabled
         *        This flag is set to <code>true</code> if remote debugging is enabled for the device.</p>
         *        <p>
         *        Remote debugging is <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
         *        supported</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDebugEnabled(Boolean remoteDebugEnabled);

        /**
         * <p>
         * The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.
         * </p>
         * 
         * @param fleetType
         *        The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetType(String fleetType);

        /**
         * <p>
         * The name of the fleet to which this device belongs.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet to which this device belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The instances that belong to this device.
         * </p>
         * 
         * @param instances
         *        The instances that belong to this device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<DeviceInstance> instances);

        /**
         * <p>
         * The instances that belong to this device.
         * </p>
         * 
         * @param instances
         *        The instances that belong to this device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(DeviceInstance... instances);

        /**
         * <p>
         * The instances that belong to this device.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceInstance>.Builder} avoiding the need
         * to create one manually via {@link List<DeviceInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceInstance>.Builder#build()} is called immediately and
         * its result is passed to {@link #instances(List<DeviceInstance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<DeviceInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<DeviceInstance>)
         */
        Builder instances(Consumer<DeviceInstance.Builder>... instances);

        /**
         * <p>
         * Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a> and
         * GetDevice API methods.
         * </p>
         * 
         * @param availability
         *        Indicates how likely a device is available for a test run. Currently available in the
         *        <a>ListDevices</a> and GetDevice API methods.
         * @see DeviceAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAvailability
         */
        Builder availability(String availability);

        /**
         * <p>
         * Indicates how likely a device is available for a test run. Currently available in the <a>ListDevices</a> and
         * GetDevice API methods.
         * </p>
         * 
         * @param availability
         *        Indicates how likely a device is available for a test run. Currently available in the
         *        <a>ListDevices</a> and GetDevice API methods.
         * @see DeviceAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAvailability
         */
        Builder availability(DeviceAvailability availability);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String manufacturer;

        private String model;

        private String modelId;

        private String formFactor;

        private String platform;

        private String os;

        private CPU cpu;

        private Resolution resolution;

        private Long heapSize;

        private Long memory;

        private String image;

        private String carrier;

        private String radio;

        private Boolean remoteAccessEnabled;

        private Boolean remoteDebugEnabled;

        private String fleetType;

        private String fleetName;

        private List<DeviceInstance> instances = DefaultSdkAutoConstructList.getInstance();

        private String availability;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            arn(model.arn);
            name(model.name);
            manufacturer(model.manufacturer);
            model(model.model);
            modelId(model.modelId);
            formFactor(model.formFactor);
            platform(model.platform);
            os(model.os);
            cpu(model.cpu);
            resolution(model.resolution);
            heapSize(model.heapSize);
            memory(model.memory);
            image(model.image);
            carrier(model.carrier);
            radio(model.radio);
            remoteAccessEnabled(model.remoteAccessEnabled);
            remoteDebugEnabled(model.remoteDebugEnabled);
            fleetType(model.fleetType);
            fleetName(model.fleetName);
            instances(model.instances);
            availability(model.availability);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getManufacturer() {
            return manufacturer;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        @Override
        @Transient
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        @Transient
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        @Transient
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getFormFactor() {
            return formFactor;
        }

        public final void setFormFactor(String formFactor) {
            this.formFactor = formFactor;
        }

        @Override
        @Transient
        public final Builder formFactor(String formFactor) {
            this.formFactor = formFactor;
            return this;
        }

        @Override
        @Transient
        public final Builder formFactor(DeviceFormFactor formFactor) {
            this.formFactor(formFactor == null ? null : formFactor.toString());
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        @Transient
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOs() {
            return os;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        @Override
        @Transient
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final CPU.Builder getCpu() {
            return cpu != null ? cpu.toBuilder() : null;
        }

        public final void setCpu(CPU.BuilderImpl cpu) {
            this.cpu = cpu != null ? cpu.build() : null;
        }

        @Override
        @Transient
        public final Builder cpu(CPU cpu) {
            this.cpu = cpu;
            return this;
        }

        public final Resolution.Builder getResolution() {
            return resolution != null ? resolution.toBuilder() : null;
        }

        public final void setResolution(Resolution.BuilderImpl resolution) {
            this.resolution = resolution != null ? resolution.build() : null;
        }

        @Override
        @Transient
        public final Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public final Long getHeapSize() {
            return heapSize;
        }

        public final void setHeapSize(Long heapSize) {
            this.heapSize = heapSize;
        }

        @Override
        @Transient
        public final Builder heapSize(Long heapSize) {
            this.heapSize = heapSize;
            return this;
        }

        public final Long getMemory() {
            return memory;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        @Override
        @Transient
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final String getImage() {
            return image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        @Transient
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getCarrier() {
            return carrier;
        }

        public final void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        @Override
        @Transient
        public final Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public final String getRadio() {
            return radio;
        }

        public final void setRadio(String radio) {
            this.radio = radio;
        }

        @Override
        @Transient
        public final Builder radio(String radio) {
            this.radio = radio;
            return this;
        }

        public final Boolean getRemoteAccessEnabled() {
            return remoteAccessEnabled;
        }

        public final void setRemoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
        }

        @Override
        @Transient
        public final Builder remoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
            return this;
        }

        public final Boolean getRemoteDebugEnabled() {
            return remoteDebugEnabled;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        @Override
        @Transient
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final String getFleetType() {
            return fleetType;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        @Override
        @Transient
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        public final String getFleetName() {
            return fleetName;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        @Override
        @Transient
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final List<DeviceInstance.Builder> getInstances() {
            List<DeviceInstance.Builder> result = DeviceInstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<DeviceInstance.BuilderImpl> instances) {
            this.instances = DeviceInstancesCopier.copyFromBuilder(instances);
        }

        @Override
        @Transient
        public final Builder instances(Collection<DeviceInstance> instances) {
            this.instances = DeviceInstancesCopier.copy(instances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instances(DeviceInstance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instances(Consumer<DeviceInstance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> DeviceInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAvailability() {
            return availability;
        }

        public final void setAvailability(String availability) {
            this.availability = availability;
        }

        @Override
        @Transient
        public final Builder availability(String availability) {
            this.availability = availability;
            return this;
        }

        @Override
        @Transient
        public final Builder availability(DeviceAvailability availability) {
            this.availability(availability == null ? null : availability.toString());
            return this;
        }

        @Override
        public Device build() {
            return new Device(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
