/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list runs request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRunsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListRunsResponse.Builder, ListRunsResponse> {
    private static final SdkField<List<Run>> RUNS_FIELD = SdkField
            .<List<Run>> builder(MarshallingType.LIST)
            .memberName("runs")
            .getter(getter(ListRunsResponse::runs))
            .setter(setter(Builder::runs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Run> builder(MarshallingType.SDK_POJO)
                                            .constructor(Run::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRunsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Run> runs;

    private final String nextToken;

    private ListRunsResponse(BuilderImpl builder) {
        super(builder);
        this.runs = builder.runs;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Runs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRuns() {
        return runs != null && !(runs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the runs.
     */
    public final List<Run> runs() {
        return runs;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned. It
     * can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned. It can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRuns() ? runs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRunsResponse)) {
            return false;
        }
        ListRunsResponse other = (ListRunsResponse) obj;
        return hasRuns() == other.hasRuns() && Objects.equals(runs(), other.runs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRunsResponse").add("Runs", hasRuns() ? runs() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runs":
            return Optional.ofNullable(clazz.cast(runs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRunsResponse, T> g) {
        return obj -> g.apply((ListRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRunsResponse> {
        /**
         * <p>
         * Information about the runs.
         * </p>
         * 
         * @param runs
         *        Information about the runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runs(Collection<Run> runs);

        /**
         * <p>
         * Information about the runs.
         * </p>
         * 
         * @param runs
         *        Information about the runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runs(Run... runs);

        /**
         * <p>
         * Information about the runs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Run>.Builder} avoiding the need to create
         * one manually via {@link List<Run>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Run>.Builder#build()} is called immediately and its result
         * is passed to {@link #runs(List<Run>)}.
         * 
         * @param runs
         *        a consumer that will call methods on {@link List<Run>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runs(List<Run>)
         */
        Builder runs(Consumer<Run.Builder>... runs);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned.
         * It can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned. It can be used in a subsequent call to this operation to return the next set of items in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<Run> runs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRunsResponse model) {
            super(model);
            runs(model.runs);
            nextToken(model.nextToken);
        }

        public final List<Run.Builder> getRuns() {
            List<Run.Builder> result = RunsCopier.copyToBuilder(this.runs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuns(Collection<Run.BuilderImpl> runs) {
            this.runs = RunsCopier.copyFromBuilder(runs);
        }

        @Override
        @Transient
        public final Builder runs(Collection<Run> runs) {
            this.runs = RunsCopier.copy(runs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder runs(Run... runs) {
            runs(Arrays.asList(runs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder runs(Consumer<Run.Builder>... runs) {
            runs(Stream.of(runs).map(c -> Run.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRunsResponse build() {
            return new ListRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
