/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for account-level settings in AWS Device Farm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSettings implements SdkPojo, Serializable, ToCopyableBuilder<AccountSettings.Builder, AccountSettings> {
    private static final SdkField<String> AWS_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountNumber").getter(getter(AccountSettings::awsAccountNumber))
            .setter(setter(Builder::awsAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountNumber").build()).build();

    private static final SdkField<Map<String, Integer>> UNMETERED_DEVICES_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("unmeteredDevices")
            .getter(getter(AccountSettings::unmeteredDevicesAsStrings))
            .setter(setter(Builder::unmeteredDevicesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmeteredDevices").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> UNMETERED_REMOTE_ACCESS_DEVICES_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("unmeteredRemoteAccessDevices")
            .getter(getter(AccountSettings::unmeteredRemoteAccessDevicesAsStrings))
            .setter(setter(Builder::unmeteredRemoteAccessDevicesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmeteredRemoteAccessDevices")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_JOB_TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxJobTimeoutMinutes").getter(getter(AccountSettings::maxJobTimeoutMinutes))
            .setter(setter(Builder::maxJobTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobTimeoutMinutes").build())
            .build();

    private static final SdkField<TrialMinutes> TRIAL_MINUTES_FIELD = SdkField.<TrialMinutes> builder(MarshallingType.SDK_POJO)
            .memberName("trialMinutes").getter(getter(AccountSettings::trialMinutes)).setter(setter(Builder::trialMinutes))
            .constructor(TrialMinutes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trialMinutes").build()).build();

    private static final SdkField<Map<String, Integer>> MAX_SLOTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("maxSlots")
            .getter(getter(AccountSettings::maxSlots))
            .setter(setter(Builder::maxSlots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSlots").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> DEFAULT_JOB_TIMEOUT_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("defaultJobTimeoutMinutes")
            .getter(getter(AccountSettings::defaultJobTimeoutMinutes)).setter(setter(Builder::defaultJobTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultJobTimeoutMinutes").build())
            .build();

    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipAppResign").getter(getter(AccountSettings::skipAppResign)).setter(setter(Builder::skipAppResign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_NUMBER_FIELD,
            UNMETERED_DEVICES_FIELD, UNMETERED_REMOTE_ACCESS_DEVICES_FIELD, MAX_JOB_TIMEOUT_MINUTES_FIELD, TRIAL_MINUTES_FIELD,
            MAX_SLOTS_FIELD, DEFAULT_JOB_TIMEOUT_MINUTES_FIELD, SKIP_APP_RESIGN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsAccountNumber;

    private final Map<String, Integer> unmeteredDevices;

    private final Map<String, Integer> unmeteredRemoteAccessDevices;

    private final Integer maxJobTimeoutMinutes;

    private final TrialMinutes trialMinutes;

    private final Map<String, Integer> maxSlots;

    private final Integer defaultJobTimeoutMinutes;

    private final Boolean skipAppResign;

    private AccountSettings(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.unmeteredDevices = builder.unmeteredDevices;
        this.unmeteredRemoteAccessDevices = builder.unmeteredRemoteAccessDevices;
        this.maxJobTimeoutMinutes = builder.maxJobTimeoutMinutes;
        this.trialMinutes = builder.trialMinutes;
        this.maxSlots = builder.maxSlots;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
        this.skipAppResign = builder.skipAppResign;
    }

    /**
     * <p>
     * The AWS account number specified in the <code>AccountSettings</code> container.
     * </p>
     * 
     * @return The AWS account number specified in the <code>AccountSettings</code> container.
     */
    public final String awsAccountNumber() {
        return awsAccountNumber;
    }

    /**
     * <p>
     * Returns the unmetered devices you have purchased or want to purchase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnmeteredDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns the unmetered devices you have purchased or want to purchase.
     */
    public final Map<DevicePlatform, Integer> unmeteredDevices() {
        return PurchasedDevicesMapCopier.copyStringToEnum(unmeteredDevices);
    }

    /**
     * Returns true if the UnmeteredDevices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnmeteredDevices() {
        return unmeteredDevices != null && !(unmeteredDevices instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Returns the unmetered devices you have purchased or want to purchase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnmeteredDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns the unmetered devices you have purchased or want to purchase.
     */
    public final Map<String, Integer> unmeteredDevicesAsStrings() {
        return unmeteredDevices;
    }

    /**
     * <p>
     * Returns the unmetered remote access devices you have purchased or want to purchase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnmeteredRemoteAccessDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns the unmetered remote access devices you have purchased or want to purchase.
     */
    public final Map<DevicePlatform, Integer> unmeteredRemoteAccessDevices() {
        return PurchasedDevicesMapCopier.copyStringToEnum(unmeteredRemoteAccessDevices);
    }

    /**
     * Returns true if the UnmeteredRemoteAccessDevices property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasUnmeteredRemoteAccessDevices() {
        return unmeteredRemoteAccessDevices != null && !(unmeteredRemoteAccessDevices instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Returns the unmetered remote access devices you have purchased or want to purchase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnmeteredRemoteAccessDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns the unmetered remote access devices you have purchased or want to purchase.
     */
    public final Map<String, Integer> unmeteredRemoteAccessDevicesAsStrings() {
        return unmeteredRemoteAccessDevices;
    }

    /**
     * <p>
     * The maximum number of minutes a test run executes before it times out.
     * </p>
     * 
     * @return The maximum number of minutes a test run executes before it times out.
     */
    public final Integer maxJobTimeoutMinutes() {
        return maxJobTimeoutMinutes;
    }

    /**
     * <p>
     * Information about an AWS account's usage of free trial device minutes.
     * </p>
     * 
     * @return Information about an AWS account's usage of free trial device minutes.
     */
    public final TrialMinutes trialMinutes() {
        return trialMinutes;
    }

    /**
     * Returns true if the MaxSlots property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMaxSlots() {
        return maxSlots != null && !(maxSlots instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The maximum number of device slots that the AWS account can purchase. Each maximum is expressed as an
     * <code>offering-id:number</code> pair, where the <code>offering-id</code> represents one of the IDs returned by
     * the <code>ListOfferings</code> command.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMaxSlots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The maximum number of device slots that the AWS account can purchase. Each maximum is expressed as an
     *         <code>offering-id:number</code> pair, where the <code>offering-id</code> represents one of the IDs
     *         returned by the <code>ListOfferings</code> command.
     */
    public final Map<String, Integer> maxSlots() {
        return maxSlots;
    }

    /**
     * <p>
     * The default number of minutes (at the account level) a test run executes before it times out. The default value
     * is 150 minutes.
     * </p>
     * 
     * @return The default number of minutes (at the account level) a test run executes before it times out. The default
     *         value is 150 minutes.
     */
    public final Integer defaultJobTimeoutMinutes() {
        return defaultJobTimeoutMinutes;
    }

    /**
     * <p>
     * When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public devices,
     * Device Farm always signs your apps again.
     * </p>
     * <p>
     * For more information about how Device Farm re-signs your apps, see <a
     * href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device Farm FAQs</i>.
     * </p>
     * 
     * @return When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
     *         devices, Device Farm always signs your apps again.</p>
     *         <p>
     *         For more information about how Device Farm re-signs your apps, see <a
     *         href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device Farm
     *         FAQs</i>.
     */
    public final Boolean skipAppResign() {
        return skipAppResign;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnmeteredDevices() ? unmeteredDevicesAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasUnmeteredRemoteAccessDevices() ? unmeteredRemoteAccessDevicesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxJobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(trialMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasMaxSlots() ? maxSlots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultJobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(skipAppResign());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings) obj;
        return Objects.equals(awsAccountNumber(), other.awsAccountNumber())
                && hasUnmeteredDevices() == other.hasUnmeteredDevices()
                && Objects.equals(unmeteredDevicesAsStrings(), other.unmeteredDevicesAsStrings())
                && hasUnmeteredRemoteAccessDevices() == other.hasUnmeteredRemoteAccessDevices()
                && Objects.equals(unmeteredRemoteAccessDevicesAsStrings(), other.unmeteredRemoteAccessDevicesAsStrings())
                && Objects.equals(maxJobTimeoutMinutes(), other.maxJobTimeoutMinutes())
                && Objects.equals(trialMinutes(), other.trialMinutes()) && hasMaxSlots() == other.hasMaxSlots()
                && Objects.equals(maxSlots(), other.maxSlots())
                && Objects.equals(defaultJobTimeoutMinutes(), other.defaultJobTimeoutMinutes())
                && Objects.equals(skipAppResign(), other.skipAppResign());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AccountSettings")
                .add("AwsAccountNumber", awsAccountNumber())
                .add("UnmeteredDevices", hasUnmeteredDevices() ? unmeteredDevicesAsStrings() : null)
                .add("UnmeteredRemoteAccessDevices",
                        hasUnmeteredRemoteAccessDevices() ? unmeteredRemoteAccessDevicesAsStrings() : null)
                .add("MaxJobTimeoutMinutes", maxJobTimeoutMinutes()).add("TrialMinutes", trialMinutes())
                .add("MaxSlots", hasMaxSlots() ? maxSlots() : null).add("DefaultJobTimeoutMinutes", defaultJobTimeoutMinutes())
                .add("SkipAppResign", skipAppResign()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountNumber":
            return Optional.ofNullable(clazz.cast(awsAccountNumber()));
        case "unmeteredDevices":
            return Optional.ofNullable(clazz.cast(unmeteredDevicesAsStrings()));
        case "unmeteredRemoteAccessDevices":
            return Optional.ofNullable(clazz.cast(unmeteredRemoteAccessDevicesAsStrings()));
        case "maxJobTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(maxJobTimeoutMinutes()));
        case "trialMinutes":
            return Optional.ofNullable(clazz.cast(trialMinutes()));
        case "maxSlots":
            return Optional.ofNullable(clazz.cast(maxSlots()));
        case "defaultJobTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(defaultJobTimeoutMinutes()));
        case "skipAppResign":
            return Optional.ofNullable(clazz.cast(skipAppResign()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSettings> {
        /**
         * <p>
         * The AWS account number specified in the <code>AccountSettings</code> container.
         * </p>
         * 
         * @param awsAccountNumber
         *        The AWS account number specified in the <code>AccountSettings</code> container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountNumber(String awsAccountNumber);

        /**
         * <p>
         * Returns the unmetered devices you have purchased or want to purchase.
         * </p>
         * 
         * @param unmeteredDevices
         *        Returns the unmetered devices you have purchased or want to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmeteredDevicesWithStrings(Map<String, Integer> unmeteredDevices);

        /**
         * <p>
         * Returns the unmetered devices you have purchased or want to purchase.
         * </p>
         * 
         * @param unmeteredDevices
         *        Returns the unmetered devices you have purchased or want to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmeteredDevices(Map<DevicePlatform, Integer> unmeteredDevices);

        /**
         * <p>
         * Returns the unmetered remote access devices you have purchased or want to purchase.
         * </p>
         * 
         * @param unmeteredRemoteAccessDevices
         *        Returns the unmetered remote access devices you have purchased or want to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmeteredRemoteAccessDevicesWithStrings(Map<String, Integer> unmeteredRemoteAccessDevices);

        /**
         * <p>
         * Returns the unmetered remote access devices you have purchased or want to purchase.
         * </p>
         * 
         * @param unmeteredRemoteAccessDevices
         *        Returns the unmetered remote access devices you have purchased or want to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmeteredRemoteAccessDevices(Map<DevicePlatform, Integer> unmeteredRemoteAccessDevices);

        /**
         * <p>
         * The maximum number of minutes a test run executes before it times out.
         * </p>
         * 
         * @param maxJobTimeoutMinutes
         *        The maximum number of minutes a test run executes before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxJobTimeoutMinutes(Integer maxJobTimeoutMinutes);

        /**
         * <p>
         * Information about an AWS account's usage of free trial device minutes.
         * </p>
         * 
         * @param trialMinutes
         *        Information about an AWS account's usage of free trial device minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialMinutes(TrialMinutes trialMinutes);

        /**
         * <p>
         * Information about an AWS account's usage of free trial device minutes.
         * </p>
         * This is a convenience that creates an instance of the {@link TrialMinutes.Builder} avoiding the need to
         * create one manually via {@link TrialMinutes#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialMinutes.Builder#build()} is called immediately and its
         * result is passed to {@link #trialMinutes(TrialMinutes)}.
         * 
         * @param trialMinutes
         *        a consumer that will call methods on {@link TrialMinutes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialMinutes(TrialMinutes)
         */
        default Builder trialMinutes(Consumer<TrialMinutes.Builder> trialMinutes) {
            return trialMinutes(TrialMinutes.builder().applyMutation(trialMinutes).build());
        }

        /**
         * <p>
         * The maximum number of device slots that the AWS account can purchase. Each maximum is expressed as an
         * <code>offering-id:number</code> pair, where the <code>offering-id</code> represents one of the IDs returned
         * by the <code>ListOfferings</code> command.
         * </p>
         * 
         * @param maxSlots
         *        The maximum number of device slots that the AWS account can purchase. Each maximum is expressed as an
         *        <code>offering-id:number</code> pair, where the <code>offering-id</code> represents one of the IDs
         *        returned by the <code>ListOfferings</code> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSlots(Map<String, Integer> maxSlots);

        /**
         * <p>
         * The default number of minutes (at the account level) a test run executes before it times out. The default
         * value is 150 minutes.
         * </p>
         * 
         * @param defaultJobTimeoutMinutes
         *        The default number of minutes (at the account level) a test run executes before it times out. The
         *        default value is 150 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes);

        /**
         * <p>
         * When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
         * devices, Device Farm always signs your apps again.
         * </p>
         * <p>
         * For more information about how Device Farm re-signs your apps, see <a
         * href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device Farm FAQs</i>.
         * </p>
         * 
         * @param skipAppResign
         *        When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For
         *        public devices, Device Farm always signs your apps again.</p>
         *        <p>
         *        For more information about how Device Farm re-signs your apps, see <a
         *        href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device Farm
         *        FAQs</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipAppResign(Boolean skipAppResign);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountNumber;

        private Map<String, Integer> unmeteredDevices = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Integer> unmeteredRemoteAccessDevices = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxJobTimeoutMinutes;

        private TrialMinutes trialMinutes;

        private Map<String, Integer> maxSlots = DefaultSdkAutoConstructMap.getInstance();

        private Integer defaultJobTimeoutMinutes;

        private Boolean skipAppResign;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            awsAccountNumber(model.awsAccountNumber);
            unmeteredDevicesWithStrings(model.unmeteredDevices);
            unmeteredRemoteAccessDevicesWithStrings(model.unmeteredRemoteAccessDevices);
            maxJobTimeoutMinutes(model.maxJobTimeoutMinutes);
            trialMinutes(model.trialMinutes);
            maxSlots(model.maxSlots);
            defaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
            skipAppResign(model.skipAppResign);
        }

        public final String getAwsAccountNumber() {
            return awsAccountNumber;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        @Override
        @Transient
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final Map<String, Integer> getUnmeteredDevices() {
            if (unmeteredDevices instanceof SdkAutoConstructMap) {
                return null;
            }
            return unmeteredDevices;
        }

        public final void setUnmeteredDevices(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
        }

        @Override
        @Transient
        public final Builder unmeteredDevicesWithStrings(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
            return this;
        }

        @Override
        @Transient
        public final Builder unmeteredDevices(Map<DevicePlatform, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copyEnumToString(unmeteredDevices);
            return this;
        }

        public final Map<String, Integer> getUnmeteredRemoteAccessDevices() {
            if (unmeteredRemoteAccessDevices instanceof SdkAutoConstructMap) {
                return null;
            }
            return unmeteredRemoteAccessDevices;
        }

        public final void setUnmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
        }

        @Override
        @Transient
        public final Builder unmeteredRemoteAccessDevicesWithStrings(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
            return this;
        }

        @Override
        @Transient
        public final Builder unmeteredRemoteAccessDevices(Map<DevicePlatform, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copyEnumToString(unmeteredRemoteAccessDevices);
            return this;
        }

        public final Integer getMaxJobTimeoutMinutes() {
            return maxJobTimeoutMinutes;
        }

        public final void setMaxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
        }

        @Override
        @Transient
        public final Builder maxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
            return this;
        }

        public final TrialMinutes.Builder getTrialMinutes() {
            return trialMinutes != null ? trialMinutes.toBuilder() : null;
        }

        public final void setTrialMinutes(TrialMinutes.BuilderImpl trialMinutes) {
            this.trialMinutes = trialMinutes != null ? trialMinutes.build() : null;
        }

        @Override
        @Transient
        public final Builder trialMinutes(TrialMinutes trialMinutes) {
            this.trialMinutes = trialMinutes;
            return this;
        }

        public final Map<String, Integer> getMaxSlots() {
            if (maxSlots instanceof SdkAutoConstructMap) {
                return null;
            }
            return maxSlots;
        }

        public final void setMaxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
        }

        @Override
        @Transient
        public final Builder maxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
            return this;
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return defaultJobTimeoutMinutes;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        @Override
        @Transient
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final Boolean getSkipAppResign() {
            return skipAppResign;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        @Override
        @Transient
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        @Override
        public AccountSettings build() {
            return new AccountSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
