/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a specific warning or failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Problem implements SdkPojo, Serializable, ToCopyableBuilder<Problem.Builder, Problem> {
    private static final SdkField<ProblemDetail> RUN_FIELD = SdkField.<ProblemDetail> builder(MarshallingType.SDK_POJO)
            .memberName("run").getter(getter(Problem::run)).setter(setter(Builder::run)).constructor(ProblemDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("run").build()).build();

    private static final SdkField<ProblemDetail> JOB_FIELD = SdkField.<ProblemDetail> builder(MarshallingType.SDK_POJO)
            .memberName("job").getter(getter(Problem::job)).setter(setter(Builder::job)).constructor(ProblemDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("job").build()).build();

    private static final SdkField<ProblemDetail> SUITE_FIELD = SdkField.<ProblemDetail> builder(MarshallingType.SDK_POJO)
            .memberName("suite").getter(getter(Problem::suite)).setter(setter(Builder::suite))
            .constructor(ProblemDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suite").build()).build();

    private static final SdkField<ProblemDetail> TEST_FIELD = SdkField.<ProblemDetail> builder(MarshallingType.SDK_POJO)
            .memberName("test").getter(getter(Problem::test)).setter(setter(Builder::test)).constructor(ProblemDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("test").build()).build();

    private static final SdkField<Device> DEVICE_FIELD = SdkField.<Device> builder(MarshallingType.SDK_POJO).memberName("device")
            .getter(getter(Problem::device)).setter(setter(Builder::device)).constructor(Device::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(Problem::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(Problem::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_FIELD, JOB_FIELD,
            SUITE_FIELD, TEST_FIELD, DEVICE_FIELD, RESULT_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProblemDetail run;

    private final ProblemDetail job;

    private final ProblemDetail suite;

    private final ProblemDetail test;

    private final Device device;

    private final String result;

    private final String message;

    private Problem(BuilderImpl builder) {
        this.run = builder.run;
        this.job = builder.job;
        this.suite = builder.suite;
        this.test = builder.test;
        this.device = builder.device;
        this.result = builder.result;
        this.message = builder.message;
    }

    /**
     * <p>
     * Information about the associated run.
     * </p>
     * 
     * @return Information about the associated run.
     */
    public final ProblemDetail run() {
        return run;
    }

    /**
     * <p>
     * Information about the associated job.
     * </p>
     * 
     * @return Information about the associated job.
     */
    public final ProblemDetail job() {
        return job;
    }

    /**
     * <p>
     * Information about the associated suite.
     * </p>
     * 
     * @return Information about the associated suite.
     */
    public final ProblemDetail suite() {
        return suite;
    }

    /**
     * <p>
     * Information about the associated test.
     * </p>
     * 
     * @return Information about the associated test.
     */
    public final ProblemDetail test() {
        return test;
    }

    /**
     * <p>
     * Information about the associated device.
     * </p>
     * 
     * @return Information about the associated device.
     */
    public final Device device() {
        return device;
    }

    /**
     * <p>
     * The problem's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The problem's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public final ExecutionResult result() {
        return ExecutionResult.fromValue(result);
    }

    /**
     * <p>
     * The problem's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The problem's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public final String resultAsString() {
        return result;
    }

    /**
     * <p>
     * A message about the problem's result.
     * </p>
     * 
     * @return A message about the problem's result.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(run());
        hashCode = 31 * hashCode + Objects.hashCode(job());
        hashCode = 31 * hashCode + Objects.hashCode(suite());
        hashCode = 31 * hashCode + Objects.hashCode(test());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem) obj;
        return Objects.equals(run(), other.run()) && Objects.equals(job(), other.job()) && Objects.equals(suite(), other.suite())
                && Objects.equals(test(), other.test()) && Objects.equals(device(), other.device())
                && Objects.equals(resultAsString(), other.resultAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Problem").add("Run", run()).add("Job", job()).add("Suite", suite()).add("Test", test())
                .add("Device", device()).add("Result", resultAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "run":
            return Optional.ofNullable(clazz.cast(run()));
        case "job":
            return Optional.ofNullable(clazz.cast(job()));
        case "suite":
            return Optional.ofNullable(clazz.cast(suite()));
        case "test":
            return Optional.ofNullable(clazz.cast(test()));
        case "device":
            return Optional.ofNullable(clazz.cast(device()));
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Problem, T> g) {
        return obj -> g.apply((Problem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Problem> {
        /**
         * <p>
         * Information about the associated run.
         * </p>
         * 
         * @param run
         *        Information about the associated run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder run(ProblemDetail run);

        /**
         * <p>
         * Information about the associated run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProblemDetail.Builder} avoiding the need
         * to create one manually via {@link ProblemDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProblemDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #run(ProblemDetail)}.
         * 
         * @param run
         *        a consumer that will call methods on {@link ProblemDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #run(ProblemDetail)
         */
        default Builder run(Consumer<ProblemDetail.Builder> run) {
            return run(ProblemDetail.builder().applyMutation(run).build());
        }

        /**
         * <p>
         * Information about the associated job.
         * </p>
         * 
         * @param job
         *        Information about the associated job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder job(ProblemDetail job);

        /**
         * <p>
         * Information about the associated job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProblemDetail.Builder} avoiding the need
         * to create one manually via {@link ProblemDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProblemDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #job(ProblemDetail)}.
         * 
         * @param job
         *        a consumer that will call methods on {@link ProblemDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #job(ProblemDetail)
         */
        default Builder job(Consumer<ProblemDetail.Builder> job) {
            return job(ProblemDetail.builder().applyMutation(job).build());
        }

        /**
         * <p>
         * Information about the associated suite.
         * </p>
         * 
         * @param suite
         *        Information about the associated suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suite(ProblemDetail suite);

        /**
         * <p>
         * Information about the associated suite.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProblemDetail.Builder} avoiding the need
         * to create one manually via {@link ProblemDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProblemDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #suite(ProblemDetail)}.
         * 
         * @param suite
         *        a consumer that will call methods on {@link ProblemDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suite(ProblemDetail)
         */
        default Builder suite(Consumer<ProblemDetail.Builder> suite) {
            return suite(ProblemDetail.builder().applyMutation(suite).build());
        }

        /**
         * <p>
         * Information about the associated test.
         * </p>
         * 
         * @param test
         *        Information about the associated test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(ProblemDetail test);

        /**
         * <p>
         * Information about the associated test.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProblemDetail.Builder} avoiding the need
         * to create one manually via {@link ProblemDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProblemDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #test(ProblemDetail)}.
         * 
         * @param test
         *        a consumer that will call methods on {@link ProblemDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #test(ProblemDetail)
         */
        default Builder test(Consumer<ProblemDetail.Builder> test) {
            return test(ProblemDetail.builder().applyMutation(test).build());
        }

        /**
         * <p>
         * Information about the associated device.
         * </p>
         * 
         * @param device
         *        Information about the associated device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * Information about the associated device.
         * </p>
         * This is a convenience method that creates an instance of the {@link Device.Builder} avoiding the need to
         * create one manually via {@link Device#builder()}.
         *
         * When the {@link Consumer} completes, {@link Device.Builder#build()} is called immediately and its result is
         * passed to {@link #device(Device)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(Device)
         */
        default Builder device(Consumer<Device.Builder> device) {
            return device(Device.builder().applyMutation(device).build());
        }

        /**
         * <p>
         * The problem's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The problem's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The problem's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The problem's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * A message about the problem's result.
         * </p>
         * 
         * @param message
         *        A message about the problem's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private ProblemDetail run;

        private ProblemDetail job;

        private ProblemDetail suite;

        private ProblemDetail test;

        private Device device;

        private String result;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(Problem model) {
            run(model.run);
            job(model.job);
            suite(model.suite);
            test(model.test);
            device(model.device);
            result(model.result);
            message(model.message);
        }

        public final ProblemDetail.Builder getRun() {
            return run != null ? run.toBuilder() : null;
        }

        public final void setRun(ProblemDetail.BuilderImpl run) {
            this.run = run != null ? run.build() : null;
        }

        @Override
        @Transient
        public final Builder run(ProblemDetail run) {
            this.run = run;
            return this;
        }

        public final ProblemDetail.Builder getJob() {
            return job != null ? job.toBuilder() : null;
        }

        public final void setJob(ProblemDetail.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        @Override
        @Transient
        public final Builder job(ProblemDetail job) {
            this.job = job;
            return this;
        }

        public final ProblemDetail.Builder getSuite() {
            return suite != null ? suite.toBuilder() : null;
        }

        public final void setSuite(ProblemDetail.BuilderImpl suite) {
            this.suite = suite != null ? suite.build() : null;
        }

        @Override
        @Transient
        public final Builder suite(ProblemDetail suite) {
            this.suite = suite;
            return this;
        }

        public final ProblemDetail.Builder getTest() {
            return test != null ? test.toBuilder() : null;
        }

        public final void setTest(ProblemDetail.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        @Override
        @Transient
        public final Builder test(ProblemDetail test) {
            this.test = test;
            return this;
        }

        public final Device.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        @Override
        @Transient
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        @Transient
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        @Transient
        public final Builder result(ExecutionResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public Problem build() {
            return new Problem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
