/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the purchase offering (for example, success or failure).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseOfferingResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<PurchaseOfferingResponse.Builder, PurchaseOfferingResponse> {
    private static final SdkField<OfferingTransaction> OFFERING_TRANSACTION_FIELD = SdkField
            .<OfferingTransaction> builder(MarshallingType.SDK_POJO).memberName("offeringTransaction")
            .getter(getter(PurchaseOfferingResponse::offeringTransaction)).setter(setter(Builder::offeringTransaction))
            .constructor(OfferingTransaction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringTransaction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_TRANSACTION_FIELD));

    private final OfferingTransaction offeringTransaction;

    private PurchaseOfferingResponse(BuilderImpl builder) {
        super(builder);
        this.offeringTransaction = builder.offeringTransaction;
    }

    /**
     * <p>
     * Represents the offering transaction for the purchase result.
     * </p>
     * 
     * @return Represents the offering transaction for the purchase result.
     */
    public final OfferingTransaction offeringTransaction() {
        return offeringTransaction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(offeringTransaction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingResponse)) {
            return false;
        }
        PurchaseOfferingResponse other = (PurchaseOfferingResponse) obj;
        return Objects.equals(offeringTransaction(), other.offeringTransaction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseOfferingResponse").add("OfferingTransaction", offeringTransaction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringTransaction":
            return Optional.ofNullable(clazz.cast(offeringTransaction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseOfferingResponse, T> g) {
        return obj -> g.apply((PurchaseOfferingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, PurchaseOfferingResponse> {
        /**
         * <p>
         * Represents the offering transaction for the purchase result.
         * </p>
         * 
         * @param offeringTransaction
         *        Represents the offering transaction for the purchase result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringTransaction(OfferingTransaction offeringTransaction);

        /**
         * <p>
         * Represents the offering transaction for the purchase result.
         * </p>
         * This is a convenience method that creates an instance of the {@link OfferingTransaction.Builder} avoiding the
         * need to create one manually via {@link OfferingTransaction#builder()}.
         *
         * When the {@link Consumer} completes, {@link OfferingTransaction.Builder#build()} is called immediately and
         * its result is passed to {@link #offeringTransaction(OfferingTransaction)}.
         * 
         * @param offeringTransaction
         *        a consumer that will call methods on {@link OfferingTransaction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offeringTransaction(OfferingTransaction)
         */
        default Builder offeringTransaction(Consumer<OfferingTransaction.Builder> offeringTransaction) {
            return offeringTransaction(OfferingTransaction.builder().applyMutation(offeringTransaction).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private OfferingTransaction offeringTransaction;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingResponse model) {
            super(model);
            offeringTransaction(model.offeringTransaction);
        }

        public final OfferingTransaction.Builder getOfferingTransaction() {
            return offeringTransaction != null ? offeringTransaction.toBuilder() : null;
        }

        public final void setOfferingTransaction(OfferingTransaction.BuilderImpl offeringTransaction) {
            this.offeringTransaction = offeringTransaction != null ? offeringTransaction.build() : null;
        }

        @Override
        @Transient
        public final Builder offeringTransaction(OfferingTransaction offeringTransaction) {
            this.offeringTransaction = offeringTransaction;
            return this;
        }

        @Override
        public PurchaseOfferingResponse build() {
            return new PurchaseOfferingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
