/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings for a run. Includes things like location, radio states, auxiliary apps, and network profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleRunConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleRunConfiguration.Builder, ScheduleRunConfiguration> {
    private static final SdkField<String> EXTRA_DATA_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("extraDataPackageArn").getter(getter(ScheduleRunConfiguration::extraDataPackageArn))
            .setter(setter(Builder::extraDataPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraDataPackageArn").build())
            .build();

    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkProfileArn").getter(getter(ScheduleRunConfiguration::networkProfileArn))
            .setter(setter(Builder::networkProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkProfileArn").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(ScheduleRunConfiguration::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .memberName("location").getter(getter(ScheduleRunConfiguration::location)).setter(setter(Builder::location))
            .constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<List<String>> VPCE_CONFIGURATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpceConfigurationArns")
            .getter(getter(ScheduleRunConfiguration::vpceConfigurationArns))
            .setter(setter(Builder::vpceConfigurationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomerArtifactPaths> CUSTOMER_ARTIFACT_PATHS_FIELD = SdkField
            .<CustomerArtifactPaths> builder(MarshallingType.SDK_POJO).memberName("customerArtifactPaths")
            .getter(getter(ScheduleRunConfiguration::customerArtifactPaths)).setter(setter(Builder::customerArtifactPaths))
            .constructor(CustomerArtifactPaths::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerArtifactPaths").build())
            .build();

    private static final SdkField<Radios> RADIOS_FIELD = SdkField.<Radios> builder(MarshallingType.SDK_POJO).memberName("radios")
            .getter(getter(ScheduleRunConfiguration::radios)).setter(setter(Builder::radios)).constructor(Radios::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("radios").build()).build();

    private static final SdkField<List<String>> AUXILIARY_APPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("auxiliaryApps")
            .getter(getter(ScheduleRunConfiguration::auxiliaryApps))
            .setter(setter(Builder::auxiliaryApps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auxiliaryApps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BILLING_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingMethod").getter(getter(ScheduleRunConfiguration::billingMethodAsString))
            .setter(setter(Builder::billingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRA_DATA_PACKAGE_ARN_FIELD,
            NETWORK_PROFILE_ARN_FIELD, LOCALE_FIELD, LOCATION_FIELD, VPCE_CONFIGURATION_ARNS_FIELD,
            CUSTOMER_ARTIFACT_PATHS_FIELD, RADIOS_FIELD, AUXILIARY_APPS_FIELD, BILLING_METHOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String extraDataPackageArn;

    private final String networkProfileArn;

    private final String locale;

    private final Location location;

    private final List<String> vpceConfigurationArns;

    private final CustomerArtifactPaths customerArtifactPaths;

    private final Radios radios;

    private final List<String> auxiliaryApps;

    private final String billingMethod;

    private ScheduleRunConfiguration(BuilderImpl builder) {
        this.extraDataPackageArn = builder.extraDataPackageArn;
        this.networkProfileArn = builder.networkProfileArn;
        this.locale = builder.locale;
        this.location = builder.location;
        this.vpceConfigurationArns = builder.vpceConfigurationArns;
        this.customerArtifactPaths = builder.customerArtifactPaths;
        this.radios = builder.radios;
        this.auxiliaryApps = builder.auxiliaryApps;
        this.billingMethod = builder.billingMethod;
    }

    /**
     * <p>
     * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to external
     * data for Android or the app's sandbox for iOS.
     * </p>
     * 
     * @return The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to
     *         external data for Android or the app's sandbox for iOS.
     */
    public final String extraDataPackageArn() {
        return extraDataPackageArn;
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * 
     * @return Reserved for internal use.
     */
    public final String networkProfileArn() {
        return networkProfileArn;
    }

    /**
     * <p>
     * Information about the locale that is used for the run.
     * </p>
     * 
     * @return Information about the locale that is used for the run.
     */
    public final String locale() {
        return locale;
    }

    /**
     * <p>
     * Information about the location that is used for the run.
     * </p>
     * 
     * @return Information about the location that is used for the run.
     */
    public final Location location() {
        return location;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpceConfigurationArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpceConfigurationArns() {
        return vpceConfigurationArns != null && !(vpceConfigurationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of ARNs for your VPC endpoint configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpceConfigurationArns} method.
     * </p>
     * 
     * @return An array of ARNs for your VPC endpoint configurations.
     */
    public final List<String> vpceConfigurationArns() {
        return vpceConfigurationArns;
    }

    /**
     * <p>
     * Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
     * </p>
     * 
     * @return Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
     */
    public final CustomerArtifactPaths customerArtifactPaths() {
        return customerArtifactPaths;
    }

    /**
     * <p>
     * Information about the radio states for the run.
     * </p>
     * 
     * @return Information about the radio states for the run.
     */
    public final Radios radios() {
        return radios;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuxiliaryApps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuxiliaryApps() {
        return auxiliaryApps != null && !(auxiliaryApps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of upload ARNs for app packages to be installed with your app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuxiliaryApps} method.
     * </p>
     * 
     * @return A list of upload ARNs for app packages to be installed with your app.
     */
    public final List<String> auxiliaryApps() {
        return auxiliaryApps;
    }

    /**
     * <p>
     * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is
     * not specified, the default value is <code>metered</code>.
     * </p>
     * <note>
     * <p>
     * If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to make use
     * of them. Otherwise, your run counts against your metered time.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
     *         parameter is not specified, the default value is <code>metered</code>.</p> <note>
     *         <p>
     *         If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to
     *         make use of them. Otherwise, your run counts against your metered time.
     *         </p>
     * @see BillingMethod
     */
    public final BillingMethod billingMethod() {
        return BillingMethod.fromValue(billingMethod);
    }

    /**
     * <p>
     * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is
     * not specified, the default value is <code>metered</code>.
     * </p>
     * <note>
     * <p>
     * If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to make use
     * of them. Otherwise, your run counts against your metered time.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
     *         parameter is not specified, the default value is <code>metered</code>.</p> <note>
     *         <p>
     *         If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to
     *         make use of them. Otherwise, your run counts against your metered time.
     *         </p>
     * @see BillingMethod
     */
    public final String billingMethodAsString() {
        return billingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extraDataPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpceConfigurationArns() ? vpceConfigurationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customerArtifactPaths());
        hashCode = 31 * hashCode + Objects.hashCode(radios());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuxiliaryApps() ? auxiliaryApps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(billingMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunConfiguration)) {
            return false;
        }
        ScheduleRunConfiguration other = (ScheduleRunConfiguration) obj;
        return Objects.equals(extraDataPackageArn(), other.extraDataPackageArn())
                && Objects.equals(networkProfileArn(), other.networkProfileArn()) && Objects.equals(locale(), other.locale())
                && Objects.equals(location(), other.location()) && hasVpceConfigurationArns() == other.hasVpceConfigurationArns()
                && Objects.equals(vpceConfigurationArns(), other.vpceConfigurationArns())
                && Objects.equals(customerArtifactPaths(), other.customerArtifactPaths())
                && Objects.equals(radios(), other.radios()) && hasAuxiliaryApps() == other.hasAuxiliaryApps()
                && Objects.equals(auxiliaryApps(), other.auxiliaryApps())
                && Objects.equals(billingMethodAsString(), other.billingMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleRunConfiguration").add("ExtraDataPackageArn", extraDataPackageArn())
                .add("NetworkProfileArn", networkProfileArn()).add("Locale", locale()).add("Location", location())
                .add("VpceConfigurationArns", hasVpceConfigurationArns() ? vpceConfigurationArns() : null)
                .add("CustomerArtifactPaths", customerArtifactPaths()).add("Radios", radios())
                .add("AuxiliaryApps", hasAuxiliaryApps() ? auxiliaryApps() : null).add("BillingMethod", billingMethodAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extraDataPackageArn":
            return Optional.ofNullable(clazz.cast(extraDataPackageArn()));
        case "networkProfileArn":
            return Optional.ofNullable(clazz.cast(networkProfileArn()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "vpceConfigurationArns":
            return Optional.ofNullable(clazz.cast(vpceConfigurationArns()));
        case "customerArtifactPaths":
            return Optional.ofNullable(clazz.cast(customerArtifactPaths()));
        case "radios":
            return Optional.ofNullable(clazz.cast(radios()));
        case "auxiliaryApps":
            return Optional.ofNullable(clazz.cast(auxiliaryApps()));
        case "billingMethod":
            return Optional.ofNullable(clazz.cast(billingMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleRunConfiguration, T> g) {
        return obj -> g.apply((ScheduleRunConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleRunConfiguration> {
        /**
         * <p>
         * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to
         * external data for Android or the app's sandbox for iOS.
         * </p>
         * 
         * @param extraDataPackageArn
         *        The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to
         *        external data for Android or the app's sandbox for iOS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraDataPackageArn(String extraDataPackageArn);

        /**
         * <p>
         * Reserved for internal use.
         * </p>
         * 
         * @param networkProfileArn
         *        Reserved for internal use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfileArn(String networkProfileArn);

        /**
         * <p>
         * Information about the locale that is used for the run.
         * </p>
         * 
         * @param locale
         *        Information about the locale that is used for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * Information about the location that is used for the run.
         * </p>
         * 
         * @param location
         *        Information about the location that is used for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * Information about the location that is used for the run.
         * </p>
         * This is a convenience method that creates an instance of the {@link Location.Builder} avoiding the need to
         * create one manually via {@link Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * An array of ARNs for your VPC endpoint configurations.
         * </p>
         * 
         * @param vpceConfigurationArns
         *        An array of ARNs for your VPC endpoint configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationArns(Collection<String> vpceConfigurationArns);

        /**
         * <p>
         * An array of ARNs for your VPC endpoint configurations.
         * </p>
         * 
         * @param vpceConfigurationArns
         *        An array of ARNs for your VPC endpoint configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationArns(String... vpceConfigurationArns);

        /**
         * <p>
         * Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
         * </p>
         * 
         * @param customerArtifactPaths
         *        Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths);

        /**
         * <p>
         * Input <code>CustomerArtifactPaths</code> object for the scheduled run configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerArtifactPaths.Builder} avoiding
         * the need to create one manually via {@link CustomerArtifactPaths#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerArtifactPaths.Builder#build()} is called immediately and
         * its result is passed to {@link #customerArtifactPaths(CustomerArtifactPaths)}.
         * 
         * @param customerArtifactPaths
         *        a consumer that will call methods on {@link CustomerArtifactPaths.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerArtifactPaths(CustomerArtifactPaths)
         */
        default Builder customerArtifactPaths(Consumer<CustomerArtifactPaths.Builder> customerArtifactPaths) {
            return customerArtifactPaths(CustomerArtifactPaths.builder().applyMutation(customerArtifactPaths).build());
        }

        /**
         * <p>
         * Information about the radio states for the run.
         * </p>
         * 
         * @param radios
         *        Information about the radio states for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radios(Radios radios);

        /**
         * <p>
         * Information about the radio states for the run.
         * </p>
         * This is a convenience method that creates an instance of the {@link Radios.Builder} avoiding the need to
         * create one manually via {@link Radios#builder()}.
         *
         * When the {@link Consumer} completes, {@link Radios.Builder#build()} is called immediately and its result is
         * passed to {@link #radios(Radios)}.
         * 
         * @param radios
         *        a consumer that will call methods on {@link Radios.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #radios(Radios)
         */
        default Builder radios(Consumer<Radios.Builder> radios) {
            return radios(Radios.builder().applyMutation(radios).build());
        }

        /**
         * <p>
         * A list of upload ARNs for app packages to be installed with your app.
         * </p>
         * 
         * @param auxiliaryApps
         *        A list of upload ARNs for app packages to be installed with your app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryApps(Collection<String> auxiliaryApps);

        /**
         * <p>
         * A list of upload ARNs for app packages to be installed with your app.
         * </p>
         * 
         * @param auxiliaryApps
         *        A list of upload ARNs for app packages to be installed with your app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryApps(String... auxiliaryApps);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * <note>
         * <p>
         * If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to make
         * use of them. Otherwise, your run counts against your metered time.
         * </p>
         * </note>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.</p> <note>
         *        <p>
         *        If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to
         *        make use of them. Otherwise, your run counts against your metered time.
         *        </p>
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * <note>
         * <p>
         * If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to make
         * use of them. Otherwise, your run counts against your metered time.
         * </p>
         * </note>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.</p> <note>
         *        <p>
         *        If you have purchased unmetered device slots, you must set this parameter to <code>unmetered</code> to
         *        make use of them. Otherwise, your run counts against your metered time.
         *        </p>
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);
    }

    static final class BuilderImpl implements Builder {
        private String extraDataPackageArn;

        private String networkProfileArn;

        private String locale;

        private Location location;

        private List<String> vpceConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private CustomerArtifactPaths customerArtifactPaths;

        private Radios radios;

        private List<String> auxiliaryApps = DefaultSdkAutoConstructList.getInstance();

        private String billingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunConfiguration model) {
            extraDataPackageArn(model.extraDataPackageArn);
            networkProfileArn(model.networkProfileArn);
            locale(model.locale);
            location(model.location);
            vpceConfigurationArns(model.vpceConfigurationArns);
            customerArtifactPaths(model.customerArtifactPaths);
            radios(model.radios);
            auxiliaryApps(model.auxiliaryApps);
            billingMethod(model.billingMethod);
        }

        public final String getExtraDataPackageArn() {
            return extraDataPackageArn;
        }

        public final void setExtraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
        }

        @Override
        public final Builder extraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
            return this;
        }

        public final String getNetworkProfileArn() {
            return networkProfileArn;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final Collection<String> getVpceConfigurationArns() {
            if (vpceConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return vpceConfigurationArns;
        }

        public final void setVpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
        }

        @Override
        public final Builder vpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurationArns(String... vpceConfigurationArns) {
            vpceConfigurationArns(Arrays.asList(vpceConfigurationArns));
            return this;
        }

        public final CustomerArtifactPaths.Builder getCustomerArtifactPaths() {
            return customerArtifactPaths != null ? customerArtifactPaths.toBuilder() : null;
        }

        public final void setCustomerArtifactPaths(CustomerArtifactPaths.BuilderImpl customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths != null ? customerArtifactPaths.build() : null;
        }

        @Override
        public final Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths;
            return this;
        }

        public final Radios.Builder getRadios() {
            return radios != null ? radios.toBuilder() : null;
        }

        public final void setRadios(Radios.BuilderImpl radios) {
            this.radios = radios != null ? radios.build() : null;
        }

        @Override
        public final Builder radios(Radios radios) {
            this.radios = radios;
            return this;
        }

        public final Collection<String> getAuxiliaryApps() {
            if (auxiliaryApps instanceof SdkAutoConstructList) {
                return null;
            }
            return auxiliaryApps;
        }

        public final void setAuxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
        }

        @Override
        public final Builder auxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auxiliaryApps(String... auxiliaryApps) {
            auxiliaryApps(Arrays.asList(auxiliaryApps));
            return this;
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod == null ? null : billingMethod.toString());
            return this;
        }

        @Override
        public ScheduleRunConfiguration build() {
            return new ScheduleRunConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
