/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the update device pool operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDevicePoolRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<UpdateDevicePoolRequest.Builder, UpdateDevicePoolRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateDevicePoolRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDevicePoolRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDevicePoolRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(UpdateDevicePoolRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_DEVICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxDevices").getter(getter(UpdateDevicePoolRequest::maxDevices)).setter(setter(Builder::maxDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDevices").build()).build();

    private static final SdkField<Boolean> CLEAR_MAX_DEVICES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("clearMaxDevices").getter(getter(UpdateDevicePoolRequest::clearMaxDevices))
            .setter(setter(Builder::clearMaxDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clearMaxDevices").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, RULES_FIELD, MAX_DEVICES_FIELD, CLEAR_MAX_DEVICES_FIELD));

    private final String arn;

    private final String name;

    private final String description;

    private final List<Rule> rules;

    private final Integer maxDevices;

    private final Boolean clearMaxDevices;

    private UpdateDevicePoolRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.rules = builder.rules;
        this.maxDevices = builder.maxDevices;
        this.clearMaxDevices = builder.clearMaxDevices;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Device Farm device pool to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Device Farm device pool to update.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A string that represents the name of the device pool to update.
     * </p>
     * 
     * @return A string that represents the name of the device pool to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the device pool to update.
     * </p>
     * 
     * @return A description of the device pool to update.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your
     * request, the update replaces the existing rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for
     *         your request, the update replaces the existing rules.
     */
    public final List<Rule> rules() {
        return rules;
    }

    /**
     * <p>
     * The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available
     * and that meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices
     * meet these constraints, your device pool might contain fewer devices than the value for this parameter.
     * </p>
     * <p>
     * By specifying the maximum number of devices, you can control the costs that you incur by running tests.
     * </p>
     * <p>
     * If you use this parameter in your request, you cannot use the <code>clearMaxDevices</code> parameter in the same
     * request.
     * </p>
     * 
     * @return The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are
     *         available and that meet the criteria that you assign for the <code>rules</code> parameter. Depending on
     *         how many devices meet these constraints, your device pool might contain fewer devices than the value for
     *         this parameter.</p>
     *         <p>
     *         By specifying the maximum number of devices, you can control the costs that you incur by running tests.
     *         </p>
     *         <p>
     *         If you use this parameter in your request, you cannot use the <code>clearMaxDevices</code> parameter in
     *         the same request.
     */
    public final Integer maxDevices() {
        return maxDevices;
    }

    /**
     * <p>
     * Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this parameter to
     * <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm does not limit the
     * number of devices that it adds to your device pool. In this case, Device Farm adds all available devices that
     * meet the criteria specified in the <code>rules</code> parameter.
     * </p>
     * <p>
     * If you use this parameter in your request, you cannot use the <code>maxDevices</code> parameter in the same
     * request.
     * </p>
     * 
     * @return Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this parameter
     *         to <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm does not
     *         limit the number of devices that it adds to your device pool. In this case, Device Farm adds all
     *         available devices that meet the criteria specified in the <code>rules</code> parameter.</p>
     *         <p>
     *         If you use this parameter in your request, you cannot use the <code>maxDevices</code> parameter in the
     *         same request.
     */
    public final Boolean clearMaxDevices() {
        return clearMaxDevices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxDevices());
        hashCode = 31 * hashCode + Objects.hashCode(clearMaxDevices());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDevicePoolRequest)) {
            return false;
        }
        UpdateDevicePoolRequest other = (UpdateDevicePoolRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && Objects.equals(maxDevices(), other.maxDevices())
                && Objects.equals(clearMaxDevices(), other.clearMaxDevices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDevicePoolRequest").add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("Rules", hasRules() ? rules() : null).add("MaxDevices", maxDevices())
                .add("ClearMaxDevices", clearMaxDevices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "maxDevices":
            return Optional.ofNullable(clazz.cast(maxDevices()));
        case "clearMaxDevices":
            return Optional.ofNullable(clazz.cast(clearMaxDevices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDevicePoolRequest, T> g) {
        return obj -> g.apply((UpdateDevicePoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDevicePoolRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Device Farm device pool to update.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Device Farm device pool to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A string that represents the name of the device pool to update.
         * </p>
         * 
         * @param name
         *        A string that represents the name of the device pool to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the device pool to update.
         * </p>
         * 
         * @param description
         *        A description of the device pool to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your
         * request, the update replaces the existing rules.
         * </p>
         * 
         * @param rules
         *        Represents the rules to modify for the device pool. Updating rules is optional. If you update rules
         *        for your request, the update replaces the existing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your
         * request, the update replaces the existing rules.
         * </p>
         * 
         * @param rules
         *        Represents the rules to modify for the device pool. Updating rules is optional. If you update rules
         *        for your request, the update replaces the existing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your
         * request, the update replaces the existing rules.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Rule>.Builder} avoiding the need to
         * create one manually via {@link List<Rule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Rule>.Builder#build()} is called immediately and its result
         * is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<Rule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);

        /**
         * <p>
         * The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are
         * available and that meet the criteria that you assign for the <code>rules</code> parameter. Depending on how
         * many devices meet these constraints, your device pool might contain fewer devices than the value for this
         * parameter.
         * </p>
         * <p>
         * By specifying the maximum number of devices, you can control the costs that you incur by running tests.
         * </p>
         * <p>
         * If you use this parameter in your request, you cannot use the <code>clearMaxDevices</code> parameter in the
         * same request.
         * </p>
         * 
         * @param maxDevices
         *        The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are
         *        available and that meet the criteria that you assign for the <code>rules</code> parameter. Depending
         *        on how many devices meet these constraints, your device pool might contain fewer devices than the
         *        value for this parameter.</p>
         *        <p>
         *        By specifying the maximum number of devices, you can control the costs that you incur by running
         *        tests.
         *        </p>
         *        <p>
         *        If you use this parameter in your request, you cannot use the <code>clearMaxDevices</code> parameter
         *        in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDevices(Integer maxDevices);

        /**
         * <p>
         * Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this parameter to
         * <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm does not limit the
         * number of devices that it adds to your device pool. In this case, Device Farm adds all available devices that
         * meet the criteria specified in the <code>rules</code> parameter.
         * </p>
         * <p>
         * If you use this parameter in your request, you cannot use the <code>maxDevices</code> parameter in the same
         * request.
         * </p>
         * 
         * @param clearMaxDevices
         *        Sets whether the <code>maxDevices</code> parameter applies to your device pool. If you set this
         *        parameter to <code>true</code>, the <code>maxDevices</code> parameter does not apply, and Device Farm
         *        does not limit the number of devices that it adds to your device pool. In this case, Device Farm adds
         *        all available devices that meet the criteria specified in the <code>rules</code> parameter.</p>
         *        <p>
         *        If you use this parameter in your request, you cannot use the <code>maxDevices</code> parameter in the
         *        same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clearMaxDevices(Boolean clearMaxDevices);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private Integer maxDevices;

        private Boolean clearMaxDevices;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDevicePoolRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            rules(model.rules);
            maxDevices(model.maxDevices);
            clearMaxDevices(model.clearMaxDevices);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxDevices() {
            return maxDevices;
        }

        public final void setMaxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
        }

        @Override
        public final Builder maxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
            return this;
        }

        public final Boolean getClearMaxDevices() {
            return clearMaxDevices;
        }

        public final void setClearMaxDevices(Boolean clearMaxDevices) {
            this.clearMaxDevices = clearMaxDevices;
        }

        @Override
        public final Builder clearMaxDevices(Boolean clearMaxDevices) {
            this.clearMaxDevices = clearMaxDevices;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDevicePoolRequest build() {
            return new UpdateDevicePoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
