/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the transaction log of the specified offerings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOfferingTransactionsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListOfferingTransactionsResponse.Builder, ListOfferingTransactionsResponse> {
    private static final SdkField<List<OfferingTransaction>> OFFERING_TRANSACTIONS_FIELD = SdkField
            .<List<OfferingTransaction>> builder(MarshallingType.LIST)
            .memberName("offeringTransactions")
            .getter(getter(ListOfferingTransactionsResponse::offeringTransactions))
            .setter(setter(Builder::offeringTransactions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringTransactions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OfferingTransaction> builder(MarshallingType.SDK_POJO)
                                            .constructor(OfferingTransaction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListOfferingTransactionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_TRANSACTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<OfferingTransaction> offeringTransactions;

    private final String nextToken;

    private ListOfferingTransactionsResponse(BuilderImpl builder) {
        super(builder);
        this.offeringTransactions = builder.offeringTransactions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OfferingTransactions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOfferingTransactions() {
        return offeringTransactions != null && !(offeringTransactions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The audit log of subscriptions you have purchased and modified through AWS Device Farm.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOfferingTransactions} method.
     * </p>
     * 
     * @return The audit log of subscriptions you have purchased and modified through AWS Device Farm.
     */
    public final List<OfferingTransaction> offeringTransactions() {
        return offeringTransactions;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOfferingTransactions() ? offeringTransactions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingTransactionsResponse)) {
            return false;
        }
        ListOfferingTransactionsResponse other = (ListOfferingTransactionsResponse) obj;
        return hasOfferingTransactions() == other.hasOfferingTransactions()
                && Objects.equals(offeringTransactions(), other.offeringTransactions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOfferingTransactionsResponse")
                .add("OfferingTransactions", hasOfferingTransactions() ? offeringTransactions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringTransactions":
            return Optional.ofNullable(clazz.cast(offeringTransactions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOfferingTransactionsResponse, T> g) {
        return obj -> g.apply((ListOfferingTransactionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOfferingTransactionsResponse> {
        /**
         * <p>
         * The audit log of subscriptions you have purchased and modified through AWS Device Farm.
         * </p>
         * 
         * @param offeringTransactions
         *        The audit log of subscriptions you have purchased and modified through AWS Device Farm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringTransactions(Collection<OfferingTransaction> offeringTransactions);

        /**
         * <p>
         * The audit log of subscriptions you have purchased and modified through AWS Device Farm.
         * </p>
         * 
         * @param offeringTransactions
         *        The audit log of subscriptions you have purchased and modified through AWS Device Farm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringTransactions(OfferingTransaction... offeringTransactions);

        /**
         * <p>
         * The audit log of subscriptions you have purchased and modified through AWS Device Farm.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<OfferingTransaction>.Builder}
         * avoiding the need to create one manually via {@link List<OfferingTransaction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OfferingTransaction>.Builder#build()} is called immediately
         * and its result is passed to {@link #offeringTransactions(List<OfferingTransaction>)}.
         * 
         * @param offeringTransactions
         *        a consumer that will call methods on {@link List<OfferingTransaction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offeringTransactions(List<OfferingTransaction>)
         */
        Builder offeringTransactions(Consumer<OfferingTransaction.Builder>... offeringTransactions);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<OfferingTransaction> offeringTransactions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingTransactionsResponse model) {
            super(model);
            offeringTransactions(model.offeringTransactions);
            nextToken(model.nextToken);
        }

        public final List<OfferingTransaction.Builder> getOfferingTransactions() {
            List<OfferingTransaction.Builder> result = OfferingTransactionsCopier.copyToBuilder(this.offeringTransactions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOfferingTransactions(Collection<OfferingTransaction.BuilderImpl> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copyFromBuilder(offeringTransactions);
        }

        @Override
        public final Builder offeringTransactions(Collection<OfferingTransaction> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copy(offeringTransactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringTransactions(OfferingTransaction... offeringTransactions) {
            offeringTransactions(Arrays.asList(offeringTransactions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringTransactions(Consumer<OfferingTransaction.Builder>... offeringTransactions) {
            offeringTransactions(Stream.of(offeringTransactions).map(c -> OfferingTransaction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOfferingTransactionsResponse build() {
            return new ListOfferingTransactionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
