/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.TestGridVpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTestGridProjectRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, UpdateTestGridProjectRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(UpdateTestGridProjectRequest.getter(UpdateTestGridProjectRequest::projectArn)).setter(UpdateTestGridProjectRequest.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateTestGridProjectRequest.getter(UpdateTestGridProjectRequest::name)).setter(UpdateTestGridProjectRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateTestGridProjectRequest.getter(UpdateTestGridProjectRequest::description)).setter(UpdateTestGridProjectRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TestGridVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(UpdateTestGridProjectRequest.getter(UpdateTestGridProjectRequest::vpcConfig)).setter(UpdateTestGridProjectRequest.setter(Builder::vpcConfig)).constructor(TestGridVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, VPC_CONFIG_FIELD));
    private final String projectArn;
    private final String name;
    private final String description;
    private final TestGridVpcConfig vpcConfig;

    private UpdateTestGridProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.description = builder.description;
        this.vpcConfig = builder.vpcConfig;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final TestGridVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestGridProjectRequest)) {
            return false;
        }
        UpdateTestGridProjectRequest other = (UpdateTestGridProjectRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTestGridProjectRequest").add("ProjectArn", (Object)this.projectArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTestGridProjectRequest, T> g) {
        return obj -> g.apply((UpdateTestGridProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String name;
        private String description;
        private TestGridVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTestGridProjectRequest model) {
            super(model);
            this.projectArn(model.projectArn);
            this.name(model.name);
            this.description(model.description);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TestGridVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(TestGridVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(TestGridVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTestGridProjectRequest build() {
            return new UpdateTestGridProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTestGridProjectRequest> {
        public Builder projectArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder vpcConfig(TestGridVpcConfig var1);

        default public Builder vpcConfig(Consumer<TestGridVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((TestGridVpcConfig)((TestGridVpcConfig.Builder)TestGridVpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

