/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get upload request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUploadResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetUploadResponse.Builder, GetUploadResponse> {
    private static final SdkField<Upload> UPLOAD_FIELD = SdkField.<Upload> builder(MarshallingType.SDK_POJO).memberName("upload")
            .getter(getter(GetUploadResponse::upload)).setter(setter(Builder::upload)).constructor(Upload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_FIELD));

    private final Upload upload;

    private GetUploadResponse(BuilderImpl builder) {
        super(builder);
        this.upload = builder.upload;
    }

    /**
     * <p>
     * An app or a set of one or more tests to upload or that have been uploaded.
     * </p>
     * 
     * @return An app or a set of one or more tests to upload or that have been uploaded.
     */
    public final Upload upload() {
        return upload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(upload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUploadResponse)) {
            return false;
        }
        GetUploadResponse other = (GetUploadResponse) obj;
        return Objects.equals(upload(), other.upload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUploadResponse").add("Upload", upload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "upload":
            return Optional.ofNullable(clazz.cast(upload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUploadResponse, T> g) {
        return obj -> g.apply((GetUploadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUploadResponse> {
        /**
         * <p>
         * An app or a set of one or more tests to upload or that have been uploaded.
         * </p>
         * 
         * @param upload
         *        An app or a set of one or more tests to upload or that have been uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upload(Upload upload);

        /**
         * <p>
         * An app or a set of one or more tests to upload or that have been uploaded.
         * </p>
         * This is a convenience method that creates an instance of the {@link Upload.Builder} avoiding the need to
         * create one manually via {@link Upload#builder()}.
         *
         * When the {@link Consumer} completes, {@link Upload.Builder#build()} is called immediately and its result is
         * passed to {@link #upload(Upload)}.
         * 
         * @param upload
         *        a consumer that will call methods on {@link Upload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upload(Upload)
         */
        default Builder upload(Consumer<Upload.Builder> upload) {
            return upload(Upload.builder().applyMutation(upload).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Upload upload;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUploadResponse model) {
            super(model);
            upload(model.upload);
        }

        public final Upload.Builder getUpload() {
            return upload != null ? upload.toBuilder() : null;
        }

        public final void setUpload(Upload.BuilderImpl upload) {
            this.upload = upload != null ? upload.build() : null;
        }

        @Override
        public final Builder upload(Upload upload) {
            this.upload = upload;
            return this;
        }

        @Override
        public GetUploadResponse build() {
            return new GetUploadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
