/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NetworkProfileType {
    CURATED("CURATED"),
    PRIVATE("PRIVATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NetworkProfileType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkProfileType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NetworkProfileType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkProfileType> knownValues() {
        return Stream.of(NetworkProfileType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

