/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteRunRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteRunResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceRequest;
import software.amazon.awssdk.services.devicefarm.model.GetDeviceResponse;
import software.amazon.awssdk.services.devicefarm.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.GetJobRequest;
import software.amazon.awssdk.services.devicefarm.model.GetJobResponse;
import software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse;
import software.amazon.awssdk.services.devicefarm.model.GetProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.GetProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.GetRunRequest;
import software.amazon.awssdk.services.devicefarm.model.GetRunResponse;
import software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest;
import software.amazon.awssdk.services.devicefarm.model.GetSuiteResponse;
import software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.GetTestRequest;
import software.amazon.awssdk.services.devicefarm.model.GetTestResponse;
import software.amazon.awssdk.services.devicefarm.model.GetUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.GetUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListJobsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListJobsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListRunsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRunsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListTestsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse;
import software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse;
import software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest;
import software.amazon.awssdk.services.devicefarm.model.RenewOfferingResponse;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunResponse;
import software.amazon.awssdk.services.devicefarm.model.StopJobRequest;
import software.amazon.awssdk.services.devicefarm.model.StopJobResponse;
import software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest;
import software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionResponse;
import software.amazon.awssdk.services.devicefarm.model.StopRunRequest;
import software.amazon.awssdk.services.devicefarm.model.StopRunResponse;
import software.amazon.awssdk.services.devicefarm.model.TagResourceRequest;
import software.amazon.awssdk.services.devicefarm.model.TagResourceResponse;
import software.amazon.awssdk.services.devicefarm.model.UntagResourceRequest;
import software.amazon.awssdk.services.devicefarm.model.UntagResourceResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateUploadRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateUploadResponse;
import software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest;
import software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationResponse;
import software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListRunsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListSamplesPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListSuitesPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestGridProjectsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionActionsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionArtifactsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListTestsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsPublisher;
import software.amazon.awssdk.services.devicefarm.paginators.ListUploadsPublisher;

/**
 * Service client for accessing AWS Device Farm asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Welcome to the AWS Device Farm API documentation, which contains APIs for:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Testing on desktop browsers
 * </p>
 * <p>
 * Device Farm makes it possible for you to test your web applications on desktop browsers using Selenium. The APIs for
 * desktop browser testing contain <code>TestGrid</code> in their names. For more information, see <a
 * href="https://docs.aws.amazon.com/devicefarm/latest/testgrid/">Testing Web Applications on Selenium with Device
 * Farm</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Testing on real mobile devices
 * </p>
 * <p>
 * Device Farm makes it possible for you to test apps on physical phones, tablets, and other devices in the cloud. For
 * more information, see the <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/">Device Farm
 * Developer Guide</a>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DeviceFarmAsyncClient extends AwsClient {
    String SERVICE_NAME = "devicefarm";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "devicefarm";

    /**
     * <p>
     * Creates a device pool.
     * </p>
     *
     * @param createDevicePoolRequest
     *        Represents a request to the create device pool operation.
     * @return A Java Future containing the result of the CreateDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDevicePoolResponse> createDevicePool(CreateDevicePoolRequest createDevicePoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a device pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDevicePoolRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDevicePoolRequest#builder()}
     * </p>
     *
     * @param createDevicePoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.CreateDevicePoolRequest.Builder} to create a
     *        request. Represents a request to the create device pool operation.
     * @return A Java Future containing the result of the CreateDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDevicePoolResponse> createDevicePool(
            Consumer<CreateDevicePoolRequest.Builder> createDevicePoolRequest) {
        return createDevicePool(CreateDevicePoolRequest.builder().applyMutation(createDevicePoolRequest).build());
    }

    /**
     * <p>
     * Creates a profile that can be applied to one or more private fleet device instances.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return A Java Future containing the result of the CreateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstanceProfileResponse> createInstanceProfile(
            CreateInstanceProfileRequest createInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a profile that can be applied to one or more private fleet device instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInstanceProfileRequest#builder()}
     * </p>
     *
     * @param createInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.CreateInstanceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInstanceProfileResponse> createInstanceProfile(
            Consumer<CreateInstanceProfileRequest.Builder> createInstanceProfileRequest) {
        return createInstanceProfile(CreateInstanceProfileRequest.builder().applyMutation(createInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Creates a network profile.
     * </p>
     *
     * @param createNetworkProfileRequest
     * @return A Java Future containing the result of the CreateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkProfileResponse> createNetworkProfile(
            CreateNetworkProfileRequest createNetworkProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkProfileRequest#builder()}
     * </p>
     *
     * @param createNetworkProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.CreateNetworkProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkProfileResponse> createNetworkProfile(
            Consumer<CreateNetworkProfileRequest.Builder> createNetworkProfileRequest) {
        return createNetworkProfile(CreateNetworkProfileRequest.builder().applyMutation(createNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Creates a project.
     * </p>
     *
     * @param createProjectRequest
     *        Represents a request to the create project operation.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>TagOperationException The operation was not successful. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.CreateProjectRequest.Builder} to create a request.
     *        Represents a request to the create project operation.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>TagOperationException The operation was not successful. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Specifies and starts a remote access session.
     * </p>
     *
     * @param createRemoteAccessSessionRequest
     *        Creates and submits a request to start a remote access session.
     * @return A Java Future containing the result of the CreateRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRemoteAccessSessionResponse> createRemoteAccessSession(
            CreateRemoteAccessSessionRequest createRemoteAccessSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies and starts a remote access session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRemoteAccessSessionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param createRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest.Builder} to
     *        create a request. Creates and submits a request to start a remote access session.
     * @return A Java Future containing the result of the CreateRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRemoteAccessSessionResponse> createRemoteAccessSession(
            Consumer<CreateRemoteAccessSessionRequest.Builder> createRemoteAccessSessionRequest) {
        return createRemoteAccessSession(CreateRemoteAccessSessionRequest.builder()
                .applyMutation(createRemoteAccessSessionRequest).build());
    }

    /**
     * <p>
     * Creates a Selenium testing project. Projects are used to track <a>TestGridSession</a> instances.
     * </p>
     *
     * @param createTestGridProjectRequest
     * @return A Java Future containing the result of the CreateTestGridProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTestGridProjectResponse> createTestGridProject(
            CreateTestGridProjectRequest createTestGridProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Selenium testing project. Projects are used to track <a>TestGridSession</a> instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTestGridProjectRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTestGridProjectRequest#builder()}
     * </p>
     *
     * @param createTestGridProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.CreateTestGridProjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTestGridProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTestGridProjectResponse> createTestGridProject(
            Consumer<CreateTestGridProjectRequest.Builder> createTestGridProjectRequest) {
        return createTestGridProject(CreateTestGridProjectRequest.builder().applyMutation(createTestGridProjectRequest).build());
    }

    /**
     * <p>
     * Creates a signed, short-term URL that can be passed to a Selenium <code>RemoteWebDriver</code> constructor.
     * </p>
     *
     * @param createTestGridUrlRequest
     * @return A Java Future containing the result of the CreateTestGridUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateTestGridUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTestGridUrlResponse> createTestGridUrl(CreateTestGridUrlRequest createTestGridUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a signed, short-term URL that can be passed to a Selenium <code>RemoteWebDriver</code> constructor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTestGridUrlRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTestGridUrlRequest#builder()}
     * </p>
     *
     * @param createTestGridUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.CreateTestGridUrlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTestGridUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateTestGridUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateTestGridUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTestGridUrlResponse> createTestGridUrl(
            Consumer<CreateTestGridUrlRequest.Builder> createTestGridUrlRequest) {
        return createTestGridUrl(CreateTestGridUrlRequest.builder().applyMutation(createTestGridUrlRequest).build());
    }

    /**
     * <p>
     * Uploads an app or test scripts.
     * </p>
     *
     * @param createUploadRequest
     *        Represents a request to the create upload operation.
     * @return A Java Future containing the result of the CreateUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUploadResponse> createUpload(CreateUploadRequest createUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads an app or test scripts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUploadRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUploadRequest#builder()}
     * </p>
     *
     * @param createUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.CreateUploadRequest.Builder} to create a request.
     *        Represents a request to the create upload operation.
     * @return A Java Future containing the result of the CreateUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUploadResponse> createUpload(Consumer<CreateUploadRequest.Builder> createUploadRequest) {
        return createUpload(CreateUploadRequest.builder().applyMutation(createUploadRequest).build());
    }

    /**
     * <p>
     * Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     *
     * @param createVpceConfigurationRequest
     * @return A Java Future containing the result of the CreateVPCEConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpceConfigurationResponse> createVPCEConfiguration(
            CreateVpceConfigurationRequest createVpceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpceConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVpceConfigurationRequest#builder()}
     * </p>
     *
     * @param createVpceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateVPCEConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.CreateVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpceConfigurationResponse> createVPCEConfiguration(
            Consumer<CreateVpceConfigurationRequest.Builder> createVpceConfigurationRequest) {
        return createVPCEConfiguration(CreateVpceConfigurationRequest.builder().applyMutation(createVpceConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.
     * </p>
     *
     * @param deleteDevicePoolRequest
     *        Represents a request to the delete device pool operation.
     * @return A Java Future containing the result of the DeleteDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDevicePoolResponse> deleteDevicePool(DeleteDevicePoolRequest deleteDevicePoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDevicePoolRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDevicePoolRequest#builder()}
     * </p>
     *
     * @param deleteDevicePoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.DeleteDevicePoolRequest.Builder} to create a
     *        request. Represents a request to the delete device pool operation.
     * @return A Java Future containing the result of the DeleteDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDevicePoolResponse> deleteDevicePool(
            Consumer<DeleteDevicePoolRequest.Builder> deleteDevicePoolRequest) {
        return deleteDevicePool(DeleteDevicePoolRequest.builder().applyMutation(deleteDevicePoolRequest).build());
    }

    /**
     * <p>
     * Deletes a profile that can be applied to one or more private device instances.
     * </p>
     *
     * @param deleteInstanceProfileRequest
     * @return A Java Future containing the result of the DeleteInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceProfileResponse> deleteInstanceProfile(
            DeleteInstanceProfileRequest deleteInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a profile that can be applied to one or more private device instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInstanceProfileRequest#builder()}
     * </p>
     *
     * @param deleteInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.DeleteInstanceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInstanceProfileResponse> deleteInstanceProfile(
            Consumer<DeleteInstanceProfileRequest.Builder> deleteInstanceProfileRequest) {
        return deleteInstanceProfile(DeleteInstanceProfileRequest.builder().applyMutation(deleteInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a network profile.
     * </p>
     *
     * @param deleteNetworkProfileRequest
     * @return A Java Future containing the result of the DeleteNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkProfileResponse> deleteNetworkProfile(
            DeleteNetworkProfileRequest deleteNetworkProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a network profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkProfileRequest#builder()}
     * </p>
     *
     * @param deleteNetworkProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.DeleteNetworkProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkProfileResponse> deleteNetworkProfile(
            Consumer<DeleteNetworkProfileRequest.Builder> deleteNetworkProfileRequest) {
        return deleteNetworkProfile(DeleteNetworkProfileRequest.builder().applyMutation(deleteNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Deletes an AWS Device Farm project, given the project ARN.
     * </p>
     * <p>
     * Deleting this resource does not stop an in-progress run.
     * </p>
     *
     * @param deleteProjectRequest
     *        Represents a request to the delete project operation.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Device Farm project, given the project ARN.
     * </p>
     * <p>
     * Deleting this resource does not stop an in-progress run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.DeleteProjectRequest.Builder} to create a request.
     *        Represents a request to the delete project operation.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Deletes a completed remote access session and its results.
     * </p>
     *
     * @param deleteRemoteAccessSessionRequest
     *        Represents the request to delete the specified remote access session.
     * @return A Java Future containing the result of the DeleteRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemoteAccessSessionResponse> deleteRemoteAccessSession(
            DeleteRemoteAccessSessionRequest deleteRemoteAccessSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a completed remote access session and its results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRemoteAccessSessionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param deleteRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.DeleteRemoteAccessSessionRequest.Builder} to
     *        create a request. Represents the request to delete the specified remote access session.
     * @return A Java Future containing the result of the DeleteRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRemoteAccessSessionResponse> deleteRemoteAccessSession(
            Consumer<DeleteRemoteAccessSessionRequest.Builder> deleteRemoteAccessSessionRequest) {
        return deleteRemoteAccessSession(DeleteRemoteAccessSessionRequest.builder()
                .applyMutation(deleteRemoteAccessSessionRequest).build());
    }

    /**
     * <p>
     * Deletes the run, given the run ARN.
     * </p>
     * <p>
     * Deleting this resource does not stop an in-progress run.
     * </p>
     *
     * @param deleteRunRequest
     *        Represents a request to the delete run operation.
     * @return A Java Future containing the result of the DeleteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunResponse> deleteRun(DeleteRunRequest deleteRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the run, given the run ARN.
     * </p>
     * <p>
     * Deleting this resource does not stop an in-progress run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRunRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRunRequest#builder()}
     * </p>
     *
     * @param deleteRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.DeleteRunRequest.Builder} to create a request.
     *        Represents a request to the delete run operation.
     * @return A Java Future containing the result of the DeleteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunResponse> deleteRun(Consumer<DeleteRunRequest.Builder> deleteRunRequest) {
        return deleteRun(DeleteRunRequest.builder().applyMutation(deleteRunRequest).build());
    }

    /**
     * <p>
     * Deletes a Selenium testing project and all content generated under it.
     * </p>
     * <important>
     * <p>
     * You cannot undo this operation.
     * </p>
     * </important> <note>
     * <p>
     * You cannot delete a project if it has active sessions.
     * </p>
     * </note>
     *
     * @param deleteTestGridProjectRequest
     * @return A Java Future containing the result of the DeleteTestGridProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>CannotDeleteException The requested object could not be deleted.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteTestGridProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTestGridProjectResponse> deleteTestGridProject(
            DeleteTestGridProjectRequest deleteTestGridProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Selenium testing project and all content generated under it.
     * </p>
     * <important>
     * <p>
     * You cannot undo this operation.
     * </p>
     * </important> <note>
     * <p>
     * You cannot delete a project if it has active sessions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTestGridProjectRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTestGridProjectRequest#builder()}
     * </p>
     *
     * @param deleteTestGridProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.DeleteTestGridProjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTestGridProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>CannotDeleteException The requested object could not be deleted.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteTestGridProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTestGridProjectResponse> deleteTestGridProject(
            Consumer<DeleteTestGridProjectRequest.Builder> deleteTestGridProjectRequest) {
        return deleteTestGridProject(DeleteTestGridProjectRequest.builder().applyMutation(deleteTestGridProjectRequest).build());
    }

    /**
     * <p>
     * Deletes an upload given the upload ARN.
     * </p>
     *
     * @param deleteUploadRequest
     *        Represents a request to the delete upload operation.
     * @return A Java Future containing the result of the DeleteUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUploadResponse> deleteUpload(DeleteUploadRequest deleteUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an upload given the upload ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUploadRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUploadRequest#builder()}
     * </p>
     *
     * @param deleteUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.DeleteUploadRequest.Builder} to create a request.
     *        Represents a request to the delete upload operation.
     * @return A Java Future containing the result of the DeleteUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUploadResponse> deleteUpload(Consumer<DeleteUploadRequest.Builder> deleteUploadRequest) {
        return deleteUpload(DeleteUploadRequest.builder().applyMutation(deleteUploadRequest).build());
    }

    /**
     * <p>
     * Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     *
     * @param deleteVpceConfigurationRequest
     * @return A Java Future containing the result of the DeleteVPCEConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>InvalidOperationException There was an error with the update request, or you do not have sufficient
     *         permissions to update this VPC endpoint configuration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpceConfigurationResponse> deleteVPCEConfiguration(
            DeleteVpceConfigurationRequest deleteVpceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpceConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVpceConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteVpceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.DeleteVpceConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteVPCEConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>InvalidOperationException There was an error with the update request, or you do not have sufficient
     *         permissions to update this VPC endpoint configuration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.DeleteVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpceConfigurationResponse> deleteVPCEConfiguration(
            Consumer<DeleteVpceConfigurationRequest.Builder> deleteVpceConfigurationRequest) {
        return deleteVPCEConfiguration(DeleteVpceConfigurationRequest.builder().applyMutation(deleteVpceConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Returns the number of unmetered iOS or unmetered Android devices that have been purchased by the account.
     * </p>
     *
     * @param getAccountSettingsRequest
     *        Represents the request sent to retrieve the account settings.
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of unmetered iOS or unmetered Android devices that have been purchased by the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetAccountSettingsRequest.Builder} to create a
     *        request. Represents the request sent to retrieve the account settings.
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(
            Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest) {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Returns the number of unmetered iOS or unmetered Android devices that have been purchased by the account.
     * </p>
     *
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings() {
        return getAccountSettings(GetAccountSettingsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about a unique device type.
     * </p>
     *
     * @param getDeviceRequest
     *        Represents a request to the get device request.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a unique device type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeviceRequest#builder()}
     * </p>
     *
     * @param getDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetDeviceRequest.Builder} to create a request.
     *        Represents a request to the get device request.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceResponse> getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) {
        return getDevice(GetDeviceRequest.builder().applyMutation(getDeviceRequest).build());
    }

    /**
     * <p>
     * Returns information about a device instance that belongs to a private device fleet.
     * </p>
     *
     * @param getDeviceInstanceRequest
     * @return A Java Future containing the result of the GetDeviceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDeviceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDeviceInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeviceInstanceResponse> getDeviceInstance(GetDeviceInstanceRequest getDeviceInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a device instance that belongs to a private device fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetDeviceInstanceRequest#builder()}
     * </p>
     *
     * @param getDeviceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetDeviceInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeviceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDeviceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDeviceInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeviceInstanceResponse> getDeviceInstance(
            Consumer<GetDeviceInstanceRequest.Builder> getDeviceInstanceRequest) {
        return getDeviceInstance(GetDeviceInstanceRequest.builder().applyMutation(getDeviceInstanceRequest).build());
    }

    /**
     * <p>
     * Gets information about a device pool.
     * </p>
     *
     * @param getDevicePoolRequest
     *        Represents a request to the get device pool operation.
     * @return A Java Future containing the result of the GetDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDevicePoolResponse> getDevicePool(GetDevicePoolRequest getDevicePoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a device pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePoolRequest.Builder} avoiding the need to
     * create one manually via {@link GetDevicePoolRequest#builder()}
     * </p>
     *
     * @param getDevicePoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetDevicePoolRequest.Builder} to create a request.
     *        Represents a request to the get device pool operation.
     * @return A Java Future containing the result of the GetDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDevicePoolResponse> getDevicePool(Consumer<GetDevicePoolRequest.Builder> getDevicePoolRequest) {
        return getDevicePool(GetDevicePoolRequest.builder().applyMutation(getDevicePoolRequest).build());
    }

    /**
     * <p>
     * Gets information about compatibility with a device pool.
     * </p>
     *
     * @param getDevicePoolCompatibilityRequest
     *        Represents a request to the get device pool compatibility operation.
     * @return A Java Future containing the result of the GetDevicePoolCompatibility operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDevicePoolCompatibility
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDevicePoolCompatibilityResponse> getDevicePoolCompatibility(
            GetDevicePoolCompatibilityRequest getDevicePoolCompatibilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about compatibility with a device pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicePoolCompatibilityRequest.Builder} avoiding
     * the need to create one manually via {@link GetDevicePoolCompatibilityRequest#builder()}
     * </p>
     *
     * @param getDevicePoolCompatibilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetDevicePoolCompatibilityRequest.Builder} to
     *        create a request. Represents a request to the get device pool compatibility operation.
     * @return A Java Future containing the result of the GetDevicePoolCompatibility operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetDevicePoolCompatibility
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDevicePoolCompatibilityResponse> getDevicePoolCompatibility(
            Consumer<GetDevicePoolCompatibilityRequest.Builder> getDevicePoolCompatibilityRequest) {
        return getDevicePoolCompatibility(GetDevicePoolCompatibilityRequest.builder()
                .applyMutation(getDevicePoolCompatibilityRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified instance profile.
     * </p>
     *
     * @param getInstanceProfileRequest
     * @return A Java Future containing the result of the GetInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceProfileResponse> getInstanceProfile(GetInstanceProfileRequest getInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified instance profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetInstanceProfileRequest#builder()}
     * </p>
     *
     * @param getInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetInstanceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceProfileResponse> getInstanceProfile(
            Consumer<GetInstanceProfileRequest.Builder> getInstanceProfileRequest) {
        return getInstanceProfile(GetInstanceProfileRequest.builder().applyMutation(getInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Gets information about a job.
     * </p>
     *
     * @param getJobRequest
     *        Represents a request to the get job operation.
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobResponse> getJob(GetJobRequest getJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetJobRequest.Builder} to create a request.
     *        Represents a request to the get job operation.
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobResponse> getJob(Consumer<GetJobRequest.Builder> getJobRequest) {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a network profile.
     * </p>
     *
     * @param getNetworkProfileRequest
     * @return A Java Future containing the result of the GetNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetNetworkProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNetworkProfileResponse> getNetworkProfile(GetNetworkProfileRequest getNetworkProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a network profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetNetworkProfileRequest#builder()}
     * </p>
     *
     * @param getNetworkProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetNetworkProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetNetworkProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNetworkProfileResponse> getNetworkProfile(
            Consumer<GetNetworkProfileRequest.Builder> getNetworkProfileRequest) {
        return getNetworkProfile(GetNetworkProfileRequest.builder().applyMutation(getNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be
     * able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param getOfferingStatusRequest
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return A Java Future containing the result of the GetOfferingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetOfferingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOfferingStatusResponse> getOfferingStatus(GetOfferingStatusRequest getOfferingStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be
     * able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOfferingStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetOfferingStatusRequest#builder()}
     * </p>
     *
     * @param getOfferingStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest.Builder} to create a
     *        request. Represents the request to retrieve the offering status for the specified customer or account.
     * @return A Java Future containing the result of the GetOfferingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetOfferingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOfferingStatusResponse> getOfferingStatus(
            Consumer<GetOfferingStatusRequest.Builder> getOfferingStatusRequest) {
        return getOfferingStatus(GetOfferingStatusRequest.builder().applyMutation(getOfferingStatusRequest).build());
    }

    /**
     * <p>
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates
     * how many offerings are currently available and the offerings that will be available in the next period. The API
     * returns a <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be
     * able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @return A Java Future containing the result of the GetOfferingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetOfferingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOfferingStatusResponse> getOfferingStatus() {
        return getOfferingStatus(GetOfferingStatusRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher publisher = client.getOfferingStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher publisher = client.getOfferingStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetOfferingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOfferingStatusPublisher getOfferingStatusPaginator() {
        return getOfferingStatusPaginator(GetOfferingStatusRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher publisher = client.getOfferingStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher publisher = client.getOfferingStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOfferingStatusRequest
     *        Represents the request to retrieve the offering status for the specified customer or account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetOfferingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOfferingStatusPublisher getOfferingStatusPaginator(GetOfferingStatusRequest getOfferingStatusRequest) {
        return new GetOfferingStatusPublisher(this, getOfferingStatusRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher publisher = client.getOfferingStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.GetOfferingStatusPublisher publisher = client.getOfferingStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOfferingStatus(software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOfferingStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetOfferingStatusRequest#builder()}
     * </p>
     *
     * @param getOfferingStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest.Builder} to create a
     *        request. Represents the request to retrieve the offering status for the specified customer or account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetOfferingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOfferingStatusPublisher getOfferingStatusPaginator(
            Consumer<GetOfferingStatusRequest.Builder> getOfferingStatusRequest) {
        return getOfferingStatusPaginator(GetOfferingStatusRequest.builder().applyMutation(getOfferingStatusRequest).build());
    }

    /**
     * <p>
     * Gets information about a project.
     * </p>
     *
     * @param getProjectRequest
     *        Represents a request to the get project operation.
     * @return A Java Future containing the result of the GetProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProjectResponse> getProject(GetProjectRequest getProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProjectRequest.Builder} avoiding the need to
     * create one manually via {@link GetProjectRequest#builder()}
     * </p>
     *
     * @param getProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetProjectRequest.Builder} to create a request.
     *        Represents a request to the get project operation.
     * @return A Java Future containing the result of the GetProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProjectResponse> getProject(Consumer<GetProjectRequest.Builder> getProjectRequest) {
        return getProject(GetProjectRequest.builder().applyMutation(getProjectRequest).build());
    }

    /**
     * <p>
     * Returns a link to a currently running remote access session.
     * </p>
     *
     * @param getRemoteAccessSessionRequest
     *        Represents the request to get information about the specified remote access session.
     * @return A Java Future containing the result of the GetRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRemoteAccessSessionResponse> getRemoteAccessSession(
            GetRemoteAccessSessionRequest getRemoteAccessSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a link to a currently running remote access session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRemoteAccessSessionRequest.Builder} avoiding the
     * need to create one manually via {@link GetRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param getRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetRemoteAccessSessionRequest.Builder} to create a
     *        request. Represents the request to get information about the specified remote access session.
     * @return A Java Future containing the result of the GetRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRemoteAccessSessionResponse> getRemoteAccessSession(
            Consumer<GetRemoteAccessSessionRequest.Builder> getRemoteAccessSessionRequest) {
        return getRemoteAccessSession(GetRemoteAccessSessionRequest.builder().applyMutation(getRemoteAccessSessionRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a run.
     * </p>
     *
     * @param getRunRequest
     *        Represents a request to the get run operation.
     * @return A Java Future containing the result of the GetRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunResponse> getRun(GetRunRequest getRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRunRequest.Builder} avoiding the need to create
     * one manually via {@link GetRunRequest#builder()}
     * </p>
     *
     * @param getRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetRunRequest.Builder} to create a request.
     *        Represents a request to the get run operation.
     * @return A Java Future containing the result of the GetRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunResponse> getRun(Consumer<GetRunRequest.Builder> getRunRequest) {
        return getRun(GetRunRequest.builder().applyMutation(getRunRequest).build());
    }

    /**
     * <p>
     * Gets information about a suite.
     * </p>
     *
     * @param getSuiteRequest
     *        Represents a request to the get suite operation.
     * @return A Java Future containing the result of the GetSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSuiteResponse> getSuite(GetSuiteRequest getSuiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a suite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSuiteRequest.Builder} avoiding the need to
     * create one manually via {@link GetSuiteRequest#builder()}
     * </p>
     *
     * @param getSuiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetSuiteRequest.Builder} to create a request.
     *        Represents a request to the get suite operation.
     * @return A Java Future containing the result of the GetSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSuiteResponse> getSuite(Consumer<GetSuiteRequest.Builder> getSuiteRequest) {
        return getSuite(GetSuiteRequest.builder().applyMutation(getSuiteRequest).build());
    }

    /**
     * <p>
     * Gets information about a test.
     * </p>
     *
     * @param getTestRequest
     *        Represents a request to the get test operation.
     * @return A Java Future containing the result of the GetTest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTestResponse> getTest(GetTestRequest getTestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTestRequest.Builder} avoiding the need to create
     * one manually via {@link GetTestRequest#builder()}
     * </p>
     *
     * @param getTestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetTestRequest.Builder} to create a request.
     *        Represents a request to the get test operation.
     * @return A Java Future containing the result of the GetTest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTestResponse> getTest(Consumer<GetTestRequest.Builder> getTestRequest) {
        return getTest(GetTestRequest.builder().applyMutation(getTestRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a Selenium testing project.
     * </p>
     *
     * @param getTestGridProjectRequest
     * @return A Java Future containing the result of the GetTestGridProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTestGridProjectResponse> getTestGridProject(GetTestGridProjectRequest getTestGridProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a Selenium testing project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTestGridProjectRequest.Builder} avoiding the
     * need to create one manually via {@link GetTestGridProjectRequest#builder()}
     * </p>
     *
     * @param getTestGridProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetTestGridProjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTestGridProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTestGridProjectResponse> getTestGridProject(
            Consumer<GetTestGridProjectRequest.Builder> getTestGridProjectRequest) {
        return getTestGridProject(GetTestGridProjectRequest.builder().applyMutation(getTestGridProjectRequest).build());
    }

    /**
     * <p>
     * A session is an instance of a browser created through a <code>RemoteWebDriver</code> with the URL from
     * <a>CreateTestGridUrlResult&#36url</a>. You can use the following to look up sessions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The session ARN (<a>GetTestGridSessionRequest&#36sessionArn</a>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The project ARN and a session ID (<a>GetTestGridSessionRequest&#36projectArn</a> and
     * <a>GetTestGridSessionRequest&#36sessionId</a>).
     * </p>
     * </li>
     * </ul>
     * <p/>
     *
     * @param getTestGridSessionRequest
     * @return A Java Future containing the result of the GetTestGridSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li> <li>ArgumentException An invalid argument
     *         was specified.</li> <li>InternalServiceException An internal exception was raised in the service. Contact
     *         <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service
     *         and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error
     *         occurs such as an IO related failure, failure to get credentials, etc.</li> <li>DeviceFarmException Base
     *         class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetTestGridSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTestGridSessionResponse> getTestGridSession(GetTestGridSessionRequest getTestGridSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A session is an instance of a browser created through a <code>RemoteWebDriver</code> with the URL from
     * <a>CreateTestGridUrlResult&#36url</a>. You can use the following to look up sessions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The session ARN (<a>GetTestGridSessionRequest&#36sessionArn</a>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The project ARN and a session ID (<a>GetTestGridSessionRequest&#36projectArn</a> and
     * <a>GetTestGridSessionRequest&#36sessionId</a>).
     * </p>
     * </li>
     * </ul>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTestGridSessionRequest.Builder} avoiding the
     * need to create one manually via {@link GetTestGridSessionRequest#builder()}
     * </p>
     *
     * @param getTestGridSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetTestGridSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTestGridSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetTestGridSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestGridSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTestGridSessionResponse> getTestGridSession(
            Consumer<GetTestGridSessionRequest.Builder> getTestGridSessionRequest) {
        return getTestGridSession(GetTestGridSessionRequest.builder().applyMutation(getTestGridSessionRequest).build());
    }

    /**
     * <p>
     * Gets information about an upload.
     * </p>
     *
     * @param getUploadRequest
     *        Represents a request to the get upload operation.
     * @return A Java Future containing the result of the GetUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUploadResponse> getUpload(GetUploadRequest getUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an upload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUploadRequest.Builder} avoiding the need to
     * create one manually via {@link GetUploadRequest#builder()}
     * </p>
     *
     * @param getUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetUploadRequest.Builder} to create a request.
     *        Represents a request to the get upload operation.
     * @return A Java Future containing the result of the GetUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUploadResponse> getUpload(Consumer<GetUploadRequest.Builder> getUploadRequest) {
        return getUpload(GetUploadRequest.builder().applyMutation(getUploadRequest).build());
    }

    /**
     * <p>
     * Returns information about the configuration settings for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     *
     * @param getVpceConfigurationRequest
     * @return A Java Future containing the result of the GetVPCEConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVpceConfigurationResponse> getVPCEConfiguration(
            GetVpceConfigurationRequest getVpceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the configuration settings for your Amazon Virtual Private Cloud (VPC) endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpceConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetVpceConfigurationRequest#builder()}
     * </p>
     *
     * @param getVpceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.GetVpceConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVPCEConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.GetVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVpceConfigurationResponse> getVPCEConfiguration(
            Consumer<GetVpceConfigurationRequest.Builder> getVpceConfigurationRequest) {
        return getVPCEConfiguration(GetVpceConfigurationRequest.builder().applyMutation(getVpceConfigurationRequest).build());
    }

    /**
     * <p>
     * Installs an application to the device in a remote access session. For Android applications, the file must be in
     * .apk format. For iOS applications, the file must be in .ipa format.
     * </p>
     *
     * @param installToRemoteAccessSessionRequest
     *        Represents the request to install an Android application (in .apk format) or an iOS application (in .ipa
     *        format) as part of a remote access session.
     * @return A Java Future containing the result of the InstallToRemoteAccessSession operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.InstallToRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InstallToRemoteAccessSessionResponse> installToRemoteAccessSession(
            InstallToRemoteAccessSessionRequest installToRemoteAccessSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Installs an application to the device in a remote access session. For Android applications, the file must be in
     * .apk format. For iOS applications, the file must be in .ipa format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InstallToRemoteAccessSessionRequest.Builder}
     * avoiding the need to create one manually via {@link InstallToRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param installToRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.InstallToRemoteAccessSessionRequest.Builder} to
     *        create a request. Represents the request to install an Android application (in .apk format) or an iOS
     *        application (in .ipa format) as part of a remote access session.
     * @return A Java Future containing the result of the InstallToRemoteAccessSession operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.InstallToRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InstallToRemoteAccessSessionResponse> installToRemoteAccessSession(
            Consumer<InstallToRemoteAccessSessionRequest.Builder> installToRemoteAccessSessionRequest) {
        return installToRemoteAccessSession(InstallToRemoteAccessSessionRequest.builder()
                .applyMutation(installToRemoteAccessSessionRequest).build());
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     *
     * @param listArtifactsRequest
     *        Represents a request to the list artifacts operation.
     * @return A Java Future containing the result of the ListArtifacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListArtifactsResponse> listArtifacts(ListArtifactsRequest listArtifactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArtifactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListArtifactsRequest#builder()}
     * </p>
     *
     * @param listArtifactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest.Builder} to create a request.
     *        Represents a request to the list artifacts operation.
     * @return A Java Future containing the result of the ListArtifacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListArtifactsResponse> listArtifacts(Consumer<ListArtifactsRequest.Builder> listArtifactsRequest) {
        return listArtifacts(ListArtifactsRequest.builder().applyMutation(listArtifactsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsPublisher publisher = client.listArtifactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsPublisher publisher = client.listArtifactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation.</b>
     * </p>
     *
     * @param listArtifactsRequest
     *        Represents a request to the list artifacts operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsPublisher listArtifactsPaginator(ListArtifactsRequest listArtifactsRequest) {
        return new ListArtifactsPublisher(this, listArtifactsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsPublisher publisher = client.listArtifactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListArtifactsPublisher publisher = client.listArtifactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArtifacts(software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArtifactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListArtifactsRequest#builder()}
     * </p>
     *
     * @param listArtifactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest.Builder} to create a request.
     *        Represents a request to the list artifacts operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArtifactsPublisher listArtifactsPaginator(Consumer<ListArtifactsRequest.Builder> listArtifactsRequest) {
        return listArtifactsPaginator(ListArtifactsRequest.builder().applyMutation(listArtifactsRequest).build());
    }

    /**
     * <p>
     * Returns information about the private device instances associated with one or more AWS accounts.
     * </p>
     *
     * @param listDeviceInstancesRequest
     * @return A Java Future containing the result of the ListDeviceInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDeviceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceInstancesResponse> listDeviceInstances(
            ListDeviceInstancesRequest listDeviceInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the private device instances associated with one or more AWS accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceInstancesRequest#builder()}
     * </p>
     *
     * @param listDeviceInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeviceInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDeviceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceInstancesResponse> listDeviceInstances(
            Consumer<ListDeviceInstancesRequest.Builder> listDeviceInstancesRequest) {
        return listDeviceInstances(ListDeviceInstancesRequest.builder().applyMutation(listDeviceInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about the private device instances associated with one or more AWS accounts.
     * </p>
     *
     * @return A Java Future containing the result of the ListDeviceInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDeviceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceInstancesResponse> listDeviceInstances() {
        return listDeviceInstances(ListDeviceInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     *
     * @param listDevicePoolsRequest
     *        Represents the result of a list device pools request.
     * @return A Java Future containing the result of the ListDevicePools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevicePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDevicePoolsResponse> listDevicePools(ListDevicePoolsRequest listDevicePoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about device pools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicePoolsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevicePoolsRequest#builder()}
     * </p>
     *
     * @param listDevicePoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest.Builder} to create a
     *        request. Represents the result of a list device pools request.
     * @return A Java Future containing the result of the ListDevicePools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevicePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDevicePoolsResponse> listDevicePools(
            Consumer<ListDevicePoolsRequest.Builder> listDevicePoolsRequest) {
        return listDevicePools(ListDevicePoolsRequest.builder().applyMutation(listDevicePoolsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsPublisher publisher = client.listDevicePoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsPublisher publisher = client.listDevicePoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation.</b>
     * </p>
     *
     * @param listDevicePoolsRequest
     *        Represents the result of a list device pools request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevicePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDevicePoolsPublisher listDevicePoolsPaginator(ListDevicePoolsRequest listDevicePoolsRequest) {
        return new ListDevicePoolsPublisher(this, listDevicePoolsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsPublisher publisher = client.listDevicePoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicePoolsPublisher publisher = client.listDevicePoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevicePools(software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicePoolsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevicePoolsRequest#builder()}
     * </p>
     *
     * @param listDevicePoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest.Builder} to create a
     *        request. Represents the result of a list device pools request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevicePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDevicePoolsPublisher listDevicePoolsPaginator(Consumer<ListDevicePoolsRequest.Builder> listDevicePoolsRequest) {
        return listDevicePoolsPaginator(ListDevicePoolsRequest.builder().applyMutation(listDevicePoolsRequest).build());
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the result of a list devices request.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest.Builder} to create a request.
     *        Represents the result of a list devices request.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Gets information about unique device types.
     * </p>
     *
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices() {
        return listDevices(ListDevicesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesPublisher listDevicesPaginator() {
        return listDevicesPaginator(ListDevicesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the result of a list devices request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesPublisher listDevicesPaginator(ListDevicesRequest listDevicesRequest) {
        return new ListDevicesPublisher(this, listDevicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest.Builder} to create a request.
     *        Represents the result of a list devices request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesPublisher listDevicesPaginator(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevicesPaginator(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns information about all the instance profiles in an AWS account.
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return A Java Future containing the result of the ListInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceProfilesResponse> listInstanceProfiles(
            ListInstanceProfilesRequest listInstanceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all the instance profiles in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param listInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListInstanceProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceProfilesResponse> listInstanceProfiles(
            Consumer<ListInstanceProfilesRequest.Builder> listInstanceProfilesRequest) {
        return listInstanceProfiles(ListInstanceProfilesRequest.builder().applyMutation(listInstanceProfilesRequest).build());
    }

    /**
     * <p>
     * Returns information about all the instance profiles in an AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListInstanceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceProfilesResponse> listInstanceProfiles() {
        return listInstanceProfiles(ListInstanceProfilesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about jobs for a given test run.
     * </p>
     *
     * @param listJobsRequest
     *        Represents a request to the list jobs operation.
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about jobs for a given test run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListJobsRequest.Builder} to create a request.
     *        Represents a request to the list jobs operation.
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJobsResponse> listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     *        Represents a request to the list jobs operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsPublisher listJobsPaginator(ListJobsRequest listJobsRequest) {
        return new ListJobsPublisher(this, listJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListJobsPublisher publisher = client.listJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.devicefarm.model.ListJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListJobsRequest.Builder} to create a request.
     *        Represents a request to the list jobs operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsPublisher listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Returns the list of available network profiles.
     * </p>
     *
     * @param listNetworkProfilesRequest
     * @return A Java Future containing the result of the ListNetworkProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListNetworkProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkProfilesResponse> listNetworkProfiles(
            ListNetworkProfilesRequest listNetworkProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of available network profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkProfilesRequest#builder()}
     * </p>
     *
     * @param listNetworkProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNetworkProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListNetworkProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkProfilesResponse> listNetworkProfiles(
            Consumer<ListNetworkProfilesRequest.Builder> listNetworkProfilesRequest) {
        return listNetworkProfiles(ListNetworkProfilesRequest.builder().applyMutation(listNetworkProfilesRequest).build());
    }

    /**
     * <p>
     * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the
     * promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke the
     * operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if
     * you must be able to invoke this operation.
     * </p>
     *
     * @param listOfferingPromotionsRequest
     * @return A Java Future containing the result of the ListOfferingPromotions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingPromotions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOfferingPromotionsResponse> listOfferingPromotions(
            ListOfferingPromotionsRequest listOfferingPromotionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the
     * promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke the
     * operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if
     * you must be able to invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingPromotionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOfferingPromotionsRequest#builder()}
     * </p>
     *
     * @param listOfferingPromotionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOfferingPromotions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingPromotions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOfferingPromotionsResponse> listOfferingPromotions(
            Consumer<ListOfferingPromotionsRequest.Builder> listOfferingPromotionsRequest) {
        return listOfferingPromotions(ListOfferingPromotionsRequest.builder().applyMutation(listOfferingPromotionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the
     * promotion. The API returns a <code>NotEligible</code> error if the caller is not permitted to invoke the
     * operation. Contact <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if
     * you must be able to invoke this operation.
     * </p>
     *
     * @return A Java Future containing the result of the ListOfferingPromotions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingPromotions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingPromotions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOfferingPromotionsResponse> listOfferingPromotions() {
        return listOfferingPromotions(ListOfferingPromotionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be able to
     * invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        Represents the request to list the offering transaction history.
     * @return A Java Future containing the result of the ListOfferingTransactions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOfferingTransactionsResponse> listOfferingTransactions(
            ListOfferingTransactionsRequest listOfferingTransactionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be able to
     * invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingTransactionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOfferingTransactionsRequest#builder()}
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest.Builder} to create
     *        a request. Represents the request to list the offering transaction history.
     * @return A Java Future containing the result of the ListOfferingTransactions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOfferingTransactionsResponse> listOfferingTransactions(
            Consumer<ListOfferingTransactionsRequest.Builder> listOfferingTransactionsRequest) {
        return listOfferingTransactions(ListOfferingTransactionsRequest.builder().applyMutation(listOfferingTransactionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The
     * list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a
     * <code>NotEligible</code> error if the user is not permitted to invoke the operation. If you must be able to
     * invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListOfferingTransactions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOfferingTransactionsResponse> listOfferingTransactions() {
        return listOfferingTransactions(ListOfferingTransactionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher publisher = client.listOfferingTransactionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher publisher = client.listOfferingTransactionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingTransactionsPublisher listOfferingTransactionsPaginator() {
        return listOfferingTransactionsPaginator(ListOfferingTransactionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher publisher = client.listOfferingTransactionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher publisher = client.listOfferingTransactionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        Represents the request to list the offering transaction history.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingTransactionsPublisher listOfferingTransactionsPaginator(
            ListOfferingTransactionsRequest listOfferingTransactionsRequest) {
        return new ListOfferingTransactionsPublisher(this, listOfferingTransactionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher publisher = client.listOfferingTransactionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingTransactionsPublisher publisher = client.listOfferingTransactionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferingTransactions(software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingTransactionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOfferingTransactionsRequest#builder()}
     * </p>
     *
     * @param listOfferingTransactionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsRequest.Builder} to create
     *        a request. Represents the request to list the offering transaction history.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferingTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOfferingTransactionsPublisher listOfferingTransactionsPaginator(
            Consumer<ListOfferingTransactionsRequest.Builder> listOfferingTransactionsRequest) {
        return listOfferingTransactionsPaginator(ListOfferingTransactionsRequest.builder()
                .applyMutation(listOfferingTransactionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact
     * <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param listOfferingsRequest
     *        Represents the request to list all offerings.
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings(ListOfferingsRequest listOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact
     * <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest.Builder} to create a request.
     *        Represents the request to list all offerings.
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest) {
        return listOfferings(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates
     * the recurring price per unit and the frequency for that offering. The API returns a <code>NotEligible</code>
     * error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact
     * <a href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings() {
        return listOfferings(ListOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator() {
        return listOfferingsPaginator(ListOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     *        Represents the request to list all offerings.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) {
        return new ListOfferingsPublisher(this, listOfferingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest.Builder} to create a request.
     *        Represents the request to list all offerings.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest) {
        return listOfferingsPaginator(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     *
     * @param listProjectsRequest
     *        Represents a request to the list projects operation.
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest.Builder} to create a request.
     *        Represents a request to the list projects operation.
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Gets information about projects.
     * </p>
     *
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects() {
        return listProjects(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator() {
        return listProjectsPaginator(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     *        Represents a request to the list projects operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(ListProjectsRequest listProjectsRequest) {
        return new ListProjectsPublisher(this, listProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest.Builder} to create a request.
     *        Represents a request to the list projects operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all currently running remote access sessions.
     * </p>
     *
     * @param listRemoteAccessSessionsRequest
     *        Represents the request to return information about the remote access session.
     * @return A Java Future containing the result of the ListRemoteAccessSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListRemoteAccessSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRemoteAccessSessionsResponse> listRemoteAccessSessions(
            ListRemoteAccessSessionsRequest listRemoteAccessSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all currently running remote access sessions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRemoteAccessSessionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListRemoteAccessSessionsRequest#builder()}
     * </p>
     *
     * @param listRemoteAccessSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListRemoteAccessSessionsRequest.Builder} to create
     *        a request. Represents the request to return information about the remote access session.
     * @return A Java Future containing the result of the ListRemoteAccessSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListRemoteAccessSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRemoteAccessSessionsResponse> listRemoteAccessSessions(
            Consumer<ListRemoteAccessSessionsRequest.Builder> listRemoteAccessSessionsRequest) {
        return listRemoteAccessSessions(ListRemoteAccessSessionsRequest.builder().applyMutation(listRemoteAccessSessionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     *
     * @param listRunsRequest
     *        Represents a request to the list runs operation.
     * @return A Java Future containing the result of the ListRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunsResponse> listRuns(ListRunsRequest listRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about runs, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunsRequest#builder()}
     * </p>
     *
     * @param listRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListRunsRequest.Builder} to create a request.
     *        Represents a request to the list runs operation.
     * @return A Java Future containing the result of the ListRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunsResponse> listRuns(Consumer<ListRunsRequest.Builder> listRunsRequest) {
        return listRuns(ListRunsRequest.builder().applyMutation(listRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)} operation.</b>
     * </p>
     *
     * @param listRunsRequest
     *        Represents a request to the list runs operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsPublisher listRunsPaginator(ListRunsRequest listRunsRequest) {
        return new ListRunsPublisher(this, listRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.devicefarm.model.ListRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunsRequest#builder()}
     * </p>
     *
     * @param listRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListRunsRequest.Builder} to create a request.
     *        Represents a request to the list runs operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsPublisher listRunsPaginator(Consumer<ListRunsRequest.Builder> listRunsRequest) {
        return listRunsPaginator(ListRunsRequest.builder().applyMutation(listRunsRequest).build());
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm job ARN.
     * </p>
     *
     * @param listSamplesRequest
     *        Represents a request to the list samples operation.
     * @return A Java Future containing the result of the ListSamples operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSamples
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSamplesResponse> listSamples(ListSamplesRequest listSamplesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about samples, given an AWS Device Farm job ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSamplesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSamplesRequest#builder()}
     * </p>
     *
     * @param listSamplesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest.Builder} to create a request.
     *        Represents a request to the list samples operation.
     * @return A Java Future containing the result of the ListSamples operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSamples
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSamplesResponse> listSamples(Consumer<ListSamplesRequest.Builder> listSamplesRequest) {
        return listSamples(ListSamplesRequest.builder().applyMutation(listSamplesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesPublisher publisher = client.listSamplesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesPublisher publisher = client.listSamplesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)} operation.</b>
     * </p>
     *
     * @param listSamplesRequest
     *        Represents a request to the list samples operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSamples
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamplesPublisher listSamplesPaginator(ListSamplesRequest listSamplesRequest) {
        return new ListSamplesPublisher(this, listSamplesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesPublisher publisher = client.listSamplesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSamplesPublisher publisher = client.listSamplesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSamples(software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSamplesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSamplesRequest#builder()}
     * </p>
     *
     * @param listSamplesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest.Builder} to create a request.
     *        Represents a request to the list samples operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSamples
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSamplesPublisher listSamplesPaginator(Consumer<ListSamplesRequest.Builder> listSamplesRequest) {
        return listSamplesPaginator(ListSamplesRequest.builder().applyMutation(listSamplesRequest).build());
    }

    /**
     * <p>
     * Gets information about test suites for a given job.
     * </p>
     *
     * @param listSuitesRequest
     *        Represents a request to the list suites operation.
     * @return A Java Future containing the result of the ListSuites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSuitesResponse> listSuites(ListSuitesRequest listSuitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about test suites for a given job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSuitesRequest#builder()}
     * </p>
     *
     * @param listSuitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest.Builder} to create a request.
     *        Represents a request to the list suites operation.
     * @return A Java Future containing the result of the ListSuites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSuitesResponse> listSuites(Consumer<ListSuitesRequest.Builder> listSuitesRequest) {
        return listSuites(ListSuitesRequest.builder().applyMutation(listSuitesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesPublisher publisher = client.listSuitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesPublisher publisher = client.listSuitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)} operation.</b>
     * </p>
     *
     * @param listSuitesRequest
     *        Represents a request to the list suites operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSuitesPublisher listSuitesPaginator(ListSuitesRequest listSuitesRequest) {
        return new ListSuitesPublisher(this, listSuitesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesPublisher publisher = client.listSuitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListSuitesPublisher publisher = client.listSuitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSuites(software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSuitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSuitesRequest#builder()}
     * </p>
     *
     * @param listSuitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest.Builder} to create a request.
     *        Represents a request to the list suites operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSuitesPublisher listSuitesPaginator(Consumer<ListSuitesRequest.Builder> listSuitesRequest) {
        return listSuitesPaginator(ListSuitesRequest.builder().applyMutation(listSuitesRequest).build());
    }

    /**
     * <p>
     * List the tags for an AWS Device Farm resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>TagOperationException The operation was not successful. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for an AWS Device Farm resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>TagOperationException The operation was not successful. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Gets a list of all Selenium testing projects in your account.
     * </p>
     *
     * @param listTestGridProjectsRequest
     * @return A Java Future containing the result of the ListTestGridProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestGridProjectsResponse> listTestGridProjects(
            ListTestGridProjectsRequest listTestGridProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all Selenium testing projects in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestGridProjectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestGridProjectsRequest#builder()}
     * </p>
     *
     * @param listTestGridProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTestGridProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestGridProjectsResponse> listTestGridProjects(
            Consumer<ListTestGridProjectsRequest.Builder> listTestGridProjectsRequest) {
        return listTestGridProjects(ListTestGridProjectsRequest.builder().applyMutation(listTestGridProjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestGridProjects(software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridProjectsPublisher publisher = client.listTestGridProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridProjectsPublisher publisher = client.listTestGridProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridProjects(software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestGridProjectsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestGridProjectsPublisher listTestGridProjectsPaginator(ListTestGridProjectsRequest listTestGridProjectsRequest) {
        return new ListTestGridProjectsPublisher(this, listTestGridProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestGridProjects(software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridProjectsPublisher publisher = client.listTestGridProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridProjectsPublisher publisher = client.listTestGridProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridProjects(software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestGridProjectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestGridProjectsRequest#builder()}
     * </p>
     *
     * @param listTestGridProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestGridProjectsPublisher listTestGridProjectsPaginator(
            Consumer<ListTestGridProjectsRequest.Builder> listTestGridProjectsRequest) {
        return listTestGridProjectsPaginator(ListTestGridProjectsRequest.builder().applyMutation(listTestGridProjectsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the actions taken in a <a>TestGridSession</a>.
     * </p>
     *
     * @param listTestGridSessionActionsRequest
     * @return A Java Future containing the result of the ListTestGridSessionActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestGridSessionActionsResponse> listTestGridSessionActions(
            ListTestGridSessionActionsRequest listTestGridSessionActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the actions taken in a <a>TestGridSession</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestGridSessionActionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTestGridSessionActionsRequest#builder()}
     * </p>
     *
     * @param listTestGridSessionActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTestGridSessionActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestGridSessionActionsResponse> listTestGridSessionActions(
            Consumer<ListTestGridSessionActionsRequest.Builder> listTestGridSessionActionsRequest) {
        return listTestGridSessionActions(ListTestGridSessionActionsRequest.builder()
                .applyMutation(listTestGridSessionActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestGridSessionActions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionActionsPublisher publisher = client.listTestGridSessionActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionActionsPublisher publisher = client.listTestGridSessionActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridSessionActions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestGridSessionActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestGridSessionActionsPublisher listTestGridSessionActionsPaginator(
            ListTestGridSessionActionsRequest listTestGridSessionActionsRequest) {
        return new ListTestGridSessionActionsPublisher(this, listTestGridSessionActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestGridSessionActions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionActionsPublisher publisher = client.listTestGridSessionActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionActionsPublisher publisher = client.listTestGridSessionActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridSessionActions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestGridSessionActionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTestGridSessionActionsRequest#builder()}
     * </p>
     *
     * @param listTestGridSessionActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessionActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestGridSessionActionsPublisher listTestGridSessionActionsPaginator(
            Consumer<ListTestGridSessionActionsRequest.Builder> listTestGridSessionActionsRequest) {
        return listTestGridSessionActionsPaginator(ListTestGridSessionActionsRequest.builder()
                .applyMutation(listTestGridSessionActionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of artifacts created during the session.
     * </p>
     *
     * @param listTestGridSessionArtifactsRequest
     * @return A Java Future containing the result of the ListTestGridSessionArtifacts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessionArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestGridSessionArtifactsResponse> listTestGridSessionArtifacts(
            ListTestGridSessionArtifactsRequest listTestGridSessionArtifactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of artifacts created during the session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestGridSessionArtifactsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTestGridSessionArtifactsRequest#builder()}
     * </p>
     *
     * @param listTestGridSessionArtifactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTestGridSessionArtifacts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessionArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestGridSessionArtifactsResponse> listTestGridSessionArtifacts(
            Consumer<ListTestGridSessionArtifactsRequest.Builder> listTestGridSessionArtifactsRequest) {
        return listTestGridSessionArtifacts(ListTestGridSessionArtifactsRequest.builder()
                .applyMutation(listTestGridSessionArtifactsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestGridSessionArtifacts(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionArtifactsPublisher publisher = client.listTestGridSessionArtifactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionArtifactsPublisher publisher = client.listTestGridSessionArtifactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridSessionArtifacts(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestGridSessionArtifactsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessionArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestGridSessionArtifactsPublisher listTestGridSessionArtifactsPaginator(
            ListTestGridSessionArtifactsRequest listTestGridSessionArtifactsRequest) {
        return new ListTestGridSessionArtifactsPublisher(this, listTestGridSessionArtifactsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestGridSessionArtifacts(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionArtifactsPublisher publisher = client.listTestGridSessionArtifactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionArtifactsPublisher publisher = client.listTestGridSessionArtifactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridSessionArtifacts(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestGridSessionArtifactsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTestGridSessionArtifactsRequest#builder()}
     * </p>
     *
     * @param listTestGridSessionArtifactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessionArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessionArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestGridSessionArtifactsPublisher listTestGridSessionArtifactsPaginator(
            Consumer<ListTestGridSessionArtifactsRequest.Builder> listTestGridSessionArtifactsRequest) {
        return listTestGridSessionArtifactsPaginator(ListTestGridSessionArtifactsRequest.builder()
                .applyMutation(listTestGridSessionArtifactsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of sessions for a <a>TestGridProject</a>.
     * </p>
     *
     * @param listTestGridSessionsRequest
     * @return A Java Future containing the result of the ListTestGridSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestGridSessionsResponse> listTestGridSessions(
            ListTestGridSessionsRequest listTestGridSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of sessions for a <a>TestGridProject</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestGridSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestGridSessionsRequest#builder()}
     * </p>
     *
     * @param listTestGridSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTestGridSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestGridSessionsResponse> listTestGridSessions(
            Consumer<ListTestGridSessionsRequest.Builder> listTestGridSessionsRequest) {
        return listTestGridSessions(ListTestGridSessionsRequest.builder().applyMutation(listTestGridSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestGridSessions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionsPublisher publisher = client.listTestGridSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionsPublisher publisher = client.listTestGridSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridSessions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestGridSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestGridSessionsPublisher listTestGridSessionsPaginator(ListTestGridSessionsRequest listTestGridSessionsRequest) {
        return new ListTestGridSessionsPublisher(this, listTestGridSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestGridSessions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionsPublisher publisher = client.listTestGridSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestGridSessionsPublisher publisher = client.listTestGridSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResult won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestGridSessions(software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestGridSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestGridSessionsRequest#builder()}
     * </p>
     *
     * @param listTestGridSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTestGridSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestGridSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestGridSessionsPublisher listTestGridSessionsPaginator(
            Consumer<ListTestGridSessionsRequest.Builder> listTestGridSessionsRequest) {
        return listTestGridSessionsPaginator(ListTestGridSessionsRequest.builder().applyMutation(listTestGridSessionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about tests in a given test suite.
     * </p>
     *
     * @param listTestsRequest
     *        Represents a request to the list tests operation.
     * @return A Java Future containing the result of the ListTests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestsResponse> listTests(ListTestsRequest listTestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about tests in a given test suite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestsRequest#builder()}
     * </p>
     *
     * @param listTestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestsRequest.Builder} to create a request.
     *        Represents a request to the list tests operation.
     * @return A Java Future containing the result of the ListTests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestsResponse> listTests(Consumer<ListTestsRequest.Builder> listTestsRequest) {
        return listTests(ListTestsRequest.builder().applyMutation(listTestsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsPublisher publisher = client.listTestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsPublisher publisher = client.listTestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)} operation.</b>
     * </p>
     *
     * @param listTestsRequest
     *        Represents a request to the list tests operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestsPublisher listTestsPaginator(ListTestsRequest listTestsRequest) {
        return new ListTestsPublisher(this, listTestsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsPublisher publisher = client.listTestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListTestsPublisher publisher = client.listTestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListTestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListTestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTests(software.amazon.awssdk.services.devicefarm.model.ListTestsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestsRequest#builder()}
     * </p>
     *
     * @param listTestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListTestsRequest.Builder} to create a request.
     *        Represents a request to the list tests operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListTests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestsPublisher listTestsPaginator(Consumer<ListTestsRequest.Builder> listTestsRequest) {
        return listTestsPaginator(ListTestsRequest.builder().applyMutation(listTestsRequest).build());
    }

    /**
     * <p>
     * Gets information about unique problems, such as exceptions or crashes.
     * </p>
     * <p>
     * Unique problems are defined as a single instance of an error across a run, job, or suite. For example, if a call
     * in your application consistently raises an exception (<code>OutOfBoundsException in MyActivity.java:386</code>),
     * <code>ListUniqueProblems</code> returns a single entry instead of many individual entries for that exception.
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        Represents a request to the list unique problems operation.
     * @return A Java Future containing the result of the ListUniqueProblems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUniqueProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUniqueProblemsResponse> listUniqueProblems(ListUniqueProblemsRequest listUniqueProblemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about unique problems, such as exceptions or crashes.
     * </p>
     * <p>
     * Unique problems are defined as a single instance of an error across a run, job, or suite. For example, if a call
     * in your application consistently raises an exception (<code>OutOfBoundsException in MyActivity.java:386</code>),
     * <code>ListUniqueProblems</code> returns a single entry instead of many individual entries for that exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUniqueProblemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUniqueProblemsRequest#builder()}
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest.Builder} to create a
     *        request. Represents a request to the list unique problems operation.
     * @return A Java Future containing the result of the ListUniqueProblems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUniqueProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUniqueProblemsResponse> listUniqueProblems(
            Consumer<ListUniqueProblemsRequest.Builder> listUniqueProblemsRequest) {
        return listUniqueProblems(ListUniqueProblemsRequest.builder().applyMutation(listUniqueProblemsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsPublisher publisher = client.listUniqueProblemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsPublisher publisher = client.listUniqueProblemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        Represents a request to the list unique problems operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUniqueProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUniqueProblemsPublisher listUniqueProblemsPaginator(ListUniqueProblemsRequest listUniqueProblemsRequest) {
        return new ListUniqueProblemsPublisher(this, listUniqueProblemsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsPublisher publisher = client.listUniqueProblemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUniqueProblemsPublisher publisher = client.listUniqueProblemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUniqueProblems(software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUniqueProblemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUniqueProblemsRequest#builder()}
     * </p>
     *
     * @param listUniqueProblemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest.Builder} to create a
     *        request. Represents a request to the list unique problems operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUniqueProblems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUniqueProblemsPublisher listUniqueProblemsPaginator(
            Consumer<ListUniqueProblemsRequest.Builder> listUniqueProblemsRequest) {
        return listUniqueProblemsPaginator(ListUniqueProblemsRequest.builder().applyMutation(listUniqueProblemsRequest).build());
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     *
     * @param listUploadsRequest
     *        Represents a request to the list uploads operation.
     * @return A Java Future containing the result of the ListUploads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUploadsResponse> listUploads(ListUploadsRequest listUploadsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about uploads, given an AWS Device Farm project ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUploadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUploadsRequest#builder()}
     * </p>
     *
     * @param listUploadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest.Builder} to create a request.
     *        Represents a request to the list uploads operation.
     * @return A Java Future containing the result of the ListUploads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUploadsResponse> listUploads(Consumer<ListUploadsRequest.Builder> listUploadsRequest) {
        return listUploads(ListUploadsRequest.builder().applyMutation(listUploadsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsPublisher publisher = client.listUploadsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsPublisher publisher = client.listUploadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)} operation.</b>
     * </p>
     *
     * @param listUploadsRequest
     *        Represents a request to the list uploads operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUploadsPublisher listUploadsPaginator(ListUploadsRequest listUploadsRequest) {
        return new ListUploadsPublisher(this, listUploadsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsPublisher publisher = client.listUploadsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devicefarm.paginators.ListUploadsPublisher publisher = client.listUploadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUploads(software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUploadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUploadsRequest#builder()}
     * </p>
     *
     * @param listUploadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest.Builder} to create a request.
     *        Represents a request to the list uploads operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUploadsPublisher listUploadsPaginator(Consumer<ListUploadsRequest.Builder> listUploadsRequest) {
        return listUploadsPaginator(ListUploadsRequest.builder().applyMutation(listUploadsRequest).build());
    }

    /**
     * <p>
     * Returns information about all Amazon Virtual Private Cloud (VPC) endpoint configurations in the AWS account.
     * </p>
     *
     * @param listVpceConfigurationsRequest
     * @return A Java Future containing the result of the ListVPCEConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListVPCEConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListVPCEConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVpceConfigurationsResponse> listVPCEConfigurations(
            ListVpceConfigurationsRequest listVpceConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all Amazon Virtual Private Cloud (VPC) endpoint configurations in the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpceConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVpceConfigurationsRequest#builder()}
     * </p>
     *
     * @param listVpceConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVPCEConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ListVPCEConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListVPCEConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVpceConfigurationsResponse> listVPCEConfigurations(
            Consumer<ListVpceConfigurationsRequest.Builder> listVpceConfigurationsRequest) {
        return listVPCEConfigurations(ListVpceConfigurationsRequest.builder().applyMutation(listVpceConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for
     * an offering, unless the renewal was overridden. The API returns a <code>NotEligible</code> error if the user is
     * not permitted to invoke the operation. If you must be able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param purchaseOfferingRequest
     *        Represents a request for a purchase offering.
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PurchaseOfferingResponse> purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for
     * an offering, unless the renewal was overridden. The API returns a <code>NotEligible</code> error if the user is
     * not permitted to invoke the operation. If you must be able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link PurchaseOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.PurchaseOfferingRequest.Builder} to create a
     *        request. Represents a request for a purchase offering.
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PurchaseOfferingResponse> purchaseOffering(
            Consumer<PurchaseOfferingRequest.Builder> purchaseOfferingRequest) {
        return purchaseOffering(PurchaseOfferingRequest.builder().applyMutation(purchaseOfferingRequest).build());
    }

    /**
     * <p>
     * Explicitly sets the quantity of devices to renew for an offering, starting from the <code>effectiveDate</code> of
     * the next period. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the
     * operation. If you must be able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     *
     * @param renewOfferingRequest
     *        A request that represents an offering renewal.
     * @return A Java Future containing the result of the RenewOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.RenewOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RenewOfferingResponse> renewOffering(RenewOfferingRequest renewOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Explicitly sets the quantity of devices to renew for an offering, starting from the <code>effectiveDate</code> of
     * the next period. The API returns a <code>NotEligible</code> error if the user is not permitted to invoke the
     * operation. If you must be able to invoke this operation, contact <a
     * href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RenewOfferingRequest.Builder} avoiding the need to
     * create one manually via {@link RenewOfferingRequest#builder()}
     * </p>
     *
     * @param renewOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest.Builder} to create a request.
     *        A request that represents an offering renewal.
     * @return A Java Future containing the result of the RenewOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>NotEligibleException Exception gets thrown when a user is not eligible to perform the specified
     *         transaction.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.RenewOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RenewOfferingResponse> renewOffering(Consumer<RenewOfferingRequest.Builder> renewOfferingRequest) {
        return renewOffering(RenewOfferingRequest.builder().applyMutation(renewOfferingRequest).build());
    }

    /**
     * <p>
     * Schedules a run.
     * </p>
     *
     * @param scheduleRunRequest
     *        Represents a request to the schedule run operation.
     * @return A Java Future containing the result of the ScheduleRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ScheduleRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ScheduleRunResponse> scheduleRun(ScheduleRunRequest scheduleRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Schedules a run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ScheduleRunRequest.Builder} avoiding the need to
     * create one manually via {@link ScheduleRunRequest#builder()}
     * </p>
     *
     * @param scheduleRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest.Builder} to create a request.
     *        Represents a request to the schedule run operation.
     * @return A Java Future containing the result of the ScheduleRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>IdempotencyException An entity with the same name already exists.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.ScheduleRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ScheduleRunResponse> scheduleRun(Consumer<ScheduleRunRequest.Builder> scheduleRunRequest) {
        return scheduleRun(ScheduleRunRequest.builder().applyMutation(scheduleRunRequest).build());
    }

    /**
     * <p>
     * Initiates a stop request for the current job. AWS Device Farm immediately stops the job on the device where tests
     * have not started. You are not billed for this device. On the device where tests have started, setup suite and
     * teardown suite tests run to completion on the device. You are billed for setup, teardown, and any tests that were
     * in progress or already completed.
     * </p>
     *
     * @param stopJobRequest
     * @return A Java Future containing the result of the StopJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.StopJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopJobResponse> stopJob(StopJobRequest stopJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a stop request for the current job. AWS Device Farm immediately stops the job on the device where tests
     * have not started. You are not billed for this device. On the device where tests have started, setup suite and
     * teardown suite tests run to completion on the device. You are billed for setup, teardown, and any tests that were
     * in progress or already completed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopJobRequest.Builder} avoiding the need to create
     * one manually via {@link StopJobRequest#builder()}
     * </p>
     *
     * @param stopJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.StopJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.StopJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopJobResponse> stopJob(Consumer<StopJobRequest.Builder> stopJobRequest) {
        return stopJob(StopJobRequest.builder().applyMutation(stopJobRequest).build());
    }

    /**
     * <p>
     * Ends a specified remote access session.
     * </p>
     *
     * @param stopRemoteAccessSessionRequest
     *        Represents the request to stop the remote access session.
     * @return A Java Future containing the result of the StopRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.StopRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopRemoteAccessSessionResponse> stopRemoteAccessSession(
            StopRemoteAccessSessionRequest stopRemoteAccessSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ends a specified remote access session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRemoteAccessSessionRequest.Builder} avoiding
     * the need to create one manually via {@link StopRemoteAccessSessionRequest#builder()}
     * </p>
     *
     * @param stopRemoteAccessSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest.Builder} to create
     *        a request. Represents the request to stop the remote access session.
     * @return A Java Future containing the result of the StopRemoteAccessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.StopRemoteAccessSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopRemoteAccessSessionResponse> stopRemoteAccessSession(
            Consumer<StopRemoteAccessSessionRequest.Builder> stopRemoteAccessSessionRequest) {
        return stopRemoteAccessSession(StopRemoteAccessSessionRequest.builder().applyMutation(stopRemoteAccessSessionRequest)
                .build());
    }

    /**
     * <p>
     * Initiates a stop request for the current test run. AWS Device Farm immediately stops the run on devices where
     * tests have not started. You are not billed for these devices. On devices where tests have started executing,
     * setup suite and teardown suite tests run to completion on those devices. You are billed for setup, teardown, and
     * any tests that were in progress or already completed.
     * </p>
     *
     * @param stopRunRequest
     *        Represents the request to stop a specific run.
     * @return A Java Future containing the result of the StopRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.StopRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopRunResponse> stopRun(StopRunRequest stopRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a stop request for the current test run. AWS Device Farm immediately stops the run on devices where
     * tests have not started. You are not billed for these devices. On devices where tests have started executing,
     * setup suite and teardown suite tests run to completion on those devices. You are billed for setup, teardown, and
     * any tests that were in progress or already completed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRunRequest.Builder} avoiding the need to create
     * one manually via {@link StopRunRequest#builder()}
     * </p>
     *
     * @param stopRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.StopRunRequest.Builder} to create a request.
     *        Represents the request to stop a specific run.
     * @return A Java Future containing the result of the StopRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.StopRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopRunResponse> stopRun(Consumer<StopRunRequest.Builder> stopRunRequest) {
        return stopRun(StopRunRequest.builder().applyMutation(stopRunRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>TagOperationException The operation was not successful. Try again.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>TagPolicyException The request doesn't comply with the AWS Identity and Access Management (IAM) tag
     *         policy. Correct your request and then retry it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>TagOperationException The operation was not successful. Try again.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>TagPolicyException The request doesn't comply with the AWS Identity and Access Management (IAM) tag
     *         policy. Correct your request and then retry it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>TagOperationException The operation was not successful. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>TagOperationException The operation was not successful. Try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates information about a private device instance.
     * </p>
     *
     * @param updateDeviceInstanceRequest
     * @return A Java Future containing the result of the UpdateDeviceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateDeviceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDeviceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceInstanceResponse> updateDeviceInstance(
            UpdateDeviceInstanceRequest updateDeviceInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about a private device instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeviceInstanceRequest#builder()}
     * </p>
     *
     * @param updateDeviceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDeviceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateDeviceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDeviceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceInstanceResponse> updateDeviceInstance(
            Consumer<UpdateDeviceInstanceRequest.Builder> updateDeviceInstanceRequest) {
        return updateDeviceInstance(UpdateDeviceInstanceRequest.builder().applyMutation(updateDeviceInstanceRequest).build());
    }

    /**
     * <p>
     * Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates
     * are all-or-nothing, meaning they can only be updated as a whole (or not at all).
     * </p>
     *
     * @param updateDevicePoolRequest
     *        Represents a request to the update device pool operation.
     * @return A Java Future containing the result of the UpdateDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDevicePoolResponse> updateDevicePool(UpdateDevicePoolRequest updateDevicePoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates
     * are all-or-nothing, meaning they can only be updated as a whole (or not at all).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDevicePoolRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDevicePoolRequest#builder()}
     * </p>
     *
     * @param updateDevicePoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolRequest.Builder} to create a
     *        request. Represents a request to the update device pool operation.
     * @return A Java Future containing the result of the UpdateDevicePool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateDevicePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDevicePoolResponse> updateDevicePool(
            Consumer<UpdateDevicePoolRequest.Builder> updateDevicePoolRequest) {
        return updateDevicePool(UpdateDevicePoolRequest.builder().applyMutation(updateDevicePoolRequest).build());
    }

    /**
     * <p>
     * Updates information about an existing private device instance profile.
     * </p>
     *
     * @param updateInstanceProfileRequest
     * @return A Java Future containing the result of the UpdateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInstanceProfileResponse> updateInstanceProfile(
            UpdateInstanceProfileRequest updateInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about an existing private device instance profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateInstanceProfileRequest#builder()}
     * </p>
     *
     * @param updateInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInstanceProfileResponse> updateInstanceProfile(
            Consumer<UpdateInstanceProfileRequest.Builder> updateInstanceProfileRequest) {
        return updateInstanceProfile(UpdateInstanceProfileRequest.builder().applyMutation(updateInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Updates the network profile.
     * </p>
     *
     * @param updateNetworkProfileRequest
     * @return A Java Future containing the result of the UpdateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkProfileResponse> updateNetworkProfile(
            UpdateNetworkProfileRequest updateNetworkProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the network profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNetworkProfileRequest#builder()}
     * </p>
     *
     * @param updateNetworkProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateNetworkProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkProfileResponse> updateNetworkProfile(
            Consumer<UpdateNetworkProfileRequest.Builder> updateNetworkProfileRequest) {
        return updateNetworkProfile(UpdateNetworkProfileRequest.builder().applyMutation(updateNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Modifies the specified project name, given the project ARN and a new name.
     * </p>
     *
     * @param updateProjectRequest
     *        Represents a request to the update project operation.
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified project name, given the project ARN and a new name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.UpdateProjectRequest.Builder} to create a request.
     *        Represents a request to the update project operation.
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest) {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    /**
     * <p>
     * Change details of a project.
     * </p>
     *
     * @param updateTestGridProjectRequest
     * @return A Java Future containing the result of the UpdateTestGridProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateTestGridProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTestGridProjectResponse> updateTestGridProject(
            UpdateTestGridProjectRequest updateTestGridProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Change details of a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTestGridProjectRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTestGridProjectRequest#builder()}
     * </p>
     *
     * @param updateTestGridProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTestGridProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>InternalServiceException An internal exception was raised in the service. Contact <a
     *         href="mailto:aws-devicefarm-support@amazon.com">aws-devicefarm-support@amazon.com</a> if you see this
     *         error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateTestGridProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateTestGridProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTestGridProjectResponse> updateTestGridProject(
            Consumer<UpdateTestGridProjectRequest.Builder> updateTestGridProjectRequest) {
        return updateTestGridProject(UpdateTestGridProjectRequest.builder().applyMutation(updateTestGridProjectRequest).build());
    }

    /**
     * <p>
     * Updates an uploaded test spec.
     * </p>
     *
     * @param updateUploadRequest
     * @return A Java Future containing the result of the UpdateUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUploadResponse> updateUpload(UpdateUploadRequest updateUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an uploaded test spec.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUploadRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUploadRequest#builder()}
     * </p>
     *
     * @param updateUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.UpdateUploadRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>LimitExceededException A limit was exceeded.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUploadResponse> updateUpload(Consumer<UpdateUploadRequest.Builder> updateUploadRequest) {
        return updateUpload(UpdateUploadRequest.builder().applyMutation(updateUploadRequest).build());
    }

    /**
     * <p>
     * Updates information about an Amazon Virtual Private Cloud (VPC) endpoint configuration.
     * </p>
     *
     * @param updateVpceConfigurationRequest
     * @return A Java Future containing the result of the UpdateVPCEConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>InvalidOperationException There was an error with the update request, or you do not have sufficient
     *         permissions to update this VPC endpoint configuration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVpceConfigurationResponse> updateVPCEConfiguration(
            UpdateVpceConfigurationRequest updateVpceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about an Amazon Virtual Private Cloud (VPC) endpoint configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpceConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateVpceConfigurationRequest#builder()}
     * </p>
     *
     * @param updateVpceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateVPCEConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ArgumentException An invalid argument was specified.</li>
     *         <li>NotFoundException The specified entity was not found.</li>
     *         <li>ServiceAccountException There was a problem with the service account.</li>
     *         <li>InvalidOperationException There was an error with the update request, or you do not have sufficient
     *         permissions to update this VPC endpoint configuration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DeviceFarmException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DeviceFarmAsyncClient.UpdateVPCEConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateVPCEConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVpceConfigurationResponse> updateVPCEConfiguration(
            Consumer<UpdateVpceConfigurationRequest.Builder> updateVpceConfigurationRequest) {
        return updateVPCEConfiguration(UpdateVpceConfigurationRequest.builder().applyMutation(updateVpceConfigurationRequest)
                .build());
    }

    @Override
    default DeviceFarmServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DeviceFarmAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DeviceFarmAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DeviceFarmAsyncClient}.
     */
    static DeviceFarmAsyncClientBuilder builder() {
        return new DefaultDeviceFarmAsyncClientBuilder();
    }
}
