/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.UploadCategory;
import software.amazon.awssdk.services.devicefarm.model.UploadStatus;
import software.amazon.awssdk.services.devicefarm.model.UploadType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Upload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Upload> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Upload.getter(Upload::arn)).setter(Upload.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Upload.getter(Upload::name)).setter(Upload.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(Upload.getter(Upload::created)).setter(Upload.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Upload.getter(Upload::typeAsString)).setter(Upload.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Upload.getter(Upload::statusAsString)).setter(Upload.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(Upload.getter(Upload::url)).setter(Upload.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadata").getter(Upload.getter(Upload::metadata)).setter(Upload.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(Upload.getter(Upload::contentType)).setter(Upload.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(Upload.getter(Upload::message)).setter(Upload.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(Upload.getter(Upload::categoryAsString)).setter(Upload.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, CREATED_FIELD, TYPE_FIELD, STATUS_FIELD, URL_FIELD, METADATA_FIELD, CONTENT_TYPE_FIELD, MESSAGE_FIELD, CATEGORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("created", CREATED_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("url", URL_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("contentType", CONTENT_TYPE_FIELD);
            this.put("message", MESSAGE_FIELD);
            this.put("category", CATEGORY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final Instant created;
    private final String type;
    private final String status;
    private final String url;
    private final String metadata;
    private final String contentType;
    private final String message;
    private final String category;

    private Upload(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.type = builder.type;
        this.status = builder.status;
        this.url = builder.url;
        this.metadata = builder.metadata;
        this.contentType = builder.contentType;
        this.message = builder.message;
        this.category = builder.category;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final Instant created() {
        return this.created;
    }

    public final UploadType type() {
        return UploadType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final UploadStatus status() {
        return UploadStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String url() {
        return this.url;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String message() {
        return this.message;
    }

    public final UploadCategory category() {
        return UploadCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Upload)) {
            return false;
        }
        Upload other = (Upload)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.categoryAsString(), other.categoryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Upload").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Created", (Object)this.created()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("Metadata", (Object)this.metadata()).add("ContentType", (Object)this.contentType()).add("Message", (Object)this.message()).add("Category", (Object)this.categoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Upload, T> g) {
        return obj -> g.apply((Upload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Instant created;
        private String type;
        private String status;
        private String url;
        private String metadata;
        private String contentType;
        private String message;
        private String category;

        private BuilderImpl() {
        }

        private BuilderImpl(Upload model) {
            this.arn(model.arn);
            this.name(model.name);
            this.created(model.created);
            this.type(model.type);
            this.status(model.status);
            this.url(model.url);
            this.metadata(model.metadata);
            this.contentType(model.contentType);
            this.message(model.message);
            this.category(model.category);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UploadType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UploadStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(UploadCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public Upload build() {
            return new Upload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Upload> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder created(Instant var1);

        public Builder type(String var1);

        public Builder type(UploadType var1);

        public Builder status(String var1);

        public Builder status(UploadStatus var1);

        public Builder url(String var1);

        public Builder metadata(String var1);

        public Builder contentType(String var1);

        public Builder message(String var1);

        public Builder category(String var1);

        public Builder category(UploadCategory var1);
    }
}

