/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list samples request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSamplesResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListSamplesResponse.Builder, ListSamplesResponse> {
    private static final SdkField<List<Sample>> SAMPLES_FIELD = SdkField
            .<List<Sample>> builder(MarshallingType.LIST)
            .getter(getter(ListSamplesResponse::samples))
            .setter(setter(Builder::samples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samples").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Sample> builder(MarshallingType.SDK_POJO)
                                            .constructor(Sample::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSamplesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Sample> samples;

    private final String nextToken;

    private ListSamplesResponse(BuilderImpl builder) {
        super(builder);
        this.samples = builder.samples;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the samples.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the samples.
     */
    public List<Sample> samples() {
        return samples;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(samples());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSamplesResponse)) {
            return false;
        }
        ListSamplesResponse other = (ListSamplesResponse) obj;
        return Objects.equals(samples(), other.samples()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListSamplesResponse").add("Samples", samples()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "samples":
            return Optional.ofNullable(clazz.cast(samples()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSamplesResponse, T> g) {
        return obj -> g.apply((ListSamplesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSamplesResponse> {
        /**
         * <p>
         * Information about the samples.
         * </p>
         * 
         * @param samples
         *        Information about the samples.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samples(Collection<Sample> samples);

        /**
         * <p>
         * Information about the samples.
         * </p>
         * 
         * @param samples
         *        Information about the samples.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samples(Sample... samples);

        /**
         * <p>
         * Information about the samples.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Sample>.Builder} avoiding the need to
         * create one manually via {@link List<Sample>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Sample>.Builder#build()} is called immediately and its
         * result is passed to {@link #samples(List<Sample>)}.
         * 
         * @param samples
         *        a consumer that will call methods on {@link List<Sample>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samples(List<Sample>)
         */
        Builder samples(Consumer<Sample.Builder>... samples);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<Sample> samples = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSamplesResponse model) {
            super(model);
            samples(model.samples);
            nextToken(model.nextToken);
        }

        public final Collection<Sample.Builder> getSamples() {
            return samples != null ? samples.stream().map(Sample::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder samples(Collection<Sample> samples) {
            this.samples = SamplesCopier.copy(samples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samples(Sample... samples) {
            samples(Arrays.asList(samples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samples(Consumer<Sample.Builder>... samples) {
            samples(Stream.of(samples).map(c -> Sample.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSamples(Collection<Sample.BuilderImpl> samples) {
            this.samples = SamplesCopier.copyFromBuilder(samples);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSamplesResponse build() {
            return new ListSamplesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
