/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the create upload operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUploadRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<CreateUploadRequest.Builder, CreateUploadRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUploadRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUploadRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUploadRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateUploadRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, CONTENT_TYPE_FIELD));

    private final String projectArn;

    private final String name;

    private final String type;

    private final String contentType;

    private CreateUploadRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.type = builder.type;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The ARN of the project for the upload.
     * </p>
     * 
     * @return The ARN of the project for the upload.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The upload's file name. The name should not contain the '/' character. If uploading an iOS app, the file name
     * needs to end with the <code>.ipa</code> extension. If uploading an Android app, the file name needs to end with
     * the <code>.apk</code> extension. For all others, the file name must end with the <code>.zip</code> file
     * extension.
     * </p>
     * 
     * @return The upload's file name. The name should not contain the '/' character. If uploading an iOS app, the file
     *         name needs to end with the <code>.ipa</code> extension. If uploading an Android app, the file name needs
     *         to end with the <code>.apk</code> extension. For all others, the file name must end with the
     *         <code>.zip</code> file extension.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The upload's upload type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID_APP: An Android upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS_APP: An iOS upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEB_APP: A web application upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXTERNAL_DATA: An external data upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_TEST_PACKAGE: A Calabash test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_TEST_PACKAGE: An XCode test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws an
     * <code>ArgumentException</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The upload's upload type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID_APP: An Android upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS_APP: An iOS upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEB_APP: A web application upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXTERNAL_DATA: An external data upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_TEST_PACKAGE: A Calabash test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_TEST_PACKAGE: An XCode test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm
     *         throws an <code>ArgumentException</code> error.
     * @see UploadType
     */
    public UploadType type() {
        return UploadType.fromValue(type);
    }

    /**
     * <p>
     * The upload's upload type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID_APP: An Android upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS_APP: An iOS upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEB_APP: A web application upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXTERNAL_DATA: An external data upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_TEST_PACKAGE: A Calabash test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_TEST_PACKAGE: An XCode test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws an
     * <code>ArgumentException</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The upload's upload type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID_APP: An Android upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS_APP: An iOS upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEB_APP: A web application upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXTERNAL_DATA: An external data upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_TEST_PACKAGE: A Calabash test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_TEST_PACKAGE: An XCode test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm
     *         throws an <code>ArgumentException</code> error.
     * @see UploadType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The upload's content type (for example, "application/octet-stream").
     * </p>
     * 
     * @return The upload's content type (for example, "application/octet-stream").
     */
    public String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadRequest)) {
            return false;
        }
        CreateUploadRequest other = (CreateUploadRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(contentType(), other.contentType());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateUploadRequest").add("ProjectArn", projectArn()).add("Name", name())
                .add("Type", typeAsString()).add("ContentType", contentType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUploadRequest, T> g) {
        return obj -> g.apply((CreateUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUploadRequest> {
        /**
         * <p>
         * The ARN of the project for the upload.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the project for the upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The upload's file name. The name should not contain the '/' character. If uploading an iOS app, the file name
         * needs to end with the <code>.ipa</code> extension. If uploading an Android app, the file name needs to end
         * with the <code>.apk</code> extension. For all others, the file name must end with the <code>.zip</code> file
         * extension.
         * </p>
         * 
         * @param name
         *        The upload's file name. The name should not contain the '/' character. If uploading an iOS app, the
         *        file name needs to end with the <code>.ipa</code> extension. If uploading an Android app, the file
         *        name needs to end with the <code>.apk</code> extension. For all others, the file name must end with
         *        the <code>.zip</code> file extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The upload's upload type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID_APP: An Android upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS_APP: An iOS upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEB_APP: A web application upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXTERNAL_DATA: An external data upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_TEST_PACKAGE: A Calabash test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_TEST_PACKAGE: An XCode test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws
         * an <code>ArgumentException</code> error.
         * </p>
         * 
         * @param type
         *        The upload's upload type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID_APP: An Android upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS_APP: An iOS upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEB_APP: A web application upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXTERNAL_DATA: An external data upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_TEST_PACKAGE: A Calabash test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_TEST_PACKAGE: An XCode test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm
         *        throws an <code>ArgumentException</code> error.
         * @see UploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadType
         */
        Builder type(String type);

        /**
         * <p>
         * The upload's upload type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID_APP: An Android upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS_APP: An iOS upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEB_APP: A web application upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXTERNAL_DATA: An external data upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_TEST_PACKAGE: A Calabash test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_TEST_PACKAGE: An XCode test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws
         * an <code>ArgumentException</code> error.
         * </p>
         * 
         * @param type
         *        The upload's upload type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID_APP: An Android upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS_APP: An iOS upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEB_APP: A web application upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXTERNAL_DATA: An external data upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_TEST_PACKAGE: A Calabash test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_TEST_PACKAGE: An XCode test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_SPEC: An XCode UI test spec upload.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm
         *        throws an <code>ArgumentException</code> error.
         * @see UploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadType
         */
        Builder type(UploadType type);

        /**
         * <p>
         * The upload's content type (for example, "application/octet-stream").
         * </p>
         * 
         * @param contentType
         *        The upload's content type (for example, "application/octet-stream").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String name;

        private String type;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadRequest model) {
            super(model);
            projectArn(model.projectArn);
            name(model.name);
            type(model.type);
            contentType(model.contentType);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UploadType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUploadRequest build() {
            return new CreateUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
