/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list suites request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSuitesResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListSuitesResponse.Builder, ListSuitesResponse> {
    private static final SdkField<List<Suite>> SUITES_FIELD = SdkField
            .<List<Suite>> builder(MarshallingType.LIST)
            .getter(getter(ListSuitesResponse::suites))
            .setter(setter(Builder::suites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suites").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Suite> builder(MarshallingType.SDK_POJO)
                                            .constructor(Suite::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSuitesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUITES_FIELD, NEXT_TOKEN_FIELD));

    private final List<Suite> suites;

    private final String nextToken;

    private ListSuitesResponse(BuilderImpl builder) {
        super(builder);
        this.suites = builder.suites;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the suites.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the suites.
     */
    public List<Suite> suites() {
        return suites;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suites());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuitesResponse)) {
            return false;
        }
        ListSuitesResponse other = (ListSuitesResponse) obj;
        return Objects.equals(suites(), other.suites()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListSuitesResponse").add("Suites", suites()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suites":
            return Optional.ofNullable(clazz.cast(suites()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSuitesResponse, T> g) {
        return obj -> g.apply((ListSuitesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSuitesResponse> {
        /**
         * <p>
         * Information about the suites.
         * </p>
         * 
         * @param suites
         *        Information about the suites.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suites(Collection<Suite> suites);

        /**
         * <p>
         * Information about the suites.
         * </p>
         * 
         * @param suites
         *        Information about the suites.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suites(Suite... suites);

        /**
         * <p>
         * Information about the suites.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Suite>.Builder} avoiding the need to create
         * one manually via {@link List<Suite>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Suite>.Builder#build()} is called immediately and its result
         * is passed to {@link #suites(List<Suite>)}.
         * 
         * @param suites
         *        a consumer that will call methods on {@link List<Suite>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suites(List<Suite>)
         */
        Builder suites(Consumer<Suite.Builder>... suites);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<Suite> suites = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuitesResponse model) {
            super(model);
            suites(model.suites);
            nextToken(model.nextToken);
        }

        public final Collection<Suite.Builder> getSuites() {
            return suites != null ? suites.stream().map(Suite::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suites(Collection<Suite> suites) {
            this.suites = SuitesCopier.copy(suites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suites(Suite... suites) {
            suites(Arrays.asList(suites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suites(Consumer<Suite.Builder>... suites) {
            suites(Stream.of(suites).map(c -> Suite.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuites(Collection<Suite.BuilderImpl> suites) {
            this.suites = SuitesCopier.copyFromBuilder(suites);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSuitesResponse build() {
            return new ListSuitesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
