/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get test request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetTestResponse.Builder, GetTestResponse> {
    private static final SdkField<Test> TEST_FIELD = SdkField.<Test> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetTestResponse::test)).setter(setter(Builder::test)).constructor(Test::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("test").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_FIELD));

    private final Test test;

    private GetTestResponse(BuilderImpl builder) {
        super(builder);
        this.test = builder.test;
    }

    /**
     * <p>
     * A test condition that is evaluated.
     * </p>
     * 
     * @return A test condition that is evaluated.
     */
    public Test test() {
        return test;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(test());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestResponse)) {
            return false;
        }
        GetTestResponse other = (GetTestResponse) obj;
        return Objects.equals(test(), other.test());
    }

    @Override
    public String toString() {
        return ToString.builder("GetTestResponse").add("Test", test()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "test":
            return Optional.ofNullable(clazz.cast(test()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTestResponse, T> g) {
        return obj -> g.apply((GetTestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTestResponse> {
        /**
         * <p>
         * A test condition that is evaluated.
         * </p>
         * 
         * @param test
         *        A test condition that is evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(Test test);

        /**
         * <p>
         * A test condition that is evaluated.
         * </p>
         * This is a convenience that creates an instance of the {@link Test.Builder} avoiding the need to create one
         * manually via {@link Test#builder()}.
         *
         * When the {@link Consumer} completes, {@link Test.Builder#build()} is called immediately and its result is
         * passed to {@link #test(Test)}.
         * 
         * @param test
         *        a consumer that will call methods on {@link Test.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #test(Test)
         */
        default Builder test(Consumer<Test.Builder> test) {
            return test(Test.builder().applyMutation(test).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Test test;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestResponse model) {
            super(model);
            test(model.test);
        }

        public final Test.Builder getTest() {
            return test != null ? test.toBuilder() : null;
        }

        @Override
        public final Builder test(Test test) {
            this.test = test;
            return this;
        }

        public final void setTest(Test.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        @Override
        public GetTestResponse build() {
            return new GetTestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
