/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the get device pool compatibility operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDevicePoolCompatibilityRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<GetDevicePoolCompatibilityRequest.Builder, GetDevicePoolCompatibilityRequest> {
    private static final SdkField<String> DEVICE_POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("devicePoolArn").getter(getter(GetDevicePoolCompatibilityRequest::devicePoolArn))
            .setter(setter(Builder::devicePoolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePoolArn").build()).build();

    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(GetDevicePoolCompatibilityRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> TEST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testType").getter(getter(GetDevicePoolCompatibilityRequest::testTypeAsString))
            .setter(setter(Builder::testType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testType").build()).build();

    private static final SdkField<ScheduleRunTest> TEST_FIELD = SdkField.<ScheduleRunTest> builder(MarshallingType.SDK_POJO)
            .memberName("test").getter(getter(GetDevicePoolCompatibilityRequest::test)).setter(setter(Builder::test))
            .constructor(ScheduleRunTest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("test").build()).build();

    private static final SdkField<ScheduleRunConfiguration> CONFIGURATION_FIELD = SdkField
            .<ScheduleRunConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(GetDevicePoolCompatibilityRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ScheduleRunConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_POOL_ARN_FIELD,
            APP_ARN_FIELD, TEST_TYPE_FIELD, TEST_FIELD, CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String devicePoolArn;

    private final String appArn;

    private final String testType;

    private final ScheduleRunTest test;

    private final ScheduleRunConfiguration configuration;

    private GetDevicePoolCompatibilityRequest(BuilderImpl builder) {
        super(builder);
        this.devicePoolArn = builder.devicePoolArn;
        this.appArn = builder.appArn;
        this.testType = builder.testType;
        this.test = builder.test;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The device pool's ARN.
     * </p>
     * 
     * @return The device pool's ARN.
     */
    public final String devicePoolArn() {
        return devicePoolArn;
    }

    /**
     * <p>
     * The ARN of the app that is associated with the specified device pool.
     * </p>
     * 
     * @return The ARN of the app that is associated with the specified device pool.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testType} will
     * return {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #testTypeAsString}.
     * </p>
     * 
     * @return The test type for the specified device pool.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI.
     *         </p>
     *         </li>
     * @see TestType
     */
    public final TestType testType() {
        return TestType.fromValue(testType);
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testType} will
     * return {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #testTypeAsString}.
     * </p>
     * 
     * @return The test type for the specified device pool.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI.
     *         </p>
     *         </li>
     * @see TestType
     */
    public final String testTypeAsString() {
        return testType;
    }

    /**
     * <p>
     * Information about the uploaded test to be run against the device pool.
     * </p>
     * 
     * @return Information about the uploaded test to be run against the device pool.
     */
    public final ScheduleRunTest test() {
        return test;
    }

    /**
     * <p>
     * An object that contains information about the settings for a run.
     * </p>
     * 
     * @return An object that contains information about the settings for a run.
     */
    public final ScheduleRunConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(devicePoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(testTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(test());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityRequest)) {
            return false;
        }
        GetDevicePoolCompatibilityRequest other = (GetDevicePoolCompatibilityRequest) obj;
        return Objects.equals(devicePoolArn(), other.devicePoolArn()) && Objects.equals(appArn(), other.appArn())
                && Objects.equals(testTypeAsString(), other.testTypeAsString()) && Objects.equals(test(), other.test())
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDevicePoolCompatibilityRequest").add("DevicePoolArn", devicePoolArn())
                .add("AppArn", appArn()).add("TestType", testTypeAsString()).add("Test", test())
                .add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devicePoolArn":
            return Optional.ofNullable(clazz.cast(devicePoolArn()));
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "testType":
            return Optional.ofNullable(clazz.cast(testTypeAsString()));
        case "test":
            return Optional.ofNullable(clazz.cast(test()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("devicePoolArn", DEVICE_POOL_ARN_FIELD);
        map.put("appArn", APP_ARN_FIELD);
        map.put("testType", TEST_TYPE_FIELD);
        map.put("test", TEST_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDevicePoolCompatibilityRequest, T> g) {
        return obj -> g.apply((GetDevicePoolCompatibilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDevicePoolCompatibilityRequest> {
        /**
         * <p>
         * The device pool's ARN.
         * </p>
         * 
         * @param devicePoolArn
         *        The device pool's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePoolArn(String devicePoolArn);

        /**
         * <p>
         * The ARN of the app that is associated with the specified device pool.
         * </p>
         * 
         * @param appArn
         *        The ARN of the app that is associated with the specified device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The test type for the specified device pool.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI.
         * </p>
         * </li>
         * </ul>
         * 
         * @param testType
         *        The test type for the specified device pool.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder testType(String testType);

        /**
         * <p>
         * The test type for the specified device pool.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI.
         * </p>
         * </li>
         * </ul>
         * 
         * @param testType
         *        The test type for the specified device pool.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder testType(TestType testType);

        /**
         * <p>
         * Information about the uploaded test to be run against the device pool.
         * </p>
         * 
         * @param test
         *        Information about the uploaded test to be run against the device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(ScheduleRunTest test);

        /**
         * <p>
         * Information about the uploaded test to be run against the device pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleRunTest.Builder} avoiding the
         * need to create one manually via {@link ScheduleRunTest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleRunTest.Builder#build()} is called immediately and its
         * result is passed to {@link #test(ScheduleRunTest)}.
         * 
         * @param test
         *        a consumer that will call methods on {@link ScheduleRunTest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #test(ScheduleRunTest)
         */
        default Builder test(Consumer<ScheduleRunTest.Builder> test) {
            return test(ScheduleRunTest.builder().applyMutation(test).build());
        }

        /**
         * <p>
         * An object that contains information about the settings for a run.
         * </p>
         * 
         * @param configuration
         *        An object that contains information about the settings for a run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ScheduleRunConfiguration configuration);

        /**
         * <p>
         * An object that contains information about the settings for a run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleRunConfiguration.Builder}
         * avoiding the need to create one manually via {@link ScheduleRunConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleRunConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(ScheduleRunConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ScheduleRunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ScheduleRunConfiguration)
         */
        default Builder configuration(Consumer<ScheduleRunConfiguration.Builder> configuration) {
            return configuration(ScheduleRunConfiguration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String devicePoolArn;

        private String appArn;

        private String testType;

        private ScheduleRunTest test;

        private ScheduleRunConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityRequest model) {
            super(model);
            devicePoolArn(model.devicePoolArn);
            appArn(model.appArn);
            testType(model.testType);
            test(model.test);
            configuration(model.configuration);
        }

        public final String getDevicePoolArn() {
            return devicePoolArn;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getTestType() {
            return testType;
        }

        public final void setTestType(String testType) {
            this.testType = testType;
        }

        @Override
        public final Builder testType(String testType) {
            this.testType = testType;
            return this;
        }

        @Override
        public final Builder testType(TestType testType) {
            this.testType(testType == null ? null : testType.toString());
            return this;
        }

        public final ScheduleRunTest.Builder getTest() {
            return test != null ? test.toBuilder() : null;
        }

        public final void setTest(ScheduleRunTest.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final ScheduleRunConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ScheduleRunConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ScheduleRunConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDevicePoolCompatibilityRequest build() {
            return new GetDevicePoolCompatibilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
