/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstanceProfilesResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListInstanceProfilesResponse.Builder, ListInstanceProfilesResponse> {
    private static final SdkField<List<InstanceProfile>> INSTANCE_PROFILES_FIELD = SdkField
            .<List<InstanceProfile>> builder(MarshallingType.LIST)
            .memberName("instanceProfiles")
            .getter(getter(ListInstanceProfilesResponse::instanceProfiles))
            .setter(setter(Builder::instanceProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInstanceProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PROFILES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InstanceProfile> instanceProfiles;

    private final String nextToken;

    private ListInstanceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceProfiles = builder.instanceProfiles;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceProfiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceProfiles() {
        return instanceProfiles != null && !(instanceProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains information about your instance profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceProfiles} method.
     * </p>
     * 
     * @return An object that contains information about your instance profiles.
     */
    public final List<InstanceProfile> instanceProfiles() {
        return instanceProfiles;
    }

    /**
     * <p>
     * An identifier that can be used in the next call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier that can be used in the next call to this operation to return the next set of items in the
     *         list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceProfiles() ? instanceProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceProfilesResponse)) {
            return false;
        }
        ListInstanceProfilesResponse other = (ListInstanceProfilesResponse) obj;
        return hasInstanceProfiles() == other.hasInstanceProfiles()
                && Objects.equals(instanceProfiles(), other.instanceProfiles()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstanceProfilesResponse")
                .add("InstanceProfiles", hasInstanceProfiles() ? instanceProfiles() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceProfiles":
            return Optional.ofNullable(clazz.cast(instanceProfiles()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceProfiles", INSTANCE_PROFILES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceProfilesResponse, T> g) {
        return obj -> g.apply((ListInstanceProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInstanceProfilesResponse> {
        /**
         * <p>
         * An object that contains information about your instance profiles.
         * </p>
         * 
         * @param instanceProfiles
         *        An object that contains information about your instance profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles);

        /**
         * <p>
         * An object that contains information about your instance profiles.
         * </p>
         * 
         * @param instanceProfiles
         *        An object that contains information about your instance profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfiles(InstanceProfile... instanceProfiles);

        /**
         * <p>
         * An object that contains information about your instance profiles.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devicefarm.model.InstanceProfile.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.devicefarm.model.InstanceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devicefarm.model.InstanceProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceProfiles(List<InstanceProfile>)}.
         * 
         * @param instanceProfiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devicefarm.model.InstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceProfiles(java.util.Collection<InstanceProfile>)
         */
        Builder instanceProfiles(Consumer<InstanceProfile.Builder>... instanceProfiles);

        /**
         * <p>
         * An identifier that can be used in the next call to this operation to return the next set of items in the
         * list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that can be used in the next call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<InstanceProfile> instanceProfiles = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceProfilesResponse model) {
            super(model);
            instanceProfiles(model.instanceProfiles);
            nextToken(model.nextToken);
        }

        public final List<InstanceProfile.Builder> getInstanceProfiles() {
            List<InstanceProfile.Builder> result = InstanceProfilesCopier.copyToBuilder(this.instanceProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceProfiles(Collection<InstanceProfile.BuilderImpl> instanceProfiles) {
            this.instanceProfiles = InstanceProfilesCopier.copyFromBuilder(instanceProfiles);
        }

        @Override
        public final Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles) {
            this.instanceProfiles = InstanceProfilesCopier.copy(instanceProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(InstanceProfile... instanceProfiles) {
            instanceProfiles(Arrays.asList(instanceProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(Consumer<InstanceProfile.Builder>... instanceProfiles) {
            instanceProfiles(Stream.of(instanceProfiles).map(c -> InstanceProfile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInstanceProfilesResponse build() {
            return new ListInstanceProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
