/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVpceConfigurationsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListVpceConfigurationsResponse.Builder, ListVpceConfigurationsResponse> {
    private static final SdkField<List<VPCEConfiguration>> VPCE_CONFIGURATIONS_FIELD = SdkField
            .<List<VPCEConfiguration>> builder(MarshallingType.LIST)
            .memberName("vpceConfigurations")
            .getter(getter(ListVpceConfigurationsResponse::vpceConfigurations))
            .setter(setter(Builder::vpceConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VPCEConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(VPCEConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVpceConfigurationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPCE_CONFIGURATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VPCEConfiguration> vpceConfigurations;

    private final String nextToken;

    private ListVpceConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.vpceConfigurations = builder.vpceConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpceConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpceConfigurations() {
        return vpceConfigurations != null && !(vpceConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
     * configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpceConfigurations} method.
     * </p>
     * 
     * @return An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
     *         configuration.
     */
    public final List<VPCEConfiguration> vpceConfigurations() {
        return vpceConfigurations;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVpceConfigurations() ? vpceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpceConfigurationsResponse)) {
            return false;
        }
        ListVpceConfigurationsResponse other = (ListVpceConfigurationsResponse) obj;
        return hasVpceConfigurations() == other.hasVpceConfigurations()
                && Objects.equals(vpceConfigurations(), other.vpceConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVpceConfigurationsResponse")
                .add("VpceConfigurations", hasVpceConfigurations() ? vpceConfigurations() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpceConfigurations":
            return Optional.ofNullable(clazz.cast(vpceConfigurations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vpceConfigurations", VPCE_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpceConfigurationsResponse, T> g) {
        return obj -> g.apply((ListVpceConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVpceConfigurationsResponse> {
        /**
         * <p>
         * An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
         * configuration.
         * </p>
         * 
         * @param vpceConfigurations
         *        An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurations(Collection<VPCEConfiguration> vpceConfigurations);

        /**
         * <p>
         * An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
         * configuration.
         * </p>
         * 
         * @param vpceConfigurations
         *        An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurations(VPCEConfiguration... vpceConfigurations);

        /**
         * <p>
         * An array of <code>VPCEConfiguration</code> objects that contain information about your VPC endpoint
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vpceConfigurations(List<VPCEConfiguration>)}.
         * 
         * @param vpceConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpceConfigurations(java.util.Collection<VPCEConfiguration>)
         */
        Builder vpceConfigurations(Consumer<VPCEConfiguration.Builder>... vpceConfigurations);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<VPCEConfiguration> vpceConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpceConfigurationsResponse model) {
            super(model);
            vpceConfigurations(model.vpceConfigurations);
            nextToken(model.nextToken);
        }

        public final List<VPCEConfiguration.Builder> getVpceConfigurations() {
            List<VPCEConfiguration.Builder> result = VPCEConfigurationsCopier.copyToBuilder(this.vpceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpceConfigurations(Collection<VPCEConfiguration.BuilderImpl> vpceConfigurations) {
            this.vpceConfigurations = VPCEConfigurationsCopier.copyFromBuilder(vpceConfigurations);
        }

        @Override
        public final Builder vpceConfigurations(Collection<VPCEConfiguration> vpceConfigurations) {
            this.vpceConfigurations = VPCEConfigurationsCopier.copy(vpceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurations(VPCEConfiguration... vpceConfigurations) {
            vpceConfigurations(Arrays.asList(vpceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurations(Consumer<VPCEConfiguration.Builder>... vpceConfigurations) {
            vpceConfigurations(Stream.of(vpceConfigurations).map(c -> VPCEConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVpceConfigurationsResponse build() {
            return new ListVpceConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
