/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an Amazon Virtual Private Cloud (VPC) endpoint configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VPCEConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VPCEConfiguration.Builder, VPCEConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(VPCEConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> VPCE_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpceConfigurationName").getter(getter(VPCEConfiguration::vpceConfigurationName))
            .setter(setter(Builder::vpceConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationName").build())
            .build();

    private static final SdkField<String> VPCE_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpceServiceName").getter(getter(VPCEConfiguration::vpceServiceName))
            .setter(setter(Builder::vpceServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceServiceName").build()).build();

    private static final SdkField<String> SERVICE_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceDnsName").getter(getter(VPCEConfiguration::serviceDnsName))
            .setter(setter(Builder::serviceDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDnsName").build()).build();

    private static final SdkField<String> VPCE_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("vpceConfigurationDescription")
            .getter(getter(VPCEConfiguration::vpceConfigurationDescription))
            .setter(setter(Builder::vpceConfigurationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ARN_FIELD, VPCE_CONFIGURATION_NAME_FIELD, VPCE_SERVICE_NAME_FIELD,
                    SERVICE_DNS_NAME_FIELD, VPCE_CONFIGURATION_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String vpceConfigurationName;

    private final String vpceServiceName;

    private final String serviceDnsName;

    private final String vpceConfigurationDescription;

    private VPCEConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.vpceConfigurationName = builder.vpceConfigurationName;
        this.vpceServiceName = builder.vpceServiceName;
        this.serviceDnsName = builder.serviceDnsName;
        this.vpceConfigurationDescription = builder.vpceConfigurationDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the VPC endpoint configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the VPC endpoint configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The friendly name you give to your VPC endpoint configuration to manage your configurations more easily.
     * </p>
     * 
     * @return The friendly name you give to your VPC endpoint configuration to manage your configurations more easily.
     */
    public final String vpceConfigurationName() {
        return vpceConfigurationName;
    }

    /**
     * <p>
     * The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.
     * </p>
     * 
     * @return The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.
     */
    public final String vpceServiceName() {
        return vpceServiceName;
    }

    /**
     * <p>
     * The DNS name that maps to the private IP address of the service you want to access.
     * </p>
     * 
     * @return The DNS name that maps to the private IP address of the service you want to access.
     */
    public final String serviceDnsName() {
        return serviceDnsName;
    }

    /**
     * <p>
     * An optional description that provides details about your VPC endpoint configuration.
     * </p>
     * 
     * @return An optional description that provides details about your VPC endpoint configuration.
     */
    public final String vpceConfigurationDescription() {
        return vpceConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(vpceServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfigurationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPCEConfiguration)) {
            return false;
        }
        VPCEConfiguration other = (VPCEConfiguration) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(vpceConfigurationName(), other.vpceConfigurationName())
                && Objects.equals(vpceServiceName(), other.vpceServiceName())
                && Objects.equals(serviceDnsName(), other.serviceDnsName())
                && Objects.equals(vpceConfigurationDescription(), other.vpceConfigurationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VPCEConfiguration").add("Arn", arn()).add("VpceConfigurationName", vpceConfigurationName())
                .add("VpceServiceName", vpceServiceName()).add("ServiceDnsName", serviceDnsName())
                .add("VpceConfigurationDescription", vpceConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "vpceConfigurationName":
            return Optional.ofNullable(clazz.cast(vpceConfigurationName()));
        case "vpceServiceName":
            return Optional.ofNullable(clazz.cast(vpceServiceName()));
        case "serviceDnsName":
            return Optional.ofNullable(clazz.cast(serviceDnsName()));
        case "vpceConfigurationDescription":
            return Optional.ofNullable(clazz.cast(vpceConfigurationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("vpceConfigurationName", VPCE_CONFIGURATION_NAME_FIELD);
        map.put("vpceServiceName", VPCE_SERVICE_NAME_FIELD);
        map.put("serviceDnsName", SERVICE_DNS_NAME_FIELD);
        map.put("vpceConfigurationDescription", VPCE_CONFIGURATION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VPCEConfiguration, T> g) {
        return obj -> g.apply((VPCEConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VPCEConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the VPC endpoint configuration.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The friendly name you give to your VPC endpoint configuration to manage your configurations more easily.
         * </p>
         * 
         * @param vpceConfigurationName
         *        The friendly name you give to your VPC endpoint configuration to manage your configurations more
         *        easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationName(String vpceConfigurationName);

        /**
         * <p>
         * The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.
         * </p>
         * 
         * @param vpceServiceName
         *        The name of the VPC endpoint service running in your AWS account that you want Device Farm to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceServiceName(String vpceServiceName);

        /**
         * <p>
         * The DNS name that maps to the private IP address of the service you want to access.
         * </p>
         * 
         * @param serviceDnsName
         *        The DNS name that maps to the private IP address of the service you want to access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDnsName(String serviceDnsName);

        /**
         * <p>
         * An optional description that provides details about your VPC endpoint configuration.
         * </p>
         * 
         * @param vpceConfigurationDescription
         *        An optional description that provides details about your VPC endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurationDescription(String vpceConfigurationDescription);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String vpceConfigurationName;

        private String vpceServiceName;

        private String serviceDnsName;

        private String vpceConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(VPCEConfiguration model) {
            arn(model.arn);
            vpceConfigurationName(model.vpceConfigurationName);
            vpceServiceName(model.vpceServiceName);
            serviceDnsName(model.serviceDnsName);
            vpceConfigurationDescription(model.vpceConfigurationDescription);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVpceConfigurationName() {
            return vpceConfigurationName;
        }

        public final void setVpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
        }

        @Override
        public final Builder vpceConfigurationName(String vpceConfigurationName) {
            this.vpceConfigurationName = vpceConfigurationName;
            return this;
        }

        public final String getVpceServiceName() {
            return vpceServiceName;
        }

        public final void setVpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
        }

        @Override
        public final Builder vpceServiceName(String vpceServiceName) {
            this.vpceServiceName = vpceServiceName;
            return this;
        }

        public final String getServiceDnsName() {
            return serviceDnsName;
        }

        public final void setServiceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
        }

        @Override
        public final Builder serviceDnsName(String serviceDnsName) {
            this.serviceDnsName = serviceDnsName;
            return this;
        }

        public final String getVpceConfigurationDescription() {
            return vpceConfigurationDescription;
        }

        public final void setVpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
        }

        @Override
        public final Builder vpceConfigurationDescription(String vpceConfigurationDescription) {
            this.vpceConfigurationDescription = vpceConfigurationDescription;
            return this;
        }

        @Override
        public VPCEConfiguration build() {
            return new VPCEConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
